/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.server.impl;

import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalInterfaceReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalServerReader;
import com.excentis.products.byteblower.model.reader.server.impl.PhysicalDockableReaderImpl;
import com.excentis.products.byteblower.model.reader.server.impl.PhysicalPortReaderImpl;
import com.excentis.products.byteblower.model.reader.server.impl.PhysicalServerReaderImpl;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.InterfaceLinkStatus;
import com.excentis.products.byteblower.server.model.InterfaceType;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalInterface;
import com.excentis.products.byteblower.server.model.PhysicalPort;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class PhysicalInterfaceReaderImpl
extends PhysicalDockableReaderImpl<PhysicalInterface>
implements PhysicalInterfaceReader {
    public PhysicalInterfaceReaderImpl(PhysicalInterface myPhysicalInterface) {
        super(myPhysicalInterface);
    }

    @Override
    public InterfaceType getInterfaceType() {
        return ((PhysicalInterface)this.getObject()).getInterfaceType();
    }

    @Override
    public InterfaceLinkStatus getInterfaceLinkStatus() {
        return ((PhysicalInterface)this.getObject()).getInterfaceLinkStatus();
    }

    @Override
    public String getMacAddressString() {
        return ((PhysicalInterface)this.getObject()).getMacAddress();
    }

    @Override
    public String getInterfaceId() {
        return ((PhysicalInterface)this.getObject()).getId();
    }

    @Override
    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        String configInterfaceId;
        String configServerAddress;
        if (!portConfigReader.isDocked()) {
            return null;
        }
        PhysicalServerReader serverReader = this.getPhysicalServerReader();
        String myServerAddress = serverReader.getServerAddress();
        if (!myServerAddress.equals(configServerAddress = portConfigReader.getServerAddress())) {
            return null;
        }
        String myIntegerId = this.getInterfaceId();
        if (!myIntegerId.equals(configInterfaceId = portConfigReader.getPhysicalInterfaceId())) {
            return null;
        }
        PhysicalDockable physicalDockable = null;
        if (portConfigReader.isDockedOnPhysicalPort()) {
            Integer portId = portConfigReader.getPhysicalPortId();
            for (PhysicalPortReader reader : this.getPhysicalPortReaders()) {
                if (!reader.getPortId().equals(portId)) continue;
                return reader.getPhysicalDockable(portConfigReader);
            }
        } else {
            physicalDockable = (PhysicalDockable)this.getObject();
        }
        return physicalDockable;
    }

    @Override
    public PhysicalServerReader getPhysicalServerReader() {
        return new PhysicalServerReaderImpl(this.getServer());
    }

    public PhysicalServer getServer() {
        return ((PhysicalInterface)this.getObject()).getPhysicalServer();
    }

    @Override
    public List<PhysicalPortReader> getPhysicalPortReaders() {
        ArrayList<PhysicalPortReader> readers = new ArrayList<PhysicalPortReader>();
        for (PhysicalPort physicalPort : this.getPhysicalPorts()) {
            readers.add(new PhysicalPortReaderImpl(physicalPort));
        }
        return readers;
    }

    @Override
    public EList<PhysicalPort> getPhysicalPorts() {
        return ((PhysicalInterface)this.getObject()).getPhysicalPort();
    }

    @Override
    public PhysicalPortReader getPhysicalPortReader(Integer portId) {
        for (PhysicalPort physicalPort : this.getPhysicalPorts()) {
            if (physicalPort.getId() != portId) continue;
            return ReaderFactory.create(physicalPort);
        }
        return null;
    }

    @Override
    public int getNofPhysicalPorts() {
        return this.getPhysicalPorts().size();
    }

    @Override
    public Integer getStatus() {
        PhysicalServer myPhysicalServer = this.getServer();
        if (myPhysicalServer != null) {
            switch (myPhysicalServer.getServerLinkStatus().getValue()) {
                case 2: {
                    return this.getInterfaceStatus();
                }
                case 0: {
                    return 1;
                }
            }
        }
        return 2;
    }

    private int getInterfaceStatus() {
        switch (this.getInterfaceLinkStatus().getValue()) {
            case 2: {
                return 3;
            }
            case 0: 
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public List<DockedByteBlowerPortReader> getDockedPortReaders() {
        List<DockedByteBlowerPortReader> readers = super.getDockedPortReaders();
        for (PhysicalPortReader portReader : this.getPhysicalPortReaders()) {
            readers.addAll(portReader.getDockedPortReaders());
        }
        return readers;
    }

    @Override
    public EList<DockedByteBlowerPort> getAllDockedPorts() {
        EList<DockedByteBlowerPort> dockedPorts = super.getDockedPorts();
        UniqueEList allDockedPorts = new UniqueEList(dockedPorts);
        for (PhysicalPortReader reader : this.getPhysicalPortReaders()) {
            allDockedPorts.addAll(reader.getDockedPorts());
        }
        return allDockedPorts;
    }

    @Override
    public int getInterfaceNumber() {
        PhysicalInterface thisInterface = (PhysicalInterface)this.getObject();
        InterfaceType thisType = this.getInterfaceType();
        int number = 0;
        if (this.isContained()) {
            PhysicalServerReader serverReader = this.getPhysicalServerReader();
            for (PhysicalInterfaceReader interfaceReader : serverReader.getPhysicalInterfaceReaders()) {
                if (interfaceReader.getInterfaceType() == thisType) {
                    ++number;
                }
                if (interfaceReader.getObject() == thisInterface) break;
            }
        }
        return number;
    }

    @Override
    public String getInterfaceString() {
        String text = "";
        PhysicalInterface interf = (PhysicalInterface)this.getObject();
        int interfaceNumber = this.getInterfaceNumber();
        switch (interf.getInterfaceType()) {
            case TRUNKING: {
                text = String.valueOf(text) + "trunk-" + interfaceNumber;
                break;
            }
            case NONTRUNKING: {
                text = String.valueOf(text) + "nontrunk-" + interfaceNumber;
                break;
            }
            case USB: {
                String deviceDescription = "";
                if (interf.getVendor() != null && interf.getVendor().length() != 0) {
                    deviceDescription = String.valueOf(deviceDescription) + interf.getVendor();
                }
                if (interf.getProduct() != null && interf.getProduct().length() != 0) {
                    if (text.length() != 0) {
                        deviceDescription = String.valueOf(deviceDescription) + " ";
                    }
                    deviceDescription = String.valueOf(deviceDescription) + interf.getProduct();
                }
                if (deviceDescription.length() != 0) {
                    text = String.valueOf(text) + " " + deviceDescription;
                    break;
                }
                text = String.valueOf(text) + "Unidentified USB device.";
                break;
            }
            default: {
                text = String.valueOf(text) + "unknown";
            }
        }
        return text;
    }

    @Override
    public String getDetailedInterfaceString() {
        PhysicalInterface interf = (PhysicalInterface)this.getObject();
        String text = String.valueOf(interf.getName()) + " - ";
        text = String.valueOf(text) + this.getInterfaceString();
        return text;
    }

    @Override
    public EList<PhysicalDockable> getDockables() {
        UniqueEList dockables = new UniqueEList();
        InterfaceType type = this.getInterfaceType();
        if (type == InterfaceType.TRUNKING) {
            List<PhysicalPortReader> readers = this.getPhysicalPortReaders();
            for (PhysicalPortReader portReader : readers) {
                dockables.addAll(portReader.getDockables());
            }
        } else if (type == InterfaceType.NONTRUNKING) {
            dockables.add((Object)((PhysicalDockable)this.getObject()));
        }
        return dockables;
    }

    @Override
    public boolean isNonTrunking() {
        return this.getInterfaceType() == InterfaceType.NONTRUNKING;
    }
}

