/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.server.impl;

import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalInterfaceReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalServerReader;
import com.excentis.products.byteblower.model.reader.server.impl.AbstractServerReaderImpl;
import com.excentis.products.byteblower.model.reader.server.impl.PhysicalInterfaceReaderImpl;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalInterface;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import com.excentis.products.byteblower.server.model.ServerLinkStatus;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.osgi.framework.Version;

public class PhysicalServerReaderImpl
extends AbstractServerReaderImpl<PhysicalServer>
implements PhysicalServerReader {
    private static final Logger LOGGER = Logger.getGlobal();

    public PhysicalServerReaderImpl(PhysicalServer myPhysicalServer) {
        super(myPhysicalServer);
    }

    @Override
    public boolean isAvahiAvailable() {
        return ((PhysicalServer)this.getObject()).isAvahiAvailable();
    }

    @Override
    public ServerLinkStatus getServerLinkStatus() {
        return ((PhysicalServer)this.getObject()).getServerLinkStatus();
    }

    @Override
    public String getServerAddress() {
        return ((PhysicalServer)this.getObject()).getAddress();
    }

    @Override
    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        String thisServerAddress;
        if (!portConfigReader.isDocked()) {
            return null;
        }
        String configServerAddress = portConfigReader.getServerAddress();
        if (!configServerAddress.equals(thisServerAddress = this.getServerAddress())) {
            return null;
        }
        String interfaceId = portConfigReader.getPhysicalInterfaceId();
        for (PhysicalInterfaceReader reader : this.getPhysicalInterfaceReaders()) {
            if (!reader.getInterfaceId().equals(interfaceId)) continue;
            return reader.getPhysicalDockable(portConfigReader);
        }
        return null;
    }

    @Override
    public List<PhysicalInterfaceReader> getPhysicalInterfaceReaders() {
        ArrayList<PhysicalInterfaceReader> readers = new ArrayList<PhysicalInterfaceReader>();
        for (PhysicalInterface physicalInterface : this.getPhysicalInterfaces()) {
            readers.add(new PhysicalInterfaceReaderImpl(physicalInterface));
        }
        return readers;
    }

    @Override
    public EList<PhysicalDockable> getDockables() {
        UniqueEList dockables = new UniqueEList();
        List<PhysicalInterfaceReader> readers = this.getPhysicalInterfaceReaders();
        for (PhysicalInterfaceReader interfaceReader : readers) {
            dockables.addAll(interfaceReader.getDockables());
        }
        return dockables;
    }

    @Override
    public List<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        ArrayList<DockedByteBlowerPortReader> dockedPortReaders = new ArrayList<DockedByteBlowerPortReader>();
        List<PhysicalInterfaceReader> readers = this.getPhysicalInterfaceReaders();
        for (PhysicalInterfaceReader interfaceReader : readers) {
            dockedPortReaders.addAll(interfaceReader.getAllDockedPortReaders());
        }
        return dockedPortReaders;
    }

    @Override
    public EList<PhysicalInterface> getPhysicalInterfaces() {
        EList interfaces = ((PhysicalServer)this.getObject()).getPhysicalInterface();
        ECollections.sort((EList)interfaces, (Comparator)new Comparator<PhysicalInterface>(){

            @Override
            public int compare(PhysicalInterface i1, PhysicalInterface i2) {
                return i1.getId().compareTo(i2.getId());
            }
        });
        return interfaces;
    }

    @Override
    public PhysicalInterfaceReader getPhysicalInterfaceReader(String interfaceId) {
        if (interfaceId == null) {
            return null;
        }
        for (PhysicalInterface physicalInterface : this.getPhysicalInterfaces()) {
            if (!interfaceId.equals(physicalInterface.getId())) continue;
            return ReaderFactory.create(physicalInterface);
        }
        return null;
    }

    @Override
    public int getNofInterfaces() {
        return this.getPhysicalInterfaces().size();
    }

    @Override
    public Version getCurrentVersion() {
        try {
            return Version.parseVersion((String)((PhysicalServer)this.getObject()).getVersion());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.FINEST, "Version String of Physical Server deviates from default format, can not parse", ex);
            return Version.emptyVersion;
        }
    }

    @Override
    public boolean hasUpdateAvailable() {
        Version latestVersion = this.getLatestVersion();
        return this.getCurrentVersion().compareTo(latestVersion) < 0;
    }
}

