/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FrameL4Type implements Enumerator
{
    NONE_LITERAL(0, "None", "None"),
    TCP_LITERAL(1, "TCP", "TCP"),
    UDP_LITERAL(2, "UDP", "UDP");

    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int NONE = 0;
    public static final int TCP = 1;
    public static final int UDP = 2;
    private static final FrameL4Type[] VALUES_ARRAY;
    public static final List<FrameL4Type> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FrameL4Type[]{NONE_LITERAL, TCP_LITERAL, UDP_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FrameL4Type get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FrameL4Type result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FrameL4Type getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FrameL4Type result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FrameL4Type get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return TCP_LITERAL;
            }
            case 2: {
                return UDP_LITERAL;
            }
        }
        return null;
    }

    private FrameL4Type(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

