/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RetransmissionPolicy implements Enumerator
{
    FIXED_TIMING(1, "Fixed Timing", "FixedTiming"),
    RFC_SUGGESTED(2, "RFC 2131 Suggested", "RFC");

    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int FIXED_TIMING_VALUE = 1;
    public static final int RFC_SUGGESTED_VALUE = 2;
    private static final RetransmissionPolicy[] VALUES_ARRAY;
    public static final List<RetransmissionPolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RetransmissionPolicy[]{FIXED_TIMING, RFC_SUGGESTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RetransmissionPolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RetransmissionPolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RetransmissionPolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RetransmissionPolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RetransmissionPolicy get(int value) {
        switch (value) {
            case 1: {
                return FIXED_TIMING;
            }
            case 2: {
                return RFC_SUGGESTED;
            }
        }
        return null;
    }

    private RetransmissionPolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

