/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ThroughputType implements Enumerator
{
    FRAME_ONLY(0, "FrameOnly", "FrameOnly"),
    FRAME_AND_FCS(1, "FrameAndFcs", "FrameAndFcs"),
    FRAME_AND_ALL_OTHER_FIELDS(2, "FrameAndAllOtherFields", "FrameAndAllOtherFields");

    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int FRAME_ONLY_VALUE = 0;
    public static final int FRAME_AND_FCS_VALUE = 1;
    public static final int FRAME_AND_ALL_OTHER_FIELDS_VALUE = 2;
    private static final ThroughputType[] VALUES_ARRAY;
    public static final List<ThroughputType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ThroughputType[]{FRAME_ONLY, FRAME_AND_FCS, FRAME_AND_ALL_OTHER_FIELDS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ThroughputType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ThroughputType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ThroughputType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ThroughputType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ThroughputType get(int value) {
        switch (value) {
            case 0: {
                return FRAME_ONLY;
            }
            case 1: {
                return FRAME_AND_FCS;
            }
            case 2: {
                return FRAME_AND_ALL_OTHER_FIELDS;
            }
        }
        return null;
    }

    private ThroughputType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

