/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.util;

import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.util.IOpenCloseListener;
import com.excentis.products.byteblower.model.util.IOpenCloseLocationListener;
import com.excentis.products.byteblower.model.util.IOpenCloseNotifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;

public class ProjectSwitchNotifier
implements IOpenCloseNotifier {
    private static ProjectSwitchNotifier instance;
    private ByteBlowerProject currentProject;
    private URI location;
    private Object listenerLock = new Object();
    private List<IOpenCloseLocationListener> openCloseListeners = new ArrayList<IOpenCloseLocationListener>();

    public static ProjectSwitchNotifier getInstance() {
        if (instance == null) {
            instance = new ProjectSwitchNotifier();
        }
        return instance;
    }

    public ByteBlowerProject getCurrentProject() {
        return this.currentProject;
    }

    public void changeProject(ByteBlowerProject newProject, URI newLocation) {
        this.currentProject = newProject;
        this.location = newLocation;
    }

    public URI getCurrentProjectLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeOpenCloseListener(IOpenCloseListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            ForwarderProxy proxy = new ForwarderProxy(listener);
            this.openCloseListeners.remove(proxy);
        }
    }

    @Override
    public final void addOpenCloseListener(IOpenCloseListener listener) {
        ForwarderProxy proxy = new ForwarderProxy(listener);
        this.addOpenCloseListener(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeOpenCloseListener(IOpenCloseLocationListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.openCloseListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addOpenCloseListener(IOpenCloseLocationListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.openCloseListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tellOpenCloseListeners() {
        Object object = this.listenerLock;
        synchronized (object) {
            for (IOpenCloseLocationListener listener : this.openCloseListeners) {
                listener.projectOpenedOrClosed(this.currentProject, this.location);
            }
        }
    }

    private static final class ForwarderProxy
    implements IOpenCloseLocationListener {
        private final IOpenCloseListener interestedBase;

        public ForwarderProxy(IOpenCloseListener interest) {
            this.interestedBase = interest;
        }

        @Override
        public void projectOpenedOrClosed(ByteBlowerProject project, URI location) {
            this.interestedBase.projectOpenedOrClosed(project);
        }

        public int hashCode() {
            return this.interestedBase.hashCode();
        }

        public boolean equals(ForwarderProxy other) {
            return other != null && (this == other || this.interestedBase.equals(other.interestedBase));
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            return this.interestedBase.equals(other) || other instanceof ForwarderProxy && this.equals((ForwarderProxy)other);
        }
    }
}

