/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.object.control;

import com.excentis.products.byteblower.object.control.ByteController;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ByteCollectionController {
    private List<Byte> byteCollection;

    public ByteCollectionController(List<Byte> myByteCollection) {
        this.byteCollection = myByteCollection;
    }

    public void copyFrom(List<Byte> fromBytes) {
        int fromSize = fromBytes.size();
        if (this.byteCollection.size() == fromSize) {
            int i = 0;
            for (Byte from : fromBytes) {
                this.byteCollection.set(i++, new Byte(from));
            }
        } else {
            this.byteCollection.clear();
            for (Byte from : fromBytes) {
                this.byteCollection.add(new Byte(from));
            }
        }
    }

    public void increment() {
        int i = this.byteCollection.size();
        while (--i >= 0) {
            byte toByte = this.byteCollection.get(i);
            toByte = (byte)(toByte + 1);
            this.byteCollection.set(i, new Byte(toByte));
            if (toByte == 0) continue;
            return;
        }
    }

    public void decrement() {
        int i = this.byteCollection.size();
        while (--i >= 0) {
            Byte toByte = this.byteCollection.get(i);
            toByte = (byte)(toByte - 1);
            this.byteCollection.set(i, new Byte(toByte));
            if (toByte == -1) continue;
            return;
        }
    }

    private static void increment(List<Byte> toBytes, List<Byte> fromBytes) {
        int i = fromBytes.size();
        while (--i >= 0) {
            byte toValue;
            byte by = toValue = fromBytes.get(i).byteValue();
            toValue = (byte)(by + 1);
            toBytes.set(i, new Byte(by));
            if (toValue != 0) {
                return;
            }
            --i;
        }
    }

    private static void decrement(List<Byte> toBytes, List<Byte> fromBytes) {
        int i = fromBytes.size();
        while (--i >= 0) {
            byte toValue;
            byte by = toValue = fromBytes.get(i).byteValue();
            toValue = (byte)(by - 1);
            toBytes.set(i, new Byte(by));
            if (toValue != 255) {
                return;
            }
            --i;
        }
    }

    public void increment(List<Byte> fromBytes) {
        if (this.byteCollection.size() == fromBytes.size()) {
            ByteCollectionController.increment(this.byteCollection, fromBytes);
        } else {
            this.byteCollection.clear();
            this.byteCollection.addAll(fromBytes);
            this.increment();
        }
    }

    protected void decrement(List<Byte> fromBytes) {
        if (this.byteCollection.size() == fromBytes.size()) {
            ByteCollectionController.decrement(this.byteCollection, fromBytes);
        } else {
            this.byteCollection.clear();
            this.byteCollection.addAll(fromBytes);
            this.decrement();
        }
    }

    private static final String toByteString(List<Byte> byteList, Character separator, int combineBytes, boolean decFormat) throws NumberFormatException {
        String result = "";
        if (byteList != null) {
            int byteListSize = byteList.size();
            int i = 0;
            while (i < byteListSize) {
                Byte by = byteList.get(i);
                if (separator != null && i > 0 && (i + 1) % combineBytes == 0) {
                    result = String.valueOf(result) + separator;
                }
                if (!decFormat) {
                    result = String.valueOf(result) + ByteController.toString(by);
                } else {
                    int integer = by.intValue();
                    if (integer < 0) {
                        integer += 256;
                    }
                    result = String.valueOf(result) + integer;
                }
                ++i;
            }
        }
        return result;
    }

    public final String toByteString(Character separator, int combineBytes, boolean decFormat) throws NumberFormatException {
        return ByteCollectionController.toByteString(this.byteCollection, separator, combineBytes, decFormat);
    }

    private final String toByteString(Character separator, int combineBytes) throws NumberFormatException {
        return this.toByteString(separator, combineBytes, false);
    }

    public final String toByteString(Character separator) throws NumberFormatException {
        return this.toByteString(separator, 1);
    }

    public final void fromByteString(String newByteCollectionString, char separator, boolean decFormat, int fixedByteSize) throws NumberFormatException {
        int endIndex;
        ArrayList<Byte> newByteList = new ArrayList<Byte>();
        String byteString = "";
        int beginIndex = 0;
        do {
            if (fixedByteSize > 0 && newByteList.size() > fixedByteSize) {
                throw new NumberFormatException("Byte String exceeds ByteCollection size.");
            }
            endIndex = newByteCollectionString.indexOf(separator, beginIndex);
            if (endIndex != -1) {
                byteString = newByteCollectionString.substring(beginIndex, endIndex);
                beginIndex = endIndex + 1;
            } else {
                byteString = newByteCollectionString.substring(beginIndex);
            }
            int integer = !decFormat ? Integer.parseInt(byteString, 16) : Integer.parseInt(byteString);
            if (integer > 127) {
                integer -= 256;
            }
            newByteList.add(new Byte((byte)integer));
        } while (endIndex != -1);
        if (fixedByteSize > 0 && newByteList.size() < fixedByteSize) {
            throw new NumberFormatException("Byte String does not match ByteCollection size.");
        }
        this.byteCollection.clear();
        this.byteCollection.addAll(newByteList);
    }

    private final void fromByteString(String newByteCollectionString, char separator, boolean decFormat) throws NumberFormatException {
        this.fromByteString(newByteCollectionString, separator, decFormat, this.byteCollection.size());
    }

    protected final void fromByteString(String newByteCollectionString, char separator) throws NumberFormatException {
        this.fromByteString(newByteCollectionString, separator, false);
    }

    public BigInteger toBigInteger() {
        BigInteger bigIntegerValue = BigInteger.ZERO;
        int byteListSize = this.byteCollection.size();
        for (Byte by : this.byteCollection) {
            String val = ByteController.toString(by);
            BigInteger addByte = new BigInteger(val, byteListSize);
            bigIntegerValue = bigIntegerValue.shiftLeft(8).add(addByte);
        }
        return bigIntegerValue;
    }

    public void fromBigInteger(BigInteger newValue) {
        byte[] byteArray = newValue.toByteArray();
        int byteListSize = this.byteCollection.size();
        int nofZeros = byteListSize - byteArray.length;
        int i = 0;
        while (i < byteListSize) {
            if (i < nofZeros) {
                this.byteCollection.set(i, (byte)0);
            } else {
                this.byteCollection.set(i, byteArray[i - nofZeros]);
            }
            ++i;
        }
    }
}

