/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.object.control;

public class ByteController {
    private static Byte normalByte;
    private static final String[] hexValues;

    static {
        hexValues = new String[256];
        int i = 0;
        while (i < 256) {
            String s = Integer.toHexString(i).toUpperCase();
            ByteController.hexValues[i] = s.length() < 2 ? "0" + s : s;
            ++i;
        }
    }

    private static boolean setHexByte(String string) {
        try {
            int integer = Integer.parseInt(string, 16);
            if (integer > 127) {
                integer -= 256;
            }
            normalByte = new Byte((byte)integer);
        }
        catch (NumberFormatException exception) {
            System.out.println("NumberFormatException " + exception.getMessage());
            return false;
        }
        return true;
    }

    private static boolean setByte(String string) {
        try {
            int integer = Integer.parseInt(string);
            if (integer > 127) {
                integer -= 256;
            }
            normalByte = new Byte((byte)integer);
        }
        catch (NumberFormatException exception) {
            System.out.println("NumberFormatException " + exception.getMessage());
            return false;
        }
        return true;
    }

    private static Byte getByte() {
        return normalByte;
    }

    public static Byte getHexByte(String string) {
        ByteController.setHexByte(string);
        return ByteController.getByte();
    }

    public static Byte getByte(String string) {
        ByteController.setByte(string);
        return ByteController.getByte();
    }

    public static Byte byteToByte(byte bte) {
        ByteController.setByte(Byte.toString(bte));
        return normalByte;
    }

    public static String toString(byte b) {
        return hexValues[b & 0xFF];
    }

    public static Byte toByte(String s) {
        byte b1 = Byte.parseByte("" + s.charAt(0), 16);
        byte b2 = Byte.parseByte("" + s.charAt(1), 16);
        return (byte)((b1 & 0xF) << 4 | b2);
    }
}

