/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.data.entities.core;

import com.excentis.products.byteblower.results.dataprovider.data.enums.ReportFileFormat;

public enum ReportOutputFormat {
    dynamicHtml(false, "html"),
    html(false, "html"),
    pdf(true, "pdf"),
    csv(false, "csv"),
    xls(false, "xls"),
    xlsx(false, "xlsx"),
    json(true, "json"),
    docx(true, "docx"),
    cloud(false, "html"),
    deprecatedjasperhtml(false, "html");

    private final boolean needsPages;
    private final String extension;

    private ReportOutputFormat(boolean needsPages, String extension) {
        this.needsPages = needsPages;
        this.extension = extension;
    }

    public boolean isPaginated() {
        return this.needsPages;
    }

    public String getExtension() {
        return this.extension;
    }

    public static ReportFileFormat getReportFileFormat(ReportOutputFormat format) {
        switch (format) {
            case csv: {
                return ReportFileFormat.CSV;
            }
            case docx: {
                return ReportFileFormat.DOCX;
            }
            case dynamicHtml: {
                return ReportFileFormat.HTML;
            }
            case html: {
                return ReportFileFormat.HTML;
            }
            case pdf: {
                return ReportFileFormat.PDF;
            }
            case json: {
                return ReportFileFormat.JSON;
            }
            case xls: {
                return ReportFileFormat.XLS;
            }
            case xlsx: {
                return ReportFileFormat.XLSX;
            }
            case deprecatedjasperhtml: {
                return ReportFileFormat.HTML;
            }
            case cloud: {
                return ReportFileFormat.HTML;
            }
        }
        return null;
    }
}

