/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2;

import com.excentis.products.byteblower.report.data.entities.templates.ReportTemplateEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonReportManager;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;

public class DataCreator
implements AutoCloseable {
    private final String filename;

    DataCreator(ReportGeneration reportGeneration, ReportTemplateEntity reportTemplate, ReportPreferencesInterface preferences, GenerateReportListener listener, IProgressMonitor monitor) {
        this.filename = DataCreator.createJSON(reportGeneration, reportTemplate, preferences, monitor);
    }

    static String createJSON(ReportGeneration reportGeneration, ReportTemplateEntity reportTemplate, ReportPreferencesInterface preferences, IProgressMonitor monitor) {
        JsonReportManager json = new JsonReportManager();
        json.createHiddenReport(reportGeneration, reportTemplate, preferences, monitor.slice(1));
        return json.getFilename();
    }

    String reportname() {
        return this.filename;
    }

    @Override
    public void close() throws IOException {
        if (this.filename != null) {
            Path pathToDelete = Paths.get(this.filename, new String[0]);
            try {
                Files.delete(pathToDelete);
                System.out.println("File deleted successfully");
            }
            catch (IOException e) {
                System.err.println("Failed to delete the file: " + e.getMessage());
            }
        }
    }
}

