/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2;

import com.excentis.products.byteblower.datapersistence.listeners.LatencyDistributionCollector;
import com.excentis.products.byteblower.datapersistence.util.FileBlocks;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class LatencyDistributionResults {
    private HashMap<String, FileBlocks.Reader> streams = new HashMap();
    private FileBlocks blocks;

    public LatencyDistributionResults() {
        String lastTest = LatencyDistributionCollector.lastResults;
        if (lastTest == null) {
            return;
        }
        try {
            this.blocks = new FileBlocks(lastTest, FileBlocks.MODE.READ);
            FileBlocks.Reader index = this.blocks.createReader(0L);
            while (index.hasNext()) {
                byte[] results = index.read();
                String bb = new String(results);
                String[] parted = bb.split(":!!:");
                long id = Long.valueOf(parted[0]);
                String name = parted[1];
                this.streams.put(name, this.blocks.createReader(id));
                System.out.format("got results for %s in %d %n", name, id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Collection<Collection<Map<String, Object>>> percentsOVerTime() {
        ArrayList<Collection<Map<String, Object>>> result = new ArrayList<Collection<Map<String, Object>>>();
        for (String g : this.streams.keySet()) {
            ArrayList currentSeries = new ArrayList();
            result.add(currentSeries);
            FileBlocks.Reader reading = this.streams.get(g);
            while (reading.hasNext()) {
                try {
                    HashMap<String, Object> bucket = new HashMap<String, Object>();
                    currentSeries.add(bucket);
                    byte[] sample = reading.read();
                    ByteBuffer buf = ByteBuffer.wrap(sample);
                    long timestamp = buf.getLong();
                    long min = buf.getLong();
                    long max = buf.getLong();
                    buf.getLong();
                    long step = (max - min) / 1000L;
                    long[] cfr_ignored_0 = new long[1000];
                    long totalPackets = 0L;
                    int ctr = 0;
                    while (ctr < 1000) {
                        totalPackets += buf.getLong();
                        ++ctr;
                    }
                    long average = buf.getLong();
                    long p99 = (long)((double)totalPackets * 0.99);
                    long p99_val = 0L;
                    long p50_val = 0L;
                    long p50 = (long)((double)totalPackets * 0.5);
                    totalPackets = 0L;
                    int ctr2 = 0;
                    while (ctr2 < 1000) {
                        long key = min + step * (long)ctr2;
                        if ((totalPackets += buf.getLong()) > p99) {
                            p99_val = key;
                        }
                        if (totalPackets > p50) {
                            p50_val = key;
                        }
                        ++ctr2;
                    }
                    bucket.put("A", g);
                    bucket.put("B", timestamp);
                    bucket.put("C", average);
                    bucket.put("D", p99_val);
                    bucket.put("E", p50_val);
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public Collection<Collection<Map<String, Object>>> ccdf() {
        ArrayList<Collection<Map<String, Object>>> result = new ArrayList<Collection<Map<String, Object>>>();
        for (String g : this.streams.keySet()) {
            ArrayList currentSeries = new ArrayList();
            result.add(currentSeries);
            FileBlocks.Reader reading = this.streams.get(g);
            TreeMap<Long, Long> summedValues = new TreeMap<Long, Long>();
            while (reading.hasNext()) {
                try {
                    byte[] sample = reading.read();
                    ByteBuffer buf = ByteBuffer.wrap(sample);
                    buf.getLong();
                    long min = buf.getLong();
                    long max = buf.getLong();
                    buf.getLong();
                    long step = (max - min) / 1000L;
                    int ctr = 0;
                    while (ctr < 1000) {
                        long key = min + step * (long)ctr;
                        long orig = summedValues.computeIfAbsent(key, a -> 0L);
                        summedValues.put(key, orig + buf.getLong());
                        ++ctr;
                    }
                }
                catch (Exception exception) {}
            }
            HashMap<String, Object> bucket = new HashMap<String, Object>();
            currentSeries.add(bucket);
            bucket.put("A", 0);
            bucket.put("B", 0);
            bucket.put("C", g);
            bucket.put("E", g);
            long totalPackets = 0L;
            for (Map.Entry a2 : summedValues.entrySet()) {
                HashMap<String, Object> bucket2 = new HashMap<String, Object>();
                currentSeries.add(bucket2);
                bucket2.put("A", (double)((Long)a2.getKey()).longValue() / 1000000.0);
                bucket2.put("B", a2.getValue());
                totalPackets += ((Long)a2.getValue()).longValue();
                bucket2.put("C", g);
                bucket2.put("E", g);
            }
            HashMap<String, Object> bucket3 = new HashMap<String, Object>();
            currentSeries.add(bucket3);
            bucket3.put("A", 0);
            bucket3.put("B", totalPackets);
            bucket3.put("C", g);
            bucket3.put("E", g);
            bucket3 = new HashMap();
            currentSeries.add(bucket3);
            bucket3.put("A", 0);
            bucket3.put("B", 0);
            bucket3.put("C", g);
            bucket3.put("E", g);
            bucket3 = new HashMap();
            currentSeries.add(bucket3);
            bucket3.put("A", 0);
            bucket3.put("B", totalPackets);
            bucket3.put("C", g);
            bucket3.put("E", g);
        }
        return result;
    }
}

