/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2;

import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.data.entities.templates.ReportTemplateEntity;
import com.excentis.products.byteblower.report.generator.core.AbstractReportManager;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.core.parameters.DataRateUnit;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputType;
import com.excentis.products.byteblower.report.generator.html2.DataCreator;
import com.excentis.products.byteblower.report.generator.html2.JSONLoader;
import com.excentis.products.byteblower.report.generator.html2.LatencyDistributionResults;
import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.UniqueIdFilter;
import com.excentis.products.byteblower.report.generator.html2.generator.ByteBlowerPortsSection;
import com.excentis.products.byteblower.report.generator.html2.generator.EventTable;
import com.excentis.products.byteblower.report.generator.html2.generator.FrameBlastingGraphs;
import com.excentis.products.byteblower.report.generator.html2.generator.FrameBlastingTables;
import com.excentis.products.byteblower.report.generator.html2.generator.LatencyDistributionGraphs;
import com.excentis.products.byteblower.report.generator.html2.generator.NatTable;
import com.excentis.products.byteblower.report.generator.html2.generator.Rfc2544;
import com.excentis.products.byteblower.report.generator.html2.generator.TCPAggregateGraphs;
import com.excentis.products.byteblower.report.generator.html2.generator.TCPAggregateRx;
import com.excentis.products.byteblower.report.generator.html2.generator.TCPAggregateTx;
import com.excentis.products.byteblower.report.generator.html2.generator.TCPGraphs;
import com.excentis.products.byteblower.report.generator.html2.generator.TCPTables;
import com.excentis.products.byteblower.report.generator.html2.generator.WifiGraphs;
import com.excentis.products.byteblower.report.generator.html2.templates.Loader;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;
import com.excentis.products.byteblower.utils.Utils;
import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.lib.filter.Filter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ReportManagerHtml
extends AbstractReportManager {
    TestDataReference testDataReference;
    private static final boolean minified = false;
    private static final String FRAME_AND_ALL_OTHER_FIELDS_INFO = "-Frame (as displayed in the Frame View)<br>-FCS\t(CRC Frame Checksum, 4 bytes)<br>-Preamble\t(7 bytes)<br>-SFD\t(Start Frame Delimiter, 1 byte)<br>-Pause (12 bytes)<br><br>This way, each Frame gets 24 bytes extra.";
    private static final String FRAME_AND_FCS_INFO = "-Frame (as displayed in the Frame View)<br>-FCS\t(CRC Frame Checksum, 4 bytes)<br><br>This way, each Frame gets 4 bytes extra.";
    private static final String FRAME_ONLY_INFO = "-Frame (as displayed in the Frame View)<br><br>This way, each Frame gets 0 bytes extra.";
    static final int FCS_SIZE = 4;
    static final int PREAMBLE_SIZE = 7;
    static final int SFD_SIZE = 1;
    static final int IFG_SIZE = 12;
    static final int FRAME_ONLY = 0;
    static final int FRAME_WITH_FCS = 4;
    static final int FRAME_FULL_LAYER1_EXCL_IFG = 12;
    static final int FRAME_FULL_LAYER1_INCL_IFG = 24;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$report$generator$core$parameters$ThroughputType = ReportManagerHtml.$SWITCH_TABLE$com$excentis$products$byteblower$report$generator$core$parameters$ThroughputType();
    }

    public ReportManagerHtml(TestDataReference testDataReference) {
        this.testDataReference = testDataReference;
    }

    private static String minified(String name) {
        return name;
    }

    private static String createHtml(ScenarioWithPreferences results) {
        LatencyDistributionResults distribution = new LatencyDistributionResults();
        Jinjava jinjava = new Jinjava();
        jinjava.registerFilter((Filter)new UniqueIdFilter());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("project_name", results.projectName);
        context.put("project_author", results.projectAuthor);
        context.put("scenario_name", results.scenarioName);
        context.put("run_title", results.runTitle);
        context.put("scenario_state", results.scenarioState);
        context.put("scenario_has_warnings", results.hasWarnings());
        context.put("scenario_start", results.startMoment == null ? null : ReportManagerHtml.localTime(results.startMoment));
        context.put("scenario_end", results.endMoment == null ? null : ReportManagerHtml.localTime(results.endMoment));
        context.put("gui_version", results.guiVersion);
        context.put("scenario_servers", ReportManagerHtml.generateServerInfo(results));
        context.put("initial_throughput_unit", results.initialThroughputUnit);
        context.put("initial_throughput_nof_decimals", results.initialThroughputNofDecimals);
        context.put("initial_throughput_legend", results.initialThroughputLegend);
        context.put("initial_throughput_frame_overhead", results.initialThroughputFrameOverhead);
        context.put("initial_latency_unit", results.initialLatencyUnit);
        context.put("initial_latency_nof_decimals", results.initialLatencyNofDecimals);
        context.put("ccdf_vals", distribution.ccdf());
        context.put("byteblower_ports", ByteBlowerPortsSection.generate(results));
        context.put("nat_table", NatTable.generate(results));
        context.put("frameblasting_tables", FrameBlastingTables.generate(results));
        context.put("rfc_2544", Rfc2544.generate(results));
        context.put("wifi_graphs", WifiGraphs.generate(results));
        context.put("frameblasting_graphs", FrameBlastingGraphs.generate(results));
        context.put("latency_distribution", LatencyDistributionGraphs.generate(results));
        context.put("tcp_tables", TCPTables.generate(results));
        context.put("tcp_graphs", TCPGraphs.generate(results));
        context.put("tcp_aggregate_graphs", TCPAggregateGraphs.generate(results));
        context.put("tcp_aggregate_tx", TCPAggregateTx.generate(results));
        context.put("tcp_aggregate_rx", TCPAggregateRx.generate(results));
        context.put("error_table", EventTable.generate(results, EventSeverity.TEST_ERROR, "Errors"));
        context.put("warning_table", EventTable.generate(results, EventSeverity.TEST_WARNING, "Warnings"));
        context.put("info_table", EventTable.generate(results, EventSeverity.TEST_INFO, "Info"));
        context.put("suggestion_table", EventTable.generate(results, EventSeverity.TEST_SUGGESTION, "Suggestions"));
        Loader localFile = new Loader();
        context.put("header_html", localFile.getTemplate("html_templates/header.html"));
        context.put("footer_html", localFile.getTemplate("html_templates/footer.html"));
        context.put("boot_css", localFile.getTemplate("bootstrap.min.css"));
        context.put("excentis_css", localFile.getTemplate("excentis_GUI_report.css"));
        context.put("boot_js", localFile.getTemplate("bootstrap.min.js"));
        context.put("js_jquery", localFile.getTemplate("jquery-3.2.1.slim.min.js"));
        context.put("js_require", localFile.getTemplate("require.js"));
        context.put("js_highcharts", localFile.getTemplate("highcharts.js"));
        context.put("js_highcharts_more", localFile.getTemplate("highcharts-more.js"));
        context.put("js_gurufb", localFile.getTemplate(ReportManagerHtml.minified("gurufb.js")));
        context.put("js_guru", localFile.getTemplate(ReportManagerHtml.minified("guru.js")));
        context.put("js_guruaggrxtcp", localFile.getTemplate(ReportManagerHtml.minified("guruaggrxtcp.js")));
        context.put("js_excentis_util", localFile.getTemplate(ReportManagerHtml.minified("excentis_util.js")));
        context.put("js_guruccdf", localFile.getTemplate(ReportManagerHtml.minified("guruccdf.js")));
        context.put("js_gurudist", localFile.getTemplate(ReportManagerHtml.minified("gurudist.js")));
        context.put("js_guru_rssi", localFile.getTemplate(ReportManagerHtml.minified("guruRssi.js")));
        String result = jinjava.render(localFile.getTemplate("html_templates/test.template"), context);
        return result;
    }

    public static LocalDateTime localTime(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        ZoneId currentZone = ZoneId.systemDefault();
        ZonedDateTime localTime = dateTime.withZoneSameInstant(currentZone);
        return localTime.toLocalDateTime();
    }

    private static String generateServerInfo(Scenario results) {
        StringBuilder buffer = new StringBuilder();
        String header = "";
        if (results.servers != null) {
            for (Scenario.Server server : results.servers) {
                String name = server.host;
                buffer.append(header);
                buffer.append(header);
                buffer.append(name);
                String addr = server.ipAddress;
                if (!name.equals(addr)) {
                    buffer.append(" [");
                    buffer.append(addr);
                    buffer.append("]");
                }
                buffer.append("<br>");
                buffer.append(server.type);
                buffer.append(" - ");
                buffer.append(server.version);
                header = "<br>";
            }
        }
        return buffer.toString();
    }

    public void createReport(ReportGeneration reportGeneration, ReportTemplateEntity reportTemplate, ReportPreferencesInterface pref, GenerateReportListener listener, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (DataCreator data = new DataCreator(reportGeneration, reportTemplate, pref, listener, monitor);){
                String reportFileName;
                long start = System.nanoTime();
                ScenarioWithPreferences results = JSONLoader.load(data.reportname());
                ThroughputType throughputType = (ThroughputType)pref.getThroughputType().getValue();
                results.initialThroughputUnit = (String)pref.getDataRateUnit().getValue();
                results.initialThroughputNofDecimals = pref.getThroughputPattern().getNumberOfDecimals();
                results.initialThroughputLegend = ReportManagerHtml.getThroughputLegend(pref);
                results.initialThroughputFrameOverhead = ReportManagerHtml.getFrameOverhead(throughputType);
                results.initialLatencyUnit = pref.getLatencyUnit().getRawUnit().getUnitPrefix().name();
                results.initialLatencyNofDecimals = pref.getLatencyPattern().getNumberOfDecimals();
                String contents = ReportManagerHtml.createHtml(results);
                String reportPath = this.getOutputPath(pref);
                if (reportPath != null) {
                    new File(reportPath).mkdirs();
                }
                if ((reportFileName = this.getOutputFileName(pref)) != null) {
                    File reportFile = new File(reportFileName);
                    FileOutputStream dummyContents = new FileOutputStream(reportFile);
                    dummyContents.write(contents.getBytes());
                    dummyContents.close();
                    listener.onReportExported(reportGeneration, reportFile.getAbsolutePath(), ReportOutputFormat.html);
                }
                System.out.format("Rendering took: %s %n", (double)(System.nanoTime() - start) / 1.0E9);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            System.err.println("Not able to create dummy HTML report");
        }
    }

    protected String getOutputPath(ReportPreferencesInterface pref) {
        Path path = new Path(pref.getOutputLocation());
        String runTitle = this.testDataReference.getTestRunTitle();
        if (runTitle != null && !runTitle.isEmpty()) {
            path = path.append(runTitle);
        }
        return path.toOSString();
    }

    protected String getOutputFileName(ReportPreferencesInterface pref) {
        Path path = new Path(this.getOutputPath(pref));
        String base = Utils.createReportFileNameBase((IPath)path, (String)this.testDataReference.getTestRunTitle(), (String)this.testDataReference.getTestName(), (Date)this.testDataReference.getStartTime(), (String)"R2");
        String outputFileName = Utils.createUniqueReportFilename((String)base, (String)ReportOutputFormat.html.getExtension());
        return outputFileName;
    }

    private static String getThroughputLegend(ThroughputType type) {
        String infoHtmlString = "The Frame Blasting Layer 2 Speed includes:<br><br>";
        switch (type) {
            case FRAME_AND_ALL_OTHER_FIELDS: {
                infoHtmlString = String.valueOf(infoHtmlString) + FRAME_AND_ALL_OTHER_FIELDS_INFO;
                break;
            }
            case FRAME_AND_FCS: {
                infoHtmlString = String.valueOf(infoHtmlString) + FRAME_AND_FCS_INFO;
                break;
            }
            case FRAME_ONLY: {
                infoHtmlString = String.valueOf(infoHtmlString) + FRAME_ONLY_INFO;
                break;
            }
        }
        return infoHtmlString;
    }

    protected static int getFrameOverhead(ThroughputType type) {
        switch (type) {
            case FRAME_AND_ALL_OTHER_FIELDS: {
                return 24;
            }
            case FRAME_AND_FCS: {
                return 4;
            }
        }
        return 0;
    }

    private static String getThroughputLegend(ReportPreferencesInterface pref) {
        ThroughputType type = (ThroughputType)pref.getThroughputType().getValue();
        return ReportManagerHtml.getThroughputLegend(type);
    }

    private static void createHtml(ScenarioWithPreferences results, ThroughputType type, String targetName) {
        results.initialThroughputLegend = ReportManagerHtml.getThroughputLegend(type);
        results.initialThroughputFrameOverhead = ReportManagerHtml.getFrameOverhead(type);
        String contents = ReportManagerHtml.createHtml(results);
        try {
            FileOutputStream dummyContents = new FileOutputStream(targetName);
            dummyContents.write(contents.getBytes());
            dummyContents.close();
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "Not able to save generated HTML report", e);
        }
    }

    public static void createReportFromJson(String jsonFile, String targetName) {
        ScenarioWithPreferences results;
        Logger logger = Logger.getGlobal();
        try {
            results = JSONLoader.load(jsonFile);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Not able to open source JSON file", e);
            return;
        }
        results.initialThroughputUnit = DataRateUnit.MBPS.getName();
        results.initialThroughputNofDecimals = 3;
        results.initialLatencyUnit = UnitReader.UnitPrefix.MICRO.name();
        results.initialLatencyNofDecimals = 3;
        ReportManagerHtml.createHtml(results, ThroughputType.FRAME_AND_ALL_OTHER_FIELDS, targetName);
        if (targetName.contains("basic - ")) {
            targetName = String.valueOf(targetName) + "xtra";
            ReportManagerHtml.createHtml(results, ThroughputType.FRAME_ONLY, targetName.replace(".htmlxtra", "_FRAME_ONLY.html"));
            ReportManagerHtml.createHtml(results, ThroughputType.FRAME_AND_FCS, targetName.replace(".htmlxtra", "_FRAME_AND_FCS.html"));
            ReportManagerHtml.createHtml(results, ThroughputType.FRAME_AND_ALL_OTHER_FIELDS, targetName.replace(".htmlxtra", "_FRAME_AND_ALL_OTHER_FIELDS.html"));
        } else {
            ReportManagerHtml.createHtml(results, ThroughputType.FRAME_AND_ALL_OTHER_FIELDS, targetName);
        }
    }
}

