/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2;

import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.data.entities.templates.ReportTemplateEntity;
import com.excentis.products.byteblower.report.generator.core.AbstractReportManager;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.core.parameters.DataRateUnit;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputType;
import com.excentis.products.byteblower.report.generator.html2.DataCreator;
import com.excentis.products.byteblower.report.generator.html2.JSONLoader;
import com.excentis.products.byteblower.report.generator.html2.ReportManagerHtml;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.UniqueIdFilter;
import com.excentis.products.byteblower.report.generator.html2.generator.FrameBlastingTables;
import com.excentis.products.byteblower.report.generator.html2.generator.NatTable;
import com.excentis.products.byteblower.report.generator.html2.generator.TCPTables;
import com.excentis.products.byteblower.report.generator.html2.generator2.ByteBlowerPorts;
import com.excentis.products.byteblower.report.generator.html2.generator2.Events;
import com.excentis.products.byteblower.report.generator.html2.generator2.FrameBlastingCollapsableTables;
import com.excentis.products.byteblower.report.generator.html2.generator2.GeneralScenarioConfig;
import com.excentis.products.byteblower.report.generator.html2.generator2.ScenarioInfo;
import com.excentis.products.byteblower.report.generator.html2.generator2.ServerInfo;
import com.excentis.products.byteblower.report.generator.html2.generator2.TcpCollapsableTables;
import com.excentis.products.byteblower.report.generator.html2.generator2.WifiCollapsableTables;
import com.excentis.products.byteblower.report.generator.html2.templates.Loader;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;
import com.excentis.products.byteblower.utils.Utils;
import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.lib.filter.Filter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ReportManagerHtmlV2
extends AbstractReportManager {
    private static final String BASE_PATH = "design_nov_2023/";
    private final TestDataReference testDataReference;

    public ReportManagerHtmlV2(TestDataReference testDataReference) {
        this.testDataReference = testDataReference;
    }

    protected static String createHtml(ScenarioWithPreferences results) {
        Jinjava jinjava = new Jinjava();
        jinjava.registerFilter((Filter)new UniqueIdFilter());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("report_title", ReportManagerHtmlV2.buildReportTitle(results));
        context.put("max_time", results.getMaxTime());
        context.put("initial_throughput_unit", results.initialThroughputUnit);
        context.put("initial_latency_unit", results.initialLatencyUnit);
        context.put("throughput_decimals", results.initialThroughputNofDecimals);
        context.put("latency_decimals", results.initialLatencyNofDecimals);
        context.put("error_loss_pct", 100.0 * results.getErrorLossLevel());
        context.put("warning_loss_pct", 100.0 * results.getWarningLossLevel());
        context.put("byteblower_ports", ByteBlowerPorts.generate(results));
        context.put("nat_table", NatTable.generateV2(results));
        context.put("frame_blasting_config_tables", FrameBlastingTables.generateConfigsV2(results));
        context.put("tcp_config_tables", TCPTables.generateConfigsV2(results));
        context.put("scenario_info", ScenarioInfo.generate(results));
        context.put("server_info", ServerInfo.generate(results));
        context.put("general_scenario_config", GeneralScenarioConfig.generate(results, results.initialThroughputType));
        context.put("fb_tables", FrameBlastingCollapsableTables.generate(results));
        context.put("tcp_tables", TcpCollapsableTables.generate(results));
        context.put("wifi_tables", WifiCollapsableTables.generate(results));
        context.put("info_table", Events.generate(results));
        Loader localFile = new Loader();
        context.put("main_css", localFile.getTemplate("design_nov_2023/style/main.css"));
        context.put("table_css", localFile.getTemplate("design_nov_2023/style/table.css"));
        context.put("highcharts_css", localFile.getTemplate("design_nov_2023/style/highcharts.css"));
        context.put("print_css", localFile.getTemplate("design_nov_2023/style/print.css"));
        context.put("addLogo_js", localFile.getTemplate("design_nov_2023/script/addLogo.js"));
        context.put("dynamicTables_js", localFile.getTemplate("design_nov_2023/script/dynamicTables.js"));
        context.put("iconFactory_js", localFile.getTemplate("design_nov_2023/script/iconFactory.js"));
        context.put("loadPage_js", localFile.getTemplate("design_nov_2023/script/loadPage.js"));
        context.put("unitSelection_js", localFile.getTemplate("design_nov_2023/script/unitSelection.js"));
        context.put("lossData_js", localFile.getTemplate("design_nov_2023/script/lossData.js"));
        context.put("prettyDuration_js", localFile.getTemplate("design_nov_2023/script/prettyDuration.js"));
        context.put("renderWarningIcons_js", localFile.getTemplate("design_nov_2023/script/renderWarningIcons.js"));
        context.put("guruaggrxtcp_js", localFile.getTemplate("design_nov_2023/script/guru/guruaggrxtcp.js"));
        context.put("excentis_util_js", localFile.getTemplate("design_nov_2023/script/excentis_util.js"));
        context.put("guru_rssi_js", localFile.getTemplate("design_nov_2023/script/guru/guruRssi.js"));
        context.put("gurufb_js", localFile.getTemplate("design_nov_2023/script/guru/gurufb.js"));
        context.put("guru_js", localFile.getTemplate("design_nov_2023/script/guru/guru.js"));
        context.put("gurudist_js", localFile.getTemplate("design_nov_2023/script/guru/gurudist.js"));
        context.put("guruccdf_js", localFile.getTemplate("design_nov_2023/script/guru/guruccdf.js"));
        context.put("graphs_js", localFile.getTemplate("design_nov_2023/script/graphs.js"));
        String result = jinjava.render(localFile.getTemplate("design_nov_2023/report.html"), context);
        return result;
    }

    private static String buildReportTitle(ScenarioWithPreferences results) {
        StringBuilder title = new StringBuilder();
        title.append(results.projectName);
        if (results.runTitle != null && !results.runTitle.isEmpty()) {
            title.append(" / ");
            title.append(results.runTitle);
        }
        return title.toString();
    }

    public static void createReportFromJson(String jsonFile, String targetName) {
        ScenarioWithPreferences results;
        Logger logger = Logger.getGlobal();
        try {
            results = JSONLoader.load(jsonFile);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Not able to open source JSON file", e);
            return;
        }
        results.initialThroughputUnit = DataRateUnit.MBPS.getName();
        results.initialThroughputType = ThroughputType.FRAME_AND_ALL_OTHER_FIELDS;
        results.initialThroughputNofDecimals = 2;
        results.initialLatencyUnit = UnitReader.UnitPrefix.MICRO.name();
        results.initialLatencyNofDecimals = 3;
        String contents = ReportManagerHtmlV2.createHtml(results);
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (FileOutputStream dummyContents = new FileOutputStream(targetName);){
                dummyContents.write(contents.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Not able to save generated HTML report", e);
        }
    }

    protected String getOutputPath(ReportPreferencesInterface pref) {
        Path path = new Path(pref.getOutputLocation());
        String runTitle = this.testDataReference.getTestRunTitle();
        if (runTitle != null && !runTitle.isEmpty()) {
            path = path.append(runTitle);
        }
        return path.toOSString();
    }

    protected String getOutputFileName(ReportPreferencesInterface pref) {
        Path path = new Path(this.getOutputPath(pref));
        String base = Utils.createReportFileNameBase((IPath)path, (String)this.testDataReference.getTestRunTitle(), (String)this.testDataReference.getTestName(), (Date)this.testDataReference.getStartTime(), (String)"R3");
        String outputFileName = Utils.createUniqueReportFilename((String)base, (String)ReportOutputFormat.html.getExtension());
        return outputFileName;
    }

    public void createReport(ReportGeneration reportGeneration, ReportTemplateEntity reportTemplate, ReportPreferencesInterface pref, GenerateReportListener listener, IProgressMonitor monitor) {
        Logger logger = Logger.getGlobal();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (DataCreator data = new DataCreator(reportGeneration, reportTemplate, pref, listener, monitor);){
                String reportFileName;
                ScenarioWithPreferences results = JSONLoader.load(data.reportname());
                ThroughputType throughputType = (ThroughputType)pref.getThroughputType().getValue();
                results.initialThroughputUnit = (String)pref.getDataRateUnit().getValue();
                results.initialThroughputNofDecimals = pref.getThroughputPattern().getNumberOfDecimals();
                results.initialThroughputLegend = "";
                results.initialThroughputType = throughputType;
                results.initialThroughputFrameOverhead = ReportManagerHtml.getFrameOverhead(throughputType);
                results.initialLatencyUnit = pref.getLatencyUnit().getRawUnit().getUnitPrefix().name();
                results.initialLatencyNofDecimals = pref.getLatencyPattern().getNumberOfDecimals();
                String contents = ReportManagerHtmlV2.createHtml(results);
                String reportPath = this.getOutputPath(pref);
                if (reportPath != null) {
                    new File(reportPath).mkdirs();
                }
                if ((reportFileName = this.getOutputFileName(pref)) != null) {
                    File reportFile = new File(reportFileName);
                    ReportManagerHtmlV2.saveToFile(contents, reportFile);
                    listener.onReportExported(reportGeneration, reportFile.getAbsolutePath(), ReportOutputFormat.html);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Not able to create the HTML report", e);
        }
    }

    private static void saveToFile(String contents, File reportFile) throws IOException, FileNotFoundException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream reportContents = new FileOutputStream(reportFile);){
            reportContents.write(contents.getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

