/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;

public class Scenario {
    String runTitle;
    public ZonedDateTime startMoment;
    public ZonedDateTime endMoment;
    public String projectName;
    public String projectAuthor;
    public String scenarioName;
    public String scenarioState;
    String guiVersion;
    public Ipv4Port[] ipv4Ports;
    public Ipv6Port[] ipv6Ports;
    public PortGroup[] portGroups;
    public Nat[] nat;
    public FrameBlastingFlow[] frameBlastingFlows;
    public HttpFlow[] httpFlows;
    public List<Event> events;
    public List<Server> servers;
    public WifiStatistic[] wifiStatistics;
    public Rfc2544Flow[] rfc2544Flows;
    public Map<String, Double> lossConfiguration;

    public ZonedDateTime firstMoment() {
        int n;
        int n2;
        Object[] objectArray;
        ZonedDateTime initial = null;
        if (this.httpFlows != null) {
            objectArray = this.httpFlows;
            n2 = this.httpFlows.length;
            n = 0;
            while (n < n2) {
                HttpSnapshot snap;
                HttpSnapshot[] httpSnapshotArray;
                Object http = objectArray[n];
                if (((HttpFlow)http).httpClient != null && ((HttpFlow)http).httpClient.overTimeResults != null) {
                    httpSnapshotArray = ((HttpFlow)http).httpClient.overTimeResults;
                    if (((HttpFlow)http).httpClient.overTimeResults.length != 0) {
                        snap = httpSnapshotArray[0];
                        if (initial == null || initial.isAfter(snap.timestamp)) {
                            initial = snap.timestamp;
                        }
                    }
                }
                if (((HttpFlow)http).httpServer != null) {
                    httpSnapshotArray = ((HttpFlow)http).httpServer.overTimeResults;
                    if (((HttpFlow)http).httpServer.overTimeResults.length != 0) {
                        snap = httpSnapshotArray[0];
                        if (initial == null || initial.isAfter(snap.timestamp)) {
                            initial = snap.timestamp;
                        }
                    }
                }
                ++n;
            }
        }
        if (this.frameBlastingFlows != null) {
            objectArray = this.frameBlastingFlows;
            n2 = this.frameBlastingFlows.length;
            n = 0;
            while (n < n2) {
                Object fb = objectArray[n];
                FrameBlastingSource source = ((FrameBlastingFlow)fb).source;
                if (source.sent != null) {
                    FBTrafficSnapshot[] fBTrafficSnapshotArray = source.sent.overTimeResults;
                    if (source.sent.overTimeResults.length != 0) {
                        FBTrafficSnapshot snap = fBTrafficSnapshotArray[0];
                        if (initial == null || initial.isAfter(snap.timestamp)) {
                            initial = snap.timestamp;
                        }
                    }
                }
                FrameBlastingDestination[] frameBlastingDestinationArray = ((FrameBlastingFlow)fb).destinations;
                int n3 = ((FrameBlastingFlow)fb).destinations.length;
                int n4 = 0;
                while (n4 < n3) {
                    FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                    if (dest.received != null) {
                        FBTrafficSnapshot[] fBTrafficSnapshotArray = dest.received.overTimeResults;
                        if (dest.received.overTimeResults.length != 0) {
                            FBTrafficSnapshot snap = fBTrafficSnapshotArray[0];
                            if (initial == null || initial.isAfter(snap.timestamp)) {
                                initial = snap.timestamp;
                            }
                        }
                    }
                    ++n4;
                }
                ++n;
            }
        }
        return initial;
    }

    public ZonedDateTime lastMoment() {
        ZonedDateTime lastMoment = null;
        Object[] objectArray = this.httpFlows;
        int n = this.httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            HttpSnapshot last;
            HttpFlow http = objectArray[n2];
            if (http.httpClient != null && http.httpClient.overTimeResults != null && http.httpClient.overTimeResults.length > 0) {
                last = http.httpClient.overTimeResults[http.httpClient.overTimeResults.length - 1];
                if (lastMoment == null || lastMoment.isBefore(last.timestamp)) {
                    lastMoment = last.timestamp;
                }
            }
            if (http.httpServer != null && http.httpServer.overTimeResults.length > 0) {
                last = http.httpServer.overTimeResults[http.httpServer.overTimeResults.length - 1];
                if (lastMoment == null || lastMoment.isBefore(last.timestamp)) {
                    lastMoment = last.timestamp;
                }
            }
            ++n2;
        }
        objectArray = this.frameBlastingFlows;
        n = this.frameBlastingFlows.length;
        n2 = 0;
        while (n2 < n) {
            Object fb = objectArray[n2];
            FrameBlastingSource source = ((FrameBlastingFlow)fb).source;
            if (source.sent != null && source.sent.overTimeResults.length > 0) {
                FBTrafficSnapshot last = source.sent.overTimeResults[source.sent.overTimeResults.length - 1];
                if (lastMoment == null || lastMoment.isBefore(last.timestamp)) {
                    lastMoment = last.timestamp;
                }
            }
            FrameBlastingDestination[] frameBlastingDestinationArray = ((FrameBlastingFlow)fb).destinations;
            int n3 = ((FrameBlastingFlow)fb).destinations.length;
            int n4 = 0;
            while (n4 < n3) {
                FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                if (dest.received != null && dest.received.overTimeResults.length > 0) {
                    FBTrafficSnapshot last = dest.received.overTimeResults[dest.received.overTimeResults.length - 1];
                    if (lastMoment == null || lastMoment.isBefore(last.timestamp)) {
                        lastMoment = last.timestamp;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return lastMoment;
    }

    public long getMaxTime() {
        ZonedDateTime first = this.firstMoment();
        ZonedDateTime last = this.lastMoment();
        if (first != null && last != null) {
            return ChronoUnit.MILLIS.between(first, last);
        }
        return 0L;
    }

    public class DistributionSnapshot {
        public long start;
        public long end;
        public long packets;
    }

    public class Event {
        public String name;
        public ZonedDateTime time;
        public String severity;
        public String description;
        public String knowledgeBaseLink;
        public String suggestion;
    }

    public class FBLatencySnapshot {
        public ZonedDateTime timestamp;
        public long duration;
        public long jitter;
        public long packetsValid;
        public long average;
        public long minimum;
        public long maximum;
    }

    public class FBTrafficSnapshot {
        public ZonedDateTime timestamp;
        public long duration;
        public long bytes;
        public long packets;
    }

    public class FrameBlastingConfig {
        public String name;
        public String flowTemplate;
        public long startDelay;
        public long duration;
        public long packetInterval;
        public long packets;
        public int[] packetSizes;
        public String packetSizesInfo;
        public Double intendedLoad;
        public String tos;
    }

    public class FrameBlastingDestination {
        public String name;
        public FrameblastingTrafficResult received;
        public FrameblastingLatencyResult latency;
        public FrameblastingOosResult outOfSequence;
    }

    public class FrameBlastingFlow {
        public FrameBlastingConfig config;
        public FrameBlastingSource source;
        public FrameBlastingDestination[] destinations;
    }

    public class FrameBlastingSource {
        public String name;
        public FrameblastingTrafficResult sent;
    }

    public class FrameblastingLatencyResult {
        public long jitter;
        public long packetsValid;
        public long average;
        public long minimum;
        public long maximum;
        public FBLatencySnapshot[] overTimeResults;
        public DistributionSnapshot[] distribution;
        public long packetsBelowRange;
        public long packetsAboveRange;
    }

    public class FrameblastingOosResult {
        public long packetsValid;
        public long packetsInvalid;
        public long packetsOutOfSequence;
        public FrameblastingOosSnapshot[] overTimeResults;
    }

    public class FrameblastingOosSnapshot {
        public ZonedDateTime timestamp;
        public long duration;
        public long packetsValid;
        public long packetsOutOfSequence;
    }

    public class FrameblastingTrafficResult {
        public long bytes;
        public long packets;
        public ZonedDateTime firstPacketTime;
        public ZonedDateTime lastPacketTime;
        public FBTrafficSnapshot[] overTimeResults;
    }

    public class HttpEndpoint {
        public String portName;
        public long rxBytes;
        public long txBytes;
        public ZonedDateTime rxFirst;
        public ZonedDateTime rxLast;
        public ZonedDateTime txFirst;
        public ZonedDateTime txLast;
        public HttpSnapshot[] overTimeResults;
    }

    public class HttpFlow {
        public String name;
        public String flowTemplate;
        public long startDelay;
        public long duration;
        public long size;
        public String method;
        public long ratelimit;
        public String state;
        public int configuredTos;
        public HttpEndpoint httpClient;
        public HttpEndpoint httpServer;
        public TcpEndpoint tcpClient;
        public TcpEndpoint tcpServer;
        public Long timeToFirstByte;
        public boolean l4sEnabled;

        public boolean clientIsMobile() {
            if (this.tcpClient == null) {
                return true;
            }
            return this.tcpClient.caa.equals("Unknown");
        }
    }

    public class HttpSnapshot {
        public ZonedDateTime timestamp;
        public long duration;
        public long rxBytes;
        public long txBytes;
    }

    public class Ipv4Port {
        public String ipAddress;
        public String gateway;
        public String netmask;
        public String name;
        public String server;
        public String serverVersion;
        public String physicalInterface;
        public String macAddress;
        public String nat;
        public int[] vlans;
        public String vlan_info;
        public int mtu;
        public Nat[] natDiscoveries;
    }

    public class Ipv6Port {
        public String[] ipAddresses;
        public int[] prefixLengths;
        public String[] routers;
        public String name;
        public String server;
        public String serverVersion;
        public String physicalInterface;
        public String macAddress;
        public String nat;
        public int[] vlans;
        public int mtu;
    }

    public class Nat {
        public String privateByteBlowerPort;
        public String publicByteBlowerPort;
        public String privateIpAddress;
        public String publicIpAddress;
        public String protocol;
        public int privateL4Port;
        public int publicL4Port;
        public String ipDiscoveryMethod;
        public String portDiscoveryMethod;
    }

    public class PortGroup {
        public String name;
        public String[] members;
    }

    public class Rfc2544Flow {
        public String source;
        public String destination;
        public String flow;
        public Long iterationDuration;
        public Long packetSize;
        public Double receivedByteRate;
        public Double receivedFrameRate;
        public Double acceptableLoss;
        public Double actualLoss;
    }

    public class Server {
        public String host;
        public String ipAddress;
        public String type;
        public String version;
    }

    public class TcpEndpoint {
        public String portName;
        public String caa;
        public long congestionWindowMaximum;
        public long congestionWindowMinimum;
        public long rttMaximum;
        public long rttAverage;
        public long rttMinimum;
        public long initialReceiveWindow;
        public Integer configuredWindowScale;
        public TcpSnapshot[] overTimeResults;
    }

    public class TcpSnapshot {
        public ZonedDateTime timestamp;
        public long duration;
        public long rttCurrent;
        public long rttMinimum;
        public long rttMaximum;
        public long congestionWindowCurrent;
        public long receiverWindowCurrent;
        public long slowRetransmissions;
        public long fastRetransmissions;
        public long rxTotal;
        public long txTotal;
        public long txSegments;
        public long rxSegments;
        public long localECNMarkings;
        public long remoteECNMarkings;
    }

    public class WifiSample {
        public ZonedDateTime timestamp;
        public String bssid;
        public String ssid;
        public long rssi;
    }

    public class WifiStatistic {
        public String networkInterface;
        public String wirelessEndpoint;
        public WifiSample[] overTimeResults;
    }
}

