/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputType;
import com.excentis.products.byteblower.report.generator.html2.Scenario;
import java.util.logging.Logger;

public class ScenarioWithPreferences
extends Scenario {
    private static final Logger LOGGER = Logger.getGlobal();
    public String initialThroughputUnit;
    public int initialThroughputNofDecimals;
    public String initialThroughputLegend;
    public int initialThroughputFrameOverhead;
    public String initialLatencyUnit;
    public int initialLatencyNofDecimals;
    public ThroughputType initialThroughputType;

    public boolean hasWarnings() {
        if (this.events != null) {
            for (Scenario.Event event : this.events) {
                if (!event.severity.equals("TEST_WARNING")) continue;
                return true;
            }
        }
        return false;
    }

    public double getWarningLossLevel() {
        double defaultValue;
        try {
            defaultValue = Double.parseDouble(ByteBlowerPreferences.getWarningLossLevel());
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.severe("The configured Warning Loss level is not a double");
            defaultValue = 0.01;
        }
        if (this.lossConfiguration != null) {
            return this.lossConfiguration.getOrDefault("warningLevel", defaultValue);
        }
        return defaultValue;
    }

    public double getErrorLossLevel() {
        double defaultValue;
        try {
            defaultValue = Double.parseDouble(ByteBlowerPreferences.getErrorLossLevel());
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.severe("The configured Error loss level is not a double");
            defaultValue = 0.02;
        }
        if (this.lossConfiguration != null) {
            return this.lossConfiguration.getOrDefault("errorLevel", defaultValue);
        }
        return defaultValue;
    }
}

