/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.ReflectiveExpander;
import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.util.Collection;
import java.util.HashMap;

public class ByteBlowerPortsSection {
    public static String generateV2(Scenario data) {
        Collection<HashMap<String, Object>> ports;
        HashMap<String, Collection<HashMap<String, Object>>> context = new HashMap<String, Collection<HashMap<String, Object>>>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates_nov_2023/byteblower_ports.html");
        ReflectiveExpander expander = new ReflectiveExpander();
        if (data.ipv4Ports != null) {
            ports = expander.reflectiveFill(data.ipv4Ports);
            ByteBlowerPortsSection.formatVlans(ports);
            context.put("ipv4_ports", ports);
        }
        if (data.ipv6Ports != null) {
            ports = expander.reflectiveFill(data.ipv6Ports);
            ByteBlowerPortsSection.formatVlans(ports);
            ByteBlowerPortsSection.formatIPv6Addresses(ports);
            context.put("ipv6_ports", ports);
        }
        return render.render(template, context);
    }

    public static String generate(Scenario data) {
        Collection<HashMap<String, Object>> ports;
        HashMap<String, Collection<HashMap<String, Object>>> context = new HashMap<String, Collection<HashMap<String, Object>>>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates/byteblower_ports.html");
        ReflectiveExpander expander = new ReflectiveExpander();
        if (data.ipv4Ports != null) {
            ports = expander.reflectiveFill(data.ipv4Ports);
            ByteBlowerPortsSection.formatVlans(ports);
            context.put("ipv4_ports", ports);
        }
        if (data.ipv6Ports != null) {
            ports = expander.reflectiveFill(data.ipv6Ports);
            ByteBlowerPortsSection.formatVlans(ports);
            ByteBlowerPortsSection.formatIPv6Addresses(ports);
            context.put("ipv6_ports", ports);
        }
        return render.render(template, context);
    }

    private static void formatVlans(Collection<HashMap<String, Object>> ports) {
        for (HashMap<String, Object> port : ports) {
            Object value = port.get("vlans");
            int[] vlans = (int[])value;
            String description = "";
            int vlanCounter = 0;
            int vlanSize = vlans.length;
            if (vlanSize == 0) {
                description = "No";
            } else {
                int[] nArray = vlans;
                int n = vlans.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    description = vlanCounter == 0 ? String.valueOf(description) + id : (1 == vlanCounter ? String.valueOf(description) + " (outer), " + id : (vlanSize == vlanCounter + 1 ? String.valueOf(description) + ", " + id + " (inner)" : String.valueOf(description) + ", " + id));
                    ++vlanCounter;
                    ++n2;
                }
            }
            port.put("vlans", description);
        }
    }

    private static void formatIPv6Addresses(Collection<HashMap<String, Object>> ports) {
        for (HashMap<String, Object> port : ports) {
            int[] ints;
            String[] values;
            Object value = port.get("ipAddresses");
            if (value != null && (values = (String[])value).length > 0) {
                port.put("ipAddress", values[0]);
            }
            if ((value = port.get("routers")) != null && (values = (String[])value).length > 0) {
                port.put("router", values[0]);
            }
            if ((value = port.get("prefixLengths")) == null || (ints = (int[])value).length <= 0) continue;
            port.put("prefix", ints[0]);
        }
    }
}

