/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.ReportManagerHtml;
import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.hubspot.jinjava.Jinjava;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EventTable {
    public static String generate(Scenario data, EventSeverity severity, String title) {
        if (data.events == null) {
            return "";
        }
        List<Scenario.Event> events = data.events.stream().filter(e -> e.severity.equals(severity.name())).collect(Collectors.toList());
        if (!EventTable.shouldRender(events)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates/event_table.html");
        context.put("event_table_title", title);
        context.put("event_table_content", EventTable.rows(events));
        return render.render(template, context);
    }

    private static boolean shouldRender(List<Scenario.Event> infos) {
        return !infos.isEmpty();
    }

    public static Collection<Map<String, Object>> rows(List<Scenario.Event> events) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Scenario.Event event : events) {
            HashMap<String, Object> intermediate = new HashMap<String, Object>();
            result.add(intermediate);
            intermediate.put("name", event.name);
            intermediate.put("time", ReportManagerHtml.localTime(event.time));
            intermediate.put("description", event.description);
            intermediate.put("knowledgeBaseLink", event.knowledgeBaseLink);
        }
        return result;
    }
}

