/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FrameBlastingGraphs {
    public static String generate(ScenarioWithPreferences results) {
        if (!FrameBlastingGraphs.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates/frameblasting_graphs.html");
        context.put("fb_interval_results", FrameBlastingGraphs.fbOvertimeThroughput(results));
        context.put("initial_throughput_unit", results.initialThroughputUnit);
        context.put("initial_latency_unit", results.initialLatencyUnit);
        context.put("max_time", results.getMaxTime());
        return render.render(template, context);
    }

    static boolean shouldRender(Scenario data) {
        return data.frameBlastingFlows != null && data.frameBlastingFlows.length > 0 && data.firstMoment() != null && data.lastMoment() != null;
    }

    static Collection<Collection<Map<String, Object>>> fbOvertimeThroughput(ScenarioWithPreferences data) {
        ZonedDateTime startMoment = data.firstMoment();
        ArrayList<Collection<Map<String, Object>>> result = new ArrayList<Collection<Map<String, Object>>>();
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            Scenario.FrameBlastingSource source = fb.source;
            Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = fb.destinations;
            int n3 = fb.destinations.length;
            int n4 = 0;
            while (n4 < n3) {
                Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                ArrayList intermediate = new ArrayList();
                String chartFmt = "%s: %s -> %s";
                String chartname = String.format(chartFmt, fb.config.name, source.name, dest.name);
                Scenario.FrameblastingTrafficResult received = dest.received;
                if (received != null) {
                    Scenario.FBTrafficSnapshot[] fBTrafficSnapshotArray = received.overTimeResults;
                    int n5 = received.overTimeResults.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Scenario.FBTrafficSnapshot snap = fBTrafficSnapshotArray[n6];
                        HashMap<String, Object> htmlSnap = new HashMap<String, Object>();
                        intermediate.add(htmlSnap);
                        htmlSnap.put("A", fb.config.name);
                        long millis = ChronoUnit.MILLIS.between(startMoment, snap.timestamp);
                        htmlSnap.put("B", millis);
                        htmlSnap.put("H", chartname);
                        htmlSnap.put("M", (double)(8L * (snap.bytes + (long)data.initialThroughputFrameOverhead * snap.packets)) * 1.0E9 / (double)snap.duration);
                        ++n6;
                    }
                }
                if (dest.latency != null) {
                    Scenario.FBLatencySnapshot[] latOverTime = dest.latency.overTimeResults;
                    int latLength = latOverTime.length;
                    int sampleLength = intermediate.size();
                    int ctr = 0;
                    while (ctr < Math.min(latLength, sampleLength)) {
                        Map sample = (Map)intermediate.get(ctr);
                        boolean showLatency = false;
                        Object rx = sample.get("M");
                        if (rx instanceof Double) {
                            Double rxBytes = (Double)rx;
                            showLatency = rxBytes > 0.0;
                        }
                        Scenario.FBLatencySnapshot lat = latOverTime[ctr];
                        sample.put("C", showLatency ? Long.valueOf(lat.average) : null);
                        sample.put("D", showLatency ? Long.valueOf(lat.minimum) : null);
                        sample.put("E", showLatency ? Long.valueOf(lat.maximum) : null);
                        sample.put("F", showLatency ? Long.valueOf(lat.average + lat.jitter) : null);
                        sample.put("G", showLatency ? Long.valueOf(lat.average - lat.jitter) : null);
                        ++ctr;
                    }
                }
                if (dest.outOfSequence != null) {
                    Scenario.FrameblastingOosSnapshot[] oosOverTime = dest.outOfSequence.overTimeResults;
                    int ctr = 0;
                    while (ctr < Math.min(oosOverTime.length, intermediate.size())) {
                        Map sample = (Map)intermediate.get(ctr);
                        Scenario.FrameblastingOosSnapshot oos = oosOverTime[ctr];
                        sample.put("N", oos.packetsOutOfSequence);
                        ++ctr;
                    }
                }
                if (!intermediate.isEmpty()) {
                    result.add(intermediate);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }
}

