/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.ReflectiveExpander;
import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FrameBlastingTables {
    public static String generateConfigsV2(ScenarioWithPreferences data) {
        if (!FrameBlastingTables.shouldRender(data)) {
            return "";
        }
        HashMap<String, Collection<HashMap<String, Object>>> context = new HashMap<String, Collection<HashMap<String, Object>>>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates_nov_2023/frameblasting_config_table.html");
        ReflectiveExpander expander = new ReflectiveExpander();
        context.put("fb_configs", expander.reflectiveFill(FrameBlastingTables.fbConfigs(data)));
        return render.render(template, context);
    }

    public static String generate(ScenarioWithPreferences data) {
        if (!FrameBlastingTables.shouldRender(data)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates/frameblasting_tables.html");
        ReflectiveExpander expander = new ReflectiveExpander();
        context.put("fb_configs", expander.reflectiveFill(FrameBlastingTables.fbConfigs(data)));
        context.put("fb_total_results", FrameBlastingTables.fbTotalThroughput(data));
        context.put("fb_enable_rx_vlan_header", FrameBlastingTables.hasRxVlans(data));
        context.put("fb_enable_tx_vlan_header", FrameBlastingTables.hasTxVlans(data));
        context.put("fb_overall_latency", FrameBlastingTables.fbOverallLatency(data));
        context.put("fb_overall_oos", FrameBlastingTables.fbOverallOos(data));
        return render.render(template, context);
    }

    private static boolean hasRxVlans(Scenario data) {
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = fb.destinations;
            int n3 = fb.destinations.length;
            int n4 = 0;
            while (n4 < n3) {
                Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                long rx_vlans = FrameBlastingTables.getNofVlans(data, dest.name);
                if (rx_vlans > 0L) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasTxVlans(Scenario data) {
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            Scenario.FrameBlastingSource source = fb.source;
            long tx_vlans = FrameBlastingTables.getNofVlans(data, source.name);
            if (tx_vlans > 0L) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static boolean shouldRender(Scenario data) {
        return data.frameBlastingFlows != null && data.frameBlastingFlows.length > 0;
    }

    public static Collection<Scenario.FrameBlastingConfig> fbConfigs(Scenario data) {
        ArrayList<Scenario.FrameBlastingConfig> result = new ArrayList<Scenario.FrameBlastingConfig>();
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            result.add(fb.config);
            ++n2;
        }
        return result;
    }

    public static Collection<Map<String, Object>> fbTotalThroughput(ScenarioWithPreferences data) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            Scenario.FrameBlastingSource source = fb.source;
            Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = fb.destinations;
            int n3 = fb.destinations.length;
            int n4 = 0;
            while (n4 < n3) {
                Object throughput;
                double duration;
                boolean nothingReceived;
                Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                HashMap<String, Object> intermediate = new HashMap<String, Object>();
                intermediate.put("name", fb.config.name);
                intermediate.put("source", source.name);
                intermediate.put("destination", dest.name);
                long rx_bytes = dest.received == null ? 0L : dest.received.bytes + dest.received.packets * (long)data.initialThroughputFrameOverhead;
                intermediate.put("rx_bytes", rx_bytes);
                long rx_vlans = FrameBlastingTables.getNofVlans(data, dest.name);
                intermediate.put("rx_vlans", rx_vlans);
                long rx_packets = dest.received == null ? 0L : dest.received.packets;
                intermediate.put("rx_packets", rx_packets);
                long tx_bytes = source.sent == null ? 0L : source.sent.bytes + source.sent.packets * (long)data.initialThroughputFrameOverhead;
                intermediate.put("tx_bytes", tx_bytes);
                long tx_vlans = FrameBlastingTables.getNofVlans(data, source.name);
                intermediate.put("tx_vlans", tx_vlans);
                long tx_packets = source.sent == null ? 0L : source.sent.packets;
                intermediate.put("tx_packets", tx_packets);
                String byte_loss = tx_bytes > 0L ? Double.valueOf(100.0 * ((double)tx_bytes - (double)rx_bytes) / (double)tx_bytes) : "Not Available";
                intermediate.put("byte_loss", byte_loss);
                String packet_loss = tx_packets > 0L ? Double.valueOf(100.0 * ((double)tx_packets - (double)rx_packets) / (double)tx_packets) : "Not Available";
                intermediate.put("packet_loss", packet_loss);
                boolean bl = nothingReceived = dest.received == null || dest.received.firstPacketTime == null || dest.received.lastPacketTime == null;
                if (nothingReceived) {
                    duration = Double.NaN;
                } else {
                    long durationNs = ChronoUnit.NANOS.between(dest.received.firstPacketTime, dest.received.lastPacketTime);
                    duration = (double)durationNs / 1.0E9;
                }
                intermediate.put("duration", duration);
                Object object = throughput = tx_packets == 0L ? "Not Available" : Double.valueOf(0.0);
                if (duration != Double.NaN && duration > 0.0) {
                    throughput = (double)rx_bytes * 8.0 / duration;
                }
                intermediate.put("throughput", throughput);
                result.add(intermediate);
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private static long getNofVlans(Scenario data, String portName) {
        Object port;
        Object[] objectArray = data.ipv4Ports;
        int n = data.ipv4Ports.length;
        int n2 = 0;
        while (n2 < n) {
            port = objectArray[n2];
            if (((Scenario.Ipv4Port)port).name.equals(portName)) {
                return ((Scenario.Ipv4Port)port).vlans.length;
            }
            ++n2;
        }
        objectArray = data.ipv6Ports;
        n = data.ipv6Ports.length;
        n2 = 0;
        while (n2 < n) {
            port = objectArray[n2];
            if (((Scenario.Ipv6Port)port).name.equals(portName)) {
                return ((Scenario.Ipv6Port)port).vlans.length;
            }
            ++n2;
        }
        return 0L;
    }

    public static Collection<Map<String, Object>> fbOverallLatency(Scenario data) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            Scenario.FrameBlastingSource source = fb.source;
            Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = fb.destinations;
            int n3 = fb.destinations.length;
            int n4 = 0;
            while (n4 < n3) {
                Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                if (dest.latency != null) {
                    Scenario.FrameblastingLatencyResult latency = dest.latency;
                    HashMap<String, Object> intermediate = new HashMap<String, Object>();
                    result.add(intermediate);
                    intermediate.put("name", fb.config.name);
                    intermediate.put("source", source.name);
                    intermediate.put("destination", dest.name);
                    intermediate.put("min_latency", dest.received.packets == 0L ? null : Long.valueOf(latency.minimum));
                    intermediate.put("avg_latency", dest.received.packets == 0L ? null : Long.valueOf(latency.average));
                    intermediate.put("max_latency", dest.received.packets == 0L ? null : Long.valueOf(latency.maximum));
                    intermediate.put("jitter", dest.received.packets == 0L ? null : Long.valueOf(latency.jitter));
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public static Collection<Map<String, Object>> fbOverallOos(Scenario data) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            Scenario.FrameBlastingSource source = fb.source;
            Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = fb.destinations;
            int n3 = fb.destinations.length;
            int n4 = 0;
            while (n4 < n3) {
                Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                if (dest.outOfSequence != null) {
                    Scenario.FrameblastingOosResult oos = dest.outOfSequence;
                    HashMap<String, Object> intermediate = new HashMap<String, Object>();
                    result.add(intermediate);
                    intermediate.put("name", fb.config.name);
                    intermediate.put("source", source.name);
                    intermediate.put("destination", dest.name);
                    intermediate.put("packets_oos", oos.packetsOutOfSequence);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }
}

