/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LatencyDistributionGraphs {
    public static String generate(ScenarioWithPreferences results) {
        List<Scenario.FrameBlastingFlow> toRender = LatencyDistributionGraphs.gatherFlows(results);
        if (toRender.isEmpty()) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates/latency_distribution_graphs.html");
        context.put("fb_ccdf_results", LatencyDistributionGraphs.ccdfValues(toRender));
        context.put("fb_dist_results", LatencyDistributionGraphs.distributionValues(toRender));
        context.put("initial_latency_unit", results.initialLatencyUnit);
        return render.render(template, context);
    }

    private static Collection<Collection<Map<String, Object>>> distributionValues(List<Scenario.FrameBlastingFlow> toRender) {
        ArrayList<Collection<Map<String, Object>>> result = new ArrayList<Collection<Map<String, Object>>>();
        for (Scenario.FrameBlastingFlow flow : toRender) {
            Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = flow.destinations;
            int n = flow.destinations.length;
            int n2 = 0;
            while (n2 < n) {
                Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n2];
                Scenario.DistributionSnapshot[] distribution = dest.latency.distribution;
                if (distribution.length != 0) {
                    Arrays.sort(distribution, (a, b) -> Long.compare(a.start, b.start));
                    ArrayList currentResult = new ArrayList();
                    result.add(currentResult);
                    Scenario.DistributionSnapshot[] distributionSnapshotArray = distribution;
                    int n3 = distribution.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Scenario.DistributionSnapshot bin = distributionSnapshotArray[n4];
                        HashMap<String, Object> currentSample = new HashMap<String, Object>();
                        currentResult.add(currentSample);
                        currentSample.put("A", bin.start);
                        currentSample.put("B", Float.valueOf(bin.packets));
                        currentSample.put("C", flow.config.name);
                        currentSample.put("E", dest.name);
                        ++n4;
                    }
                    HashMap<String, Object> belowRange = new HashMap<String, Object>();
                    currentResult.add(belowRange);
                    belowRange.put("A", 0);
                    belowRange.put("B", dest.latency.packetsBelowRange);
                    belowRange.put("C", flow.config.name);
                    belowRange.put("E", dest.name);
                    HashMap<String, Object> aboveRange = new HashMap<String, Object>();
                    currentResult.add(aboveRange);
                    aboveRange.put("A", 0);
                    aboveRange.put("B", dest.latency.packetsAboveRange);
                    aboveRange.put("C", flow.config.name);
                    aboveRange.put("E", dest.name);
                }
                ++n2;
            }
        }
        return result;
    }

    private static Collection<Collection<Map<String, Object>>> ccdfValues(List<Scenario.FrameBlastingFlow> toRender) {
        ArrayList<Collection<Map<String, Object>>> result = new ArrayList<Collection<Map<String, Object>>>();
        for (Scenario.FrameBlastingFlow flow : toRender) {
            Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = flow.destinations;
            int n = flow.destinations.length;
            int n2 = 0;
            while (n2 < n) {
                Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n2];
                Scenario.DistributionSnapshot[] distribution = dest.latency.distribution;
                Arrays.sort(distribution, (a, b) -> Long.compare(a.start, b.start));
                ArrayList<Scenario.DistributionSnapshot> list = new ArrayList<Scenario.DistributionSnapshot>(Arrays.asList(distribution));
                if (!list.isEmpty()) {
                    do {
                        Scenario.DistributionSnapshot first = (Scenario.DistributionSnapshot)list.get(0);
                        if (first.packets != 0L) break;
                        list.remove(0);
                    } while (list.size() > 0);
                }
                int lastIndex = -1;
                while (list.size() != 0) {
                    lastIndex = list.size() - 1;
                    Scenario.DistributionSnapshot last = (Scenario.DistributionSnapshot)list.get(lastIndex);
                    if (last.packets != 0L) break;
                    list.remove(lastIndex);
                    if (lastIndex >= 0) continue;
                }
                ArrayList currentResult = new ArrayList();
                result.add(currentResult);
                HashMap<String, Object> currentSample = new HashMap<String, Object>();
                currentResult.add(currentSample);
                currentSample.put("A", 0);
                currentSample.put("B", Float.valueOf(dest.latency.packetsBelowRange));
                currentSample.put("C", flow.config.name);
                currentSample.put("E", dest.name);
                long totalPacketsInBins = 0L;
                for (Scenario.DistributionSnapshot bin : list) {
                    HashMap<String, Object> currentSample2 = new HashMap<String, Object>();
                    currentResult.add(currentSample2);
                    currentSample2.put("A", bin.start);
                    currentSample2.put("B", Float.valueOf(bin.packets));
                    currentSample2.put("C", flow.config.name);
                    currentSample2.put("E", dest.name);
                    totalPacketsInBins += bin.packets;
                }
                HashMap<String, Object> currentSample3 = new HashMap<String, Object>();
                currentResult.add(currentSample3);
                currentSample3.put("A", 0);
                currentSample3.put("B", Float.valueOf(totalPacketsInBins));
                currentSample3.put("C", flow.config.name);
                currentSample3.put("E", dest.name);
                currentSample3 = new HashMap();
                currentResult.add(currentSample3);
                currentSample3.put("A", 0);
                currentSample3.put("B", Float.valueOf(dest.latency.packetsAboveRange));
                currentSample3.put("C", flow.config.name);
                currentSample3.put("E", dest.name);
                currentSample3 = new HashMap();
                currentResult.add(currentSample3);
                currentSample3.put("A", 0);
                currentSample3.put("B", Float.valueOf(dest.received.packets));
                currentSample3.put("C", flow.config.name);
                currentSample3.put("E", dest.name);
                ++n2;
            }
        }
        return result;
    }

    private static List<Scenario.FrameBlastingFlow> gatherFlows(Scenario data) {
        ArrayList<Scenario.FrameBlastingFlow> flowsToRender = new ArrayList<Scenario.FrameBlastingFlow>();
        if (data.frameBlastingFlows == null) {
            return flowsToRender;
        }
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            if (fb.destinations != null) {
                Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = fb.destinations;
                int n3 = fb.destinations.length;
                int n4 = 0;
                while (n4 < n3) {
                    boolean hasDistribution;
                    Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                    boolean bl = hasDistribution = dest.latency != null && dest.latency.distribution != null;
                    if (hasDistribution && dest.latency.distribution.length > 0) {
                        flowsToRender.add(fb);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return flowsToRender;
    }
}

