/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class NatTable {
    public static String generateV2(Scenario data) {
        if (!NatTable.shouldRender(data)) {
            return "";
        }
        HashMap<String, Collection<Map<String, Object>>> context = new HashMap<String, Collection<Map<String, Object>>>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates_nov_2023/nat_table.html");
        context.put("nat_table_content", NatTable.nat_translations(data));
        return render.render(template, context);
    }

    public static String generate(Scenario data) {
        if (!NatTable.shouldRender(data)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates/nat_table.html");
        context.put("nat_table_content", NatTable.nat_translations(data));
        context.put("nat_image", Util.load("NAT_image.svg"));
        return render.render(template, context);
    }

    static boolean shouldRender(Scenario data) {
        if (data.ipv4Ports != null) {
            Scenario.Ipv4Port[] ipv4PortArray = data.ipv4Ports;
            int n = data.ipv4Ports.length;
            int n2 = 0;
            while (n2 < n) {
                Scenario.Ipv4Port port = ipv4PortArray[n2];
                if (port.natDiscoveries.length > 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Collection<Map<String, Object>> nat_translations(Scenario data) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Scenario.Ipv4Port[] ipv4PortArray = data.ipv4Ports;
        int n = data.ipv4Ports.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.Ipv4Port port = ipv4PortArray[n2];
            Scenario.Nat[] natArray = port.natDiscoveries;
            int n3 = port.natDiscoveries.length;
            int n4 = 0;
            while (n4 < n3) {
                Scenario.Nat nat = natArray[n4];
                HashMap<String, Object> intermediate = new HashMap<String, Object>();
                result.add(intermediate);
                intermediate.put("private_end", nat.privateByteBlowerPort);
                intermediate.put("protocol", nat.protocol);
                intermediate.put("private_ipv4", nat.privateIpAddress);
                intermediate.put("private_port", nat.privateL4Port);
                intermediate.put("public_ipv4", String.valueOf(nat.publicIpAddress) + " (" + nat.ipDiscoveryMethod + ")");
                intermediate.put("public_port", String.valueOf(nat.publicL4Port) + " (" + nat.portDiscoveryMethod + ")");
                intermediate.put("public_end", nat.publicByteBlowerPort);
                ++n4;
            }
            ++n2;
        }
        return result;
    }
}

