/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Rfc2544 {
    public static String generate(ScenarioWithPreferences results) {
        if (!Rfc2544.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates/rfc2544_tables.html");
        ArrayList<StructuredRFC2544> rfcs = new ArrayList<StructuredRFC2544>();
        Scenario.Rfc2544Flow[] rfc2544FlowArray = results.rfc2544Flows;
        int n = results.rfc2544Flows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.Rfc2544Flow rfc2544 = rfc2544FlowArray[n2];
            Rfc2544.preprocess(rfc2544, rfcs);
            ++n2;
        }
        context.put("rfc2544_results", Rfc2544.process(rfcs));
        context.put("initial_throughput_frame_overhead", results.initialThroughputFrameOverhead);
        return render.render(template, context);
    }

    private static Collection<Map<String, Object>> process(Collection<StructuredRFC2544> rfcs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (StructuredRFC2544 rfc2544 : rfcs) {
            HashMap<String, Object> intermediate = new HashMap<String, Object>();
            intermediate.put("source", rfc2544.source);
            intermediate.put("destination", rfc2544.destination);
            intermediate.put("flow", rfc2544.flow);
            intermediate.put("acceptableLoss", rfc2544.acceptableLoss);
            intermediate.put("iterationDuration", rfc2544.iterationDuration);
            ArrayList measurements = new ArrayList();
            for (StructuredRFC2544Measurement measurement : rfc2544.measurements) {
                HashMap<String, Number> details = new HashMap<String, Number>();
                details.put("actualLoss", measurement.actualLoss);
                details.put("packetSize", measurement.packetSize);
                details.put("receivedL1BitRate", measurement.receivedL1BitRate);
                details.put("receivedFrameRate", measurement.receivedFrameRate);
                measurements.add(details);
            }
            intermediate.put("measurements", measurements);
            result.add(intermediate);
        }
        return result;
    }

    private static void preprocess(Scenario.Rfc2544Flow rfc2544, Collection<StructuredRFC2544> rfcs) {
        StructuredRFC2544 structured = Rfc2544.getExistingRfc(rfc2544, rfcs);
        if (structured == null) {
            Rfc2544.addTest(rfc2544, rfcs);
        } else {
            Rfc2544.addMeasurement(rfc2544, structured);
        }
    }

    private static void addMeasurement(Scenario.Rfc2544Flow rfc2544, StructuredRFC2544 structured) {
        structured.measurements.add(new StructuredRFC2544Measurement(rfc2544));
    }

    private static void addTest(Scenario.Rfc2544Flow rfc2544, Collection<StructuredRFC2544> rfcs) {
        StructuredRFC2544 structured = new StructuredRFC2544();
        rfcs.add(structured);
        structured.source = rfc2544.source;
        structured.destination = rfc2544.destination;
        structured.flow = rfc2544.flow;
        structured.acceptableLoss = rfc2544.acceptableLoss;
        structured.iterationDuration = rfc2544.iterationDuration;
        Rfc2544.addMeasurement(rfc2544, structured);
    }

    private static StructuredRFC2544 getExistingRfc(Scenario.Rfc2544Flow rfc2544, Collection<StructuredRFC2544> rfcs) {
        for (StructuredRFC2544 structured : rfcs) {
            if (!structured.source.equals(rfc2544.source) || !structured.destination.equals(rfc2544.destination) || !structured.flow.equals(rfc2544.flow) || !structured.acceptableLoss.equals(rfc2544.acceptableLoss) || !structured.iterationDuration.equals(rfc2544.iterationDuration)) continue;
            return structured;
        }
        return null;
    }

    static boolean shouldRender(Scenario data) {
        return data.rfc2544Flows != null && data.rfc2544Flows.length > 0;
    }

    private static class StructuredRFC2544 {
        public String source;
        public String destination;
        public String flow;
        public Double acceptableLoss;
        public Long iterationDuration;
        public Collection<StructuredRFC2544Measurement> measurements = new ArrayList<StructuredRFC2544Measurement>();

        private StructuredRFC2544() {
        }
    }

    private static class StructuredRFC2544Measurement {
        public Long packetSize;
        public Double receivedL1BitRate;
        public Double receivedFrameRate;
        public Double actualLoss;

        public StructuredRFC2544Measurement(Scenario.Rfc2544Flow rfc2544) {
            this.packetSize = rfc2544.packetSize;
            this.receivedL1BitRate = rfc2544.receivedByteRate * 8.0;
            this.receivedFrameRate = rfc2544.receivedFrameRate;
            this.actualLoss = rfc2544.actualLoss;
        }
    }
}

