/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TCPAggregateGraphs {
    private static List<String> flowNames = new ArrayList<String>();

    public static String generate(ScenarioWithPreferences results) {
        if (!TCPAggregateGraphs.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("tcp_aggregate_interval_results", TCPAggregateGraphs.fillTcpResults(results));
        context.put("initial_throughput_unit", results.initialThroughputUnit);
        context.put("initial_latency_unit", results.initialLatencyUnit);
        context.put("max_time", results.getMaxTime());
        Jinjava render = Util.get();
        String template = Util.load("html_templates/tcp_aggregate_graphs.html");
        return render.render(template, context);
    }

    private static boolean shouldRender(ScenarioWithPreferences results) {
        if (results.firstMoment() == null || results.lastMoment() == null) {
            return false;
        }
        HashMap<String, List<Scenario.TcpEndpoint>> portsToSum = TCPAggregateGraphs.byteblowerPortsInUse(results);
        for (String portName : portsToSum.keySet()) {
            List<Scenario.TcpEndpoint> endpoints = portsToSum.get(portName);
            if (endpoints.size() < 2) continue;
            return true;
        }
        return false;
    }

    private static HashMap<String, List<Scenario.TcpEndpoint>> byteblowerPortsInUse(ScenarioWithPreferences results) {
        Scenario.HttpFlow[] httpFlows = results.httpFlows;
        HashMap<String, List<Scenario.TcpEndpoint>> portsToSum = new HashMap<String, List<Scenario.TcpEndpoint>>();
        Scenario.HttpFlow[] httpFlowArray = httpFlows;
        int n = httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.TcpEndpoint serverSession;
            List<Scenario.TcpEndpoint> sessions;
            Scenario.HttpFlow httpFlow = httpFlowArray[n2];
            String flowName = httpFlow.name;
            String method = httpFlow.method;
            String acksPostfix = "(ACKS)";
            Scenario.TcpEndpoint clientSession = httpFlow.tcpClient;
            if (clientSession != null) {
                String post = "PUT".equals(method) ? acksPostfix : "";
                flowNames.add(String.valueOf(flowName) + post);
                String clientPort = clientSession.portName;
                sessions = portsToSum.get(clientPort);
                if (sessions == null) {
                    sessions = new ArrayList<Scenario.TcpEndpoint>();
                    portsToSum.put(clientPort, sessions);
                }
                sessions.add(clientSession);
            }
            if ((serverSession = httpFlow.tcpServer) != null) {
                String post = "GET".equals(method) ? acksPostfix : "";
                flowNames.add(String.valueOf(flowName) + post);
                String serverPort = serverSession.portName;
                sessions = portsToSum.get(serverPort);
                if (sessions == null) {
                    sessions = new ArrayList<Scenario.TcpEndpoint>();
                    portsToSum.put(serverPort, sessions);
                }
                sessions.add(serverSession);
            }
            ++n2;
        }
        return portsToSum;
    }

    public static Object fillTcpResults(ScenarioWithPreferences results) {
        ArrayList result = new ArrayList();
        HashMap<String, List<Scenario.TcpEndpoint>> portsToSum = TCPAggregateGraphs.byteblowerPortsInUse(results);
        ZonedDateTime startTime = results.firstMoment();
        for (String portName : portsToSum.keySet()) {
            List<Scenario.TcpEndpoint> endpoints = portsToSum.get(portName);
            if (endpoints.size() < 2) continue;
            ArrayList line = new ArrayList();
            for (Scenario.TcpEndpoint ep : endpoints) {
                Scenario.TcpSnapshot[] tcpSnapshotArray = ep.overTimeResults;
                int n = ep.overTimeResults.length;
                int n2 = 0;
                while (n2 < n) {
                    Scenario.TcpSnapshot snap = tcpSnapshotArray[n2];
                    HashMap<String, Object> snapshot = new HashMap<String, Object>();
                    line.add(snapshot);
                    snapshot.put("A", TCPAggregateGraphs.getFlowName(ep, results));
                    long millis = ChronoUnit.MILLIS.between(startTime, snap.timestamp);
                    snapshot.put("B", millis);
                    snapshot.put("C", snap.rxTotal * 8L);
                    snapshot.put("D", ep.portName);
                    ++n2;
                }
            }
            if (line.isEmpty()) continue;
            result.add(line);
        }
        return result;
    }

    private static Object getFlowName(Scenario.TcpEndpoint ep, ScenarioWithPreferences results) {
        Scenario.HttpFlow[] httpFlows;
        Scenario.HttpFlow[] httpFlowArray = httpFlows = results.httpFlows;
        int n = httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.HttpFlow httpFlow = httpFlowArray[n2];
            String post = "";
            if (httpFlow.tcpClient == ep) {
                if ("PUT".equals(httpFlow.method)) {
                    post = " (ACKS)";
                }
                return String.valueOf(httpFlow.name) + post;
            }
            if (httpFlow.tcpServer == ep) {
                if ("GET".equals(httpFlow.method)) {
                    post = " (ACKS)";
                }
                return String.valueOf(httpFlow.name) + post;
            }
            ++n2;
        }
        return null;
    }
}

