/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class TCPAggregateRx {
    private static final Logger LOGGER = Logger.getGlobal();

    public static String generate(ScenarioWithPreferences results) {
        if (!TCPAggregateRx.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("tcp_aggregate_rx_results", TCPAggregateRx.fillAggregateTcpResults(results));
        context.put("initial_throughput_unit", results.initialThroughputUnit);
        Jinjava render = Util.get();
        String template = Util.load("html_templates/tcp_aggregate_rx_table.html");
        return render.render(template, context);
    }

    /*
     * Unable to fully structure code
     */
    private static Object fillAggregateTcpResults(Scenario data) {
        result = new ArrayList<Object>();
        rxAggregationMap = new HashMap<String, RxTcpAggregation>();
        rxSession = null;
        var8_4 = data.httpFlows;
        var7_5 = data.httpFlows.length;
        var6_7 = 0;
        while (var6_7 < var7_5) {
            block5: {
                tcpFlow = var8_4[var6_7];
                if (!"GET".equals(tcpFlow.method)) break block5;
                rxSession = tcpFlow.httpClient;
                ** GOTO lbl18
            }
            if (!"PUT".equals(tcpFlow.method)) {
                msg = String.format("Unknown HTTP Method: '%s'", new Object[]{tcpFlow.method});
                TCPAggregateRx.LOGGER.warning(msg);
            } else {
                rxSession = tcpFlow.httpServer;
lbl18:
                // 2 sources

                rxAggregation = (RxTcpAggregation)rxAggregationMap.get(rxSession.portName);
                if (rxAggregation == null) {
                    rxAggregation = new RxTcpAggregation(rxSession.portName);
                    rxAggregationMap.put(rxSession.portName, rxAggregation);
                }
                rxAggregation.add(rxSession);
            }
            ++var6_7;
        }
        for (String port : rxAggregationMap.keySet()) {
            tcpAggregation = (RxTcpAggregation)rxAggregationMap.get(port);
            if (!tcpAggregation.valid()) continue;
            result.add(tcpAggregation.createRxBean());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    static boolean shouldRender(Scenario data) {
        if (data.httpFlows == null || data.httpFlows.length == 0) {
            return false;
        }
        var4_1 = data.httpFlows;
        var3_2 = data.httpFlows.length;
        var2_3 = 0;
        while (var2_3 < var3_2) {
            block9: {
                httpFlow = var4_1[var2_3];
                receivingHttp = null;
                receivingTcp = null;
                sendingTcp = null;
                if (!"GET".equals(httpFlow.method)) break block9;
                sendingTcp = httpFlow.tcpServer;
                ** GOTO lbl21
            }
            if (!"PUT".equals(httpFlow.method)) {
                msg = String.format("Unknown HTTP Method: '%s'", new Object[]{httpFlow.method});
                TCPAggregateRx.LOGGER.warning(msg);
            } else {
                receivingHttp = httpFlow.httpServer;
                receivingTcp = httpFlow.tcpServer;
lbl21:
                // 2 sources

                if (!httpFlow.clientIsMobile()) {
                    if ("GET".equals(httpFlow.method)) {
                        receivingHttp = httpFlow.httpClient;
                        receivingTcp = httpFlow.tcpClient;
                    } else if ("PUT".equals(httpFlow.method)) {
                        sendingTcp = httpFlow.tcpClient;
                    }
                }
                if (receivingHttp != null && receivingHttp.overTimeResults.length > 0 || receivingTcp != null && receivingTcp.overTimeResults.length > 0 || sendingTcp != null && sendingTcp.overTimeResults.length > 0) {
                    return true;
                }
            }
            ++var2_3;
        }
        return false;
    }

    static class RxTcpAggregation {
        private List<Scenario.HttpEndpoint> httpSessions = new ArrayList<Scenario.HttpEndpoint>();
        private String portName;
        private boolean hasSessions;

        public RxTcpAggregation(String portName) {
            this.portName = portName;
            this.hasSessions = false;
        }

        public void add(Scenario.HttpEndpoint httpSession) {
            if (httpSession != null && httpSession.rxFirst != null) {
                this.httpSessions.add(httpSession);
                this.hasSessions = true;
            }
        }

        public boolean valid() {
            return this.hasSessions;
        }

        private long timeDifference(ZonedDateTime d1, ZonedDateTime d2, ChronoUnit unit) {
            return unit.between(d1, d2);
        }

        protected Object createRxBean() {
            Collections.sort(this.httpSessions, new Comparator<Scenario.HttpEndpoint>(){

                @Override
                public int compare(Scenario.HttpEndpoint lhs, Scenario.HttpEndpoint rhs) {
                    ZonedDateTime lhsRxFirstByteTime = lhs.rxFirst;
                    ZonedDateTime rhsRxFirstByteTime = rhs.rxFirst;
                    return lhsRxFirstByteTime.compareTo(rhsRxFirstByteTime);
                }
            });
            ZonedDateTime smallestFirstByteTime = null;
            ZonedDateTime rxFirstByteTime = this.httpSessions.get((int)0).rxFirst;
            if (rxFirstByteTime != null) {
                smallestFirstByteTime = rxFirstByteTime;
            }
            ZonedDateTime biggestLastByteTime = null;
            Long totalGapTime = 0L;
            Long totalRxBytes = 0L;
            for (Scenario.HttpEndpoint httpSession : this.httpSessions) {
                if (httpSession.rxLast != null && biggestLastByteTime == null) {
                    biggestLastByteTime = httpSession.rxLast;
                } else {
                    if (httpSession.rxFirst != null && httpSession.rxFirst.compareTo(biggestLastByteTime) > 0) {
                        totalGapTime = totalGapTime + this.timeDifference(httpSession.rxFirst, biggestLastByteTime, ChronoUnit.NANOS);
                    }
                    if (httpSession.rxLast != null && httpSession.rxLast.compareTo(biggestLastByteTime) > 0) {
                        biggestLastByteTime = httpSession.rxLast;
                    }
                }
                Long rxByteCount = httpSession.rxBytes;
                if (rxByteCount == null) continue;
                totalRxBytes = totalRxBytes + rxByteCount;
            }
            Long aliveDuration = 0L;
            if (biggestLastByteTime != null && smallestFirstByteTime != null) {
                aliveDuration = this.timeDifference(smallestFirstByteTime, biggestLastByteTime, ChronoUnit.NANOS);
            }
            Long activeDuration = aliveDuration - totalGapTime;
            HashMap<String, Object> snapshot = new HashMap<String, Object>();
            snapshot.put("aggregate_port", this.portName);
            snapshot.put("aggregate_bytes", totalRxBytes);
            snapshot.put("aggregate_alive_duration", aliveDuration);
            snapshot.put("aggregate_alive_throughput", this.calculateThroughput(aliveDuration, totalRxBytes));
            snapshot.put("aggregate_active_duration", activeDuration);
            snapshot.put("aggregate_active_throughput", this.calculateThroughput(activeDuration, totalRxBytes));
            return snapshot;
        }

        private double calculateThroughput(long timeInNs, long totalNofBytesReceived) {
            double throughputBps = 0.0;
            if (timeInNs > 0L && totalNofBytesReceived > 0L) {
                throughputBps = totalNofBytesReceived;
                throughputBps *= 1.0E9;
                throughputBps /= (double)timeInNs;
            }
            return throughputBps;
        }
    }
}

