/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class TCPAggregateTx {
    private static final Logger LOGGER = Logger.getGlobal();

    public static String generate(ScenarioWithPreferences results) {
        if (!TCPAggregateTx.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("tcp_aggregate_tx_results", TCPAggregateTx.fillAggregateTcpResults(results));
        context.put("initial_throughput_unit", results.initialThroughputUnit);
        Jinjava render = Util.get();
        String template = Util.load("html_templates/tcp_aggregate_tx_table.html");
        return render.render(template, context);
    }

    /*
     * Unable to fully structure code
     */
    private static Object fillAggregateTcpResults(Scenario data) {
        result = new ArrayList<Object>();
        txAggregationMap = new HashMap<String, TxTcpAggregation>();
        txSession = null;
        var8_4 = data.httpFlows;
        var7_5 = data.httpFlows.length;
        var6_7 = 0;
        while (var6_7 < var7_5) {
            block5: {
                httpFlow = var8_4[var6_7];
                if (!"GET".equals(httpFlow.method)) break block5;
                txSession = httpFlow.httpServer;
                ** GOTO lbl18
            }
            if (!"PUT".equals(httpFlow.method)) {
                msg = String.format("Unknown HTTP Method: '%s'", new Object[]{httpFlow.method});
                TCPAggregateTx.LOGGER.warning(msg);
            } else {
                txSession = httpFlow.httpClient;
lbl18:
                // 2 sources

                txAggregation = (TxTcpAggregation)txAggregationMap.get(txSession.portName);
                if (txAggregation == null) {
                    txAggregation = new TxTcpAggregation(txSession.portName);
                    txAggregationMap.put(txSession.portName, txAggregation);
                }
                txAggregation.add(txSession);
            }
            ++var6_7;
        }
        for (String port : txAggregationMap.keySet()) {
            tcpAggregation = (TxTcpAggregation)txAggregationMap.get(port);
            if (!tcpAggregation.valid()) continue;
            result.add(tcpAggregation.createTxBean());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    static boolean shouldRender(Scenario data) {
        if (data.httpFlows == null || data.httpFlows.length == 0) {
            return false;
        }
        var4_1 = data.httpFlows;
        var3_2 = data.httpFlows.length;
        var2_3 = 0;
        while (var2_3 < var3_2) {
            block9: {
                httpFlow = var4_1[var2_3];
                receivingHttp = null;
                receivingTcp = null;
                sendingTcp = null;
                if (!"GET".equals(httpFlow.method)) break block9;
                sendingTcp = httpFlow.tcpServer;
                ** GOTO lbl21
            }
            if (!"PUT".equals(httpFlow.method)) {
                msg = String.format("Unknown HTTP Method: '%s'", new Object[]{httpFlow.method});
                TCPAggregateTx.LOGGER.warning(msg);
            } else {
                receivingHttp = httpFlow.httpServer;
                receivingTcp = httpFlow.tcpServer;
lbl21:
                // 2 sources

                if (!httpFlow.clientIsMobile()) {
                    if ("GET".equals(httpFlow.method)) {
                        receivingHttp = httpFlow.httpClient;
                        receivingTcp = httpFlow.tcpClient;
                    } else if ("PUT".equals(httpFlow.method)) {
                        sendingTcp = httpFlow.tcpClient;
                    }
                }
                if (receivingHttp != null && receivingHttp.overTimeResults.length > 0 || receivingTcp != null && receivingTcp.overTimeResults.length > 0 || sendingTcp != null && sendingTcp.overTimeResults.length > 0) {
                    return true;
                }
            }
            ++var2_3;
        }
        return false;
    }

    private static final class TxTcpAggregation {
        private final List<Scenario.HttpEndpoint> httpSessions = new ArrayList<Scenario.HttpEndpoint>();
        private final String portName;
        private boolean hasSessions;

        public TxTcpAggregation(String portName) {
            this.portName = portName;
            this.hasSessions = false;
        }

        public void add(Scenario.HttpEndpoint httpSession) {
            if (httpSession != null && httpSession.txFirst != null) {
                this.httpSessions.add(httpSession);
                this.hasSessions = true;
            }
        }

        public boolean valid() {
            return this.hasSessions;
        }

        private long timeDifference(ZonedDateTime d1, ZonedDateTime d2, ChronoUnit unit) {
            return unit.between(d1, d2);
        }

        protected Object createTxBean() {
            Scenario.HttpEndpoint session;
            Collections.sort(this.httpSessions, new Comparator<Scenario.HttpEndpoint>(){

                @Override
                public int compare(Scenario.HttpEndpoint lhs, Scenario.HttpEndpoint rhs) {
                    ZonedDateTime lhsTxFirstByteTime = lhs.txFirst;
                    ZonedDateTime rhsTxFirstByteTime = rhs.txFirst;
                    return lhsTxFirstByteTime.compareTo(rhsTxFirstByteTime);
                }
            });
            ZonedDateTime aggregateFirstTx = null;
            ZonedDateTime aggregateLastTx = null;
            long gapTime = 0L;
            long totalTxBytes = this.sumTxbytes();
            Iterator<Scenario.HttpEndpoint> sessionIt = this.httpSessions.iterator();
            if (sessionIt.hasNext()) {
                session = sessionIt.next();
                aggregateFirstTx = session.txFirst;
                aggregateLastTx = session.txLast;
            }
            while (sessionIt.hasNext()) {
                session = sessionIt.next();
                ZonedDateTime firstTx = session.txFirst;
                if (firstTx.isAfter(aggregateLastTx)) {
                    gapTime += this.timeDifference(aggregateLastTx, firstTx, ChronoUnit.NANOS);
                }
                if (!session.txLast.isAfter(aggregateLastTx)) continue;
                aggregateLastTx = session.txLast;
            }
            long aliveDuration = 0L;
            long activeDuration = 0L;
            if (totalTxBytes > 0L) {
                aliveDuration = this.timeDifference(aggregateFirstTx, aggregateLastTx, ChronoUnit.NANOS);
                activeDuration = aliveDuration - gapTime;
            }
            HashMap<String, Object> snapshot = new HashMap<String, Object>();
            snapshot.put("aggregate_port", this.portName);
            snapshot.put("aggregate_bytes", totalTxBytes);
            snapshot.put("aggregate_alive_duration", aliveDuration);
            snapshot.put("aggregate_alive_throughput", this.calculateThroughput(aliveDuration, totalTxBytes));
            snapshot.put("aggregate_active_duration", activeDuration);
            snapshot.put("aggregate_active_throughput", this.calculateThroughput(activeDuration, totalTxBytes));
            return snapshot;
        }

        private long sumTxbytes() {
            long transmitted = 0L;
            for (Scenario.HttpEndpoint session : this.httpSessions) {
                Long txSession = session.txBytes;
                if (txSession == null) continue;
                transmitted += txSession.longValue();
            }
            return transmitted;
        }

        private double calculateThroughput(long timeInNs, long totalNofBytesReceived) {
            double throughputBps = 0.0;
            if (timeInNs > 0L && totalNofBytesReceived > 0L) {
                throughputBps = totalNofBytesReceived;
                throughputBps *= 1.0E9;
                throughputBps /= (double)timeInNs;
            }
            return throughputBps;
        }
    }
}

