/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public class TCPGraphs {
    private static final Logger LOGGER = Logger.getGlobal();

    public static String generate(ScenarioWithPreferences results) {
        if (!TCPGraphs.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("tcp_interval_results", TCPGraphs.fillTcpResults(results));
        context.put("initial_throughput_unit", results.initialThroughputUnit);
        context.put("initial_latency_unit", results.initialLatencyUnit);
        context.put("max_time", results.getMaxTime());
        Jinjava render = Util.get();
        String template = Util.load("html_templates/tcp_graphs.html");
        return render.render(template, context);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Object fillTcpResults(Scenario data) {
        ArrayList result = new ArrayList();
        ZonedDateTime startMoment = data.firstMoment();
        Scenario.HttpFlow[] httpFlowArray = data.httpFlows;
        int n = data.httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            block23: {
                long millis;
                HashMap<String, Object> snapshot;
                Object overTime;
                int n3;
                int n4;
                Object[] objectArray;
                Scenario.TcpEndpoint sendingTcpEndpoint;
                Scenario.TcpEndpoint tcpEndpoint;
                ArrayList line;
                Scenario.HttpFlow httpFlow;
                block27: {
                    boolean isMobile;
                    block24: {
                        Scenario.HttpEndpoint httpEndpoint;
                        block20: {
                            block22: {
                                block21: {
                                    block19: {
                                        httpFlow = httpFlowArray[n2];
                                        line = new ArrayList();
                                        result.add(line);
                                        httpEndpoint = null;
                                        tcpEndpoint = null;
                                        sendingTcpEndpoint = null;
                                        isMobile = httpFlow.clientIsMobile();
                                        if (!isMobile) break block19;
                                        httpEndpoint = httpFlow.httpServer;
                                        tcpEndpoint = httpFlow.tcpServer;
                                        if ("GET".equals(httpFlow.method)) {
                                            sendingTcpEndpoint = httpFlow.tcpServer;
                                        }
                                        break block20;
                                    }
                                    if (!"GET".equals(httpFlow.method)) break block21;
                                    httpEndpoint = httpFlow.httpClient;
                                    tcpEndpoint = httpFlow.tcpClient;
                                    sendingTcpEndpoint = httpFlow.tcpServer;
                                    break block20;
                                }
                                if ("PUT".equals(httpFlow.method)) break block22;
                                String msg = String.format("Unknown HTTP Method: '%s'", httpFlow.method);
                                LOGGER.warning(msg);
                                break block23;
                            }
                            httpEndpoint = httpFlow.httpServer;
                            tcpEndpoint = httpFlow.tcpServer;
                            sendingTcpEndpoint = httpFlow.tcpClient;
                        }
                        if (httpEndpoint == null) break block24;
                        objectArray = httpEndpoint.overTimeResults;
                        n4 = httpEndpoint.overTimeResults.length;
                        n3 = 0;
                        while (n3 < n4) {
                            block26: {
                                block25: {
                                    overTime = objectArray[n3];
                                    snapshot = new HashMap<String, Object>();
                                    line.add(snapshot);
                                    snapshot.put("A", httpFlow.name);
                                    snapshot.put("B", "X");
                                    snapshot.put("F", "X");
                                    millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.HttpSnapshot)overTime).timestamp);
                                    snapshot.put("C", millis);
                                    if (!isMobile) break block25;
                                    if ("GET".equals(httpFlow.method)) {
                                        snapshot.put("D", ((Scenario.HttpSnapshot)overTime).txBytes * 8L);
                                        break block26;
                                    } else if ("PUT".equals(httpFlow.method)) {
                                        snapshot.put("D", ((Scenario.HttpSnapshot)overTime).rxBytes * 8L);
                                    }
                                    break block26;
                                }
                                snapshot.put("D", ((Scenario.HttpSnapshot)overTime).rxBytes * 8L);
                            }
                            ++n3;
                        }
                    }
                    if (tcpEndpoint == null) break block27;
                    objectArray = tcpEndpoint.overTimeResults;
                    n4 = tcpEndpoint.overTimeResults.length;
                    n3 = 0;
                    while (n3 < n4) {
                        block29: {
                            block28: {
                                overTime = objectArray[n3];
                                snapshot = new HashMap();
                                line.add(snapshot);
                                snapshot.put("A", httpFlow.name);
                                snapshot.put("B", "V");
                                snapshot.put("F", "V");
                                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                                snapshot.put("C", millis);
                                if (!isMobile) break block28;
                                if ("GET".equals(httpFlow.method)) {
                                    snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txTotal * 8L);
                                    break block29;
                                } else if ("PUT".equals(httpFlow.method)) {
                                    snapshot.put("D", ((Scenario.TcpSnapshot)overTime).rxTotal * 8L);
                                }
                                break block29;
                            }
                            snapshot.put("D", ((Scenario.TcpSnapshot)overTime).rxTotal * 8L);
                        }
                        ++n3;
                    }
                }
                if (tcpEndpoint != null && sendingTcpEndpoint == null) {
                    objectArray = tcpEndpoint.overTimeResults;
                    n4 = tcpEndpoint.overTimeResults.length;
                    n3 = 0;
                    while (n3 < n4) {
                        overTime = objectArray[n3];
                        snapshot = new HashMap();
                        line.add(snapshot);
                        snapshot.put("A", httpFlow.name);
                        snapshot.put("B", "Q");
                        snapshot.put("F", "Q");
                        millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                        snapshot.put("C", millis);
                        snapshot.put("D", ((Scenario.TcpSnapshot)overTime).localECNMarkings);
                        ++n3;
                    }
                }
                if (sendingTcpEndpoint != null) {
                    objectArray = sendingTcpEndpoint.overTimeResults;
                    n4 = sendingTcpEndpoint.overTimeResults.length;
                    n3 = 0;
                    while (n3 < n4) {
                        overTime = objectArray[n3];
                        snapshot = new HashMap();
                        line.add(snapshot);
                        snapshot.put("A", httpFlow.name);
                        snapshot.put("B", "T");
                        snapshot.put("F", "T");
                        millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                        snapshot.put("C", millis);
                        snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txTotal == 0L ? null : Long.valueOf(((Scenario.TcpSnapshot)overTime).rttCurrent));
                        ++n3;
                    }
                    objectArray = sendingTcpEndpoint.overTimeResults;
                    n4 = sendingTcpEndpoint.overTimeResults.length;
                    n3 = 0;
                    while (n3 < n4) {
                        overTime = objectArray[n3];
                        snapshot = new HashMap();
                        line.add(snapshot);
                        snapshot.put("A", httpFlow.name);
                        snapshot.put("B", "S");
                        snapshot.put("F", "S");
                        millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                        snapshot.put("C", millis);
                        snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txTotal == 0L ? null : Long.valueOf(((Scenario.TcpSnapshot)overTime).rttMaximum));
                        ++n3;
                    }
                    objectArray = sendingTcpEndpoint.overTimeResults;
                    n4 = sendingTcpEndpoint.overTimeResults.length;
                    n3 = 0;
                    while (n3 < n4) {
                        overTime = objectArray[n3];
                        snapshot = new HashMap();
                        line.add(snapshot);
                        snapshot.put("A", httpFlow.name);
                        snapshot.put("B", "R");
                        snapshot.put("F", "R");
                        millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                        snapshot.put("C", millis);
                        snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txTotal == 0L ? null : Long.valueOf(((Scenario.TcpSnapshot)overTime).rttMinimum));
                        ++n3;
                    }
                    objectArray = sendingTcpEndpoint.overTimeResults;
                    n4 = sendingTcpEndpoint.overTimeResults.length;
                    n3 = 0;
                    while (n3 < n4) {
                        overTime = objectArray[n3];
                        snapshot = new HashMap();
                        line.add(snapshot);
                        snapshot.put("A", httpFlow.name);
                        snapshot.put("B", "U");
                        snapshot.put("F", "U");
                        millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                        snapshot.put("C", millis);
                        long receiveWindow = Math.min(((Scenario.TcpSnapshot)overTime).congestionWindowCurrent, ((Scenario.TcpSnapshot)overTime).receiverWindowCurrent);
                        float byteToKb = 0.001f;
                        snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txTotal == 0L ? null : Float.valueOf(byteToKb * (float)receiveWindow));
                        ++n3;
                    }
                    objectArray = sendingTcpEndpoint.overTimeResults;
                    n4 = sendingTcpEndpoint.overTimeResults.length;
                    n3 = 0;
                    while (n3 < n4) {
                        overTime = objectArray[n3];
                        snapshot = new HashMap();
                        line.add(snapshot);
                        snapshot.put("A", httpFlow.name);
                        snapshot.put("B", "Z");
                        snapshot.put("F", "Z");
                        millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                        snapshot.put("C", millis);
                        long totalRetransmissions = ((Scenario.TcpSnapshot)overTime).fastRetransmissions + ((Scenario.TcpSnapshot)overTime).slowRetransmissions;
                        snapshot.put("D", totalRetransmissions);
                        ++n3;
                    }
                    objectArray = sendingTcpEndpoint.overTimeResults;
                    n4 = sendingTcpEndpoint.overTimeResults.length;
                    n3 = 0;
                    while (n3 < n4) {
                        overTime = objectArray[n3];
                        snapshot = new HashMap();
                        line.add(snapshot);
                        snapshot.put("A", httpFlow.name);
                        snapshot.put("B", "Q");
                        snapshot.put("F", "Q");
                        millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                        snapshot.put("C", millis);
                        snapshot.put("D", ((Scenario.TcpSnapshot)overTime).remoteECNMarkings);
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    static boolean shouldRender(Scenario data) {
        if (data.httpFlows == null || data.httpFlows.length == 0) {
            return false;
        }
        if (data.firstMoment() == null || data.lastMoment() == null) {
            return false;
        }
        Scenario.HttpFlow[] httpFlowArray = data.httpFlows;
        int n = data.httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.HttpFlow httpFlow = httpFlowArray[n2];
            Scenario.HttpEndpoint httpEndpoint = null;
            Scenario.TcpEndpoint tcpEndpoint = null;
            if (httpFlow.clientIsMobile()) {
                httpEndpoint = httpFlow.httpServer;
                tcpEndpoint = httpFlow.tcpServer;
            } else if ("GET".equals(httpFlow.method)) {
                httpEndpoint = httpFlow.httpClient;
                tcpEndpoint = httpFlow.tcpClient;
            } else if ("PUT".equals(httpFlow.method)) {
                httpEndpoint = httpFlow.httpServer;
                tcpEndpoint = httpFlow.tcpServer;
            }
            if (httpEndpoint != null && httpEndpoint.overTimeResults.length > 0 || tcpEndpoint != null && tcpEndpoint.overTimeResults.length > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

