/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class TCPTables {
    public static String generateConfigsV2(Scenario data) {
        if (!TCPTables.shouldRender(data)) {
            return "";
        }
        HashMap<String, Collection<Object>> context = new HashMap<String, Collection<Object>>();
        context.put("tcp_info", TCPTables.fillTcpConfigs(data));
        Jinjava render = Util.get();
        String template = Util.load("html_templates_nov_2023/tcp_config_table.html");
        return render.render(template, context);
    }

    public static String generate(Scenario data) {
        if (!TCPTables.shouldRender(data)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("tcp_info", TCPTables.fillTcpConfigs(data));
        context.put("tcp_results", TCPTables.fillTcpResults(data));
        context.put("tcp_timing_results", TCPTables.fillTcpTimingResults(data));
        Jinjava render = Util.get();
        String template = Util.load("html_templates/tcp_tables.html");
        return render.render(template, context);
    }

    private static Object fillTcpTimingResults(Scenario data) {
        ArrayList result = new ArrayList();
        Scenario.HttpFlow[] httpFlowArray = data.httpFlows;
        int n = data.httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.HttpEndpoint httpDestination;
            Scenario.HttpEndpoint httpSource;
            Scenario.TcpEndpoint tcpSource;
            Scenario.HttpFlow tcpFlow = httpFlowArray[n2];
            HashMap<String, Object> line = new HashMap<String, Object>();
            result.add(line);
            line.put("name", tcpFlow.name);
            if ("PUT".equals(tcpFlow.method)) {
                tcpSource = tcpFlow.tcpClient;
                httpSource = tcpFlow.httpClient;
                httpDestination = tcpFlow.httpServer;
            } else {
                httpDestination = tcpFlow.httpClient;
                tcpSource = tcpFlow.tcpServer;
                httpSource = tcpFlow.httpServer;
            }
            line.put("source", httpSource.portName);
            line.put("destination", httpDestination.portName);
            line.put("status", tcpFlow.state);
            line.put("time_first_byte", tcpFlow.timeToFirstByte == null ? "-" : tcpFlow.timeToFirstByte);
            if (tcpFlow.clientIsMobile()) {
                line.put("minimum_rtt", tcpFlow.tcpServer.rttMinimum);
                line.put("average_rtt", tcpFlow.tcpServer.rttAverage);
                line.put("maximum_rtt", tcpFlow.tcpServer.rttMaximum);
            } else {
                line.put("minimum_rtt", tcpSource.rttMinimum);
                line.put("average_rtt", tcpSource.rttAverage);
                line.put("maximum_rtt", tcpSource.rttMaximum);
            }
            ++n2;
        }
        return result;
    }

    private static Object fillTcpResults(Scenario data) {
        ArrayList result = new ArrayList();
        Scenario.HttpFlow[] httpFlowArray = data.httpFlows;
        int n = data.httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            ZonedDateTime end;
            Scenario.HttpEndpoint httpDestination;
            Scenario.HttpEndpoint httpSource;
            Scenario.HttpFlow tcpFlow = httpFlowArray[n2];
            HashMap<String, Object> line = new HashMap<String, Object>();
            result.add(line);
            line.put("name", tcpFlow.name);
            if ("PUT".equals(tcpFlow.method)) {
                httpSource = tcpFlow.httpClient;
                httpDestination = tcpFlow.httpServer;
            } else {
                httpDestination = tcpFlow.httpClient;
                httpSource = tcpFlow.httpServer;
            }
            line.put("source", httpSource.portName);
            line.put("destination", httpDestination.portName);
            line.put("status", tcpFlow.state);
            line.put("caa", tcpFlow.tcpServer.caa);
            double duration = 0.0;
            long throughputBytes = 0L;
            if (tcpFlow.clientIsMobile()) {
                if ("PUT".equals(tcpFlow.method)) {
                    line.put("tx_payload", "Only RX available");
                    line.put("rx_payload", tcpFlow.httpServer.rxBytes);
                    if (tcpFlow.httpServer.rxFirst != null && tcpFlow.httpServer.rxLast != null) {
                        ZonedDateTime start = tcpFlow.httpServer.rxFirst;
                        end = tcpFlow.httpServer.rxLast;
                        duration = (double)ChronoUnit.NANOS.between(start, end) / 1.0E9;
                    }
                    throughputBytes = tcpFlow.httpServer.rxBytes;
                } else {
                    line.put("tx_payload", tcpFlow.httpServer.txBytes);
                    line.put("rx_payload", "Only TX available");
                    if (tcpFlow.httpServer.txFirst != null && tcpFlow.httpServer.txLast != null) {
                        ZonedDateTime start = tcpFlow.httpServer.txFirst;
                        end = tcpFlow.httpServer.txLast;
                        duration = (double)ChronoUnit.NANOS.between(start, end) / 1.0E9;
                    }
                    throughputBytes = tcpFlow.httpServer.txBytes;
                }
            } else {
                line.put("tx_payload", httpSource.txBytes);
                line.put("rx_payload", httpDestination.rxBytes);
                if (httpDestination.rxFirst != null && httpDestination.rxLast != null) {
                    ZonedDateTime start = httpDestination.rxFirst;
                    end = httpDestination.rxLast;
                    duration = (double)ChronoUnit.NANOS.between(start, end) / 1.0E9;
                }
                throughputBytes = httpDestination.rxBytes;
            }
            line.put("duration", duration);
            double throughput = 0.0;
            if (duration > 0.0) {
                throughput = (double)throughputBytes / duration * 8.0;
            }
            line.put("throughput", throughput);
            ++n2;
        }
        return result;
    }

    private static Collection<Object> fillTcpConfigs(Scenario data) {
        ArrayList<Object> result = new ArrayList<Object>();
        Scenario.HttpFlow[] httpFlowArray = data.httpFlows;
        int n = data.httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.HttpFlow httpFlow = httpFlowArray[n2];
            HashMap<String, Object> line = new HashMap<String, Object>();
            result.add(line);
            Scenario.TcpEndpoint source = "PUT".equals(httpFlow.method) && !httpFlow.clientIsMobile() ? httpFlow.tcpClient : httpFlow.tcpServer;
            line.put("name", httpFlow.name);
            line.put("template_name", httpFlow.flowTemplate);
            line.put("startDelay", httpFlow.startDelay);
            line.put("duration", httpFlow.duration);
            line.put("size", httpFlow.size == 0L ? "Not Set" : Long.valueOf(httpFlow.size));
            line.put("rate_limit", httpFlow.ratelimit == 0L ? "Not Set" : Long.valueOf(httpFlow.ratelimit));
            line.put("http_method", httpFlow.method);
            line.put("initial_receive_window", source.initialReceiveWindow);
            line.put("initial_receive_scale", source.configuredWindowScale);
            line.put("tos", Integer.toString(httpFlow.configuredTos, 16).toUpperCase());
            line.put("l4s", httpFlow.l4sEnabled ? "Yes" : "No");
            ++n2;
        }
        return result;
    }

    static boolean shouldRender(Scenario data) {
        return data.httpFlows != null && data.httpFlows.length > 0;
    }
}

