/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class WifiGraphs {
    public static String generate(ScenarioWithPreferences results) {
        if (!WifiGraphs.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates/wifi_graphs.html");
        context.put("wifi_interval_results", WifiGraphs.wifiStatisticsOvertime(results));
        context.put("max_time", results.getMaxTime());
        return render.render(template, context);
    }

    static boolean shouldRender(Scenario data) {
        return data.wifiStatistics != null && data.wifiStatistics.length > 0 && data.firstMoment() != null && data.lastMoment() != null;
    }

    static Collection<Collection<Map<String, Object>>> wifiStatisticsOvertime(Scenario data) {
        ZonedDateTime startMoment = data.firstMoment();
        ArrayList<Collection<Map<String, Object>>> result = new ArrayList<Collection<Map<String, Object>>>();
        Scenario.WifiStatistic[] wifiStatisticArray = data.wifiStatistics;
        int n = data.wifiStatistics.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.WifiStatistic wifi = wifiStatisticArray[n2];
            String wirelessEndpoint = wifi.wirelessEndpoint;
            String networkInterface = wifi.networkInterface;
            ArrayList intermediate = new ArrayList();
            Scenario.WifiSample[] wifiSampleArray = wifi.overTimeResults;
            int n3 = wifi.overTimeResults.length;
            int n4 = 0;
            while (n4 < n3) {
                Scenario.WifiSample snap = wifiSampleArray[n4];
                HashMap<String, Object> snapMap = new HashMap<String, Object>();
                intermediate.add(snapMap);
                snapMap.put("rssi", snap.rssi);
                snapMap.put("bssid", snap.bssid);
                snapMap.put("ssid", snap.ssid);
                snapMap.put("net_if", networkInterface);
                snapMap.put("port_name", wirelessEndpoint);
                long millis = ChronoUnit.MILLIS.between(startMoment, snap.timestamp);
                snapMap.put("time", millis);
                snapMap.put("name", String.valueOf(wirelessEndpoint) + " - " + networkInterface);
                ++n4;
            }
            if (!intermediate.isEmpty()) {
                result.add(intermediate);
            }
            ++n2;
        }
        return result;
    }
}

