/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator2;

import com.excentis.products.byteblower.report.generator.html2.ReflectiveExpander;
import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class ByteBlowerPorts {
    private static final String UNCLAIMED_GROUP = "";

    public static String generate(Scenario data) {
        HashMap<String, List<Object>> context = new HashMap<String, List<Object>>();
        Jinjava render = Util.get();
        String template = Util.load("html_templates_nov_2023/byteblower_ports.html");
        Map<String, String[]> portGroups = ByteBlowerPorts.allPortsInAGroup(data);
        if (data.ipv4Ports != null) {
            context.put("ipv4_groups", ByteBlowerPorts.calcIPv4Groups(ByteBlowerPorts.allIpv4Ports(data), portGroups));
        }
        if (data.ipv6Ports != null) {
            context.put("ipv6_groups", ByteBlowerPorts.calcIPv6Groups(ByteBlowerPorts.allIpv6Ports(data), portGroups));
        }
        return render.render(template, context);
    }

    private static List<Object> calcIPv6Groups(Map<String, Object> ipv6Ports, Map<String, String[]> portGroups) {
        ReflectiveExpander expander = new ReflectiveExpander();
        ArrayList<Object> ipv6Groups = new ArrayList<Object>();
        for (Map.Entry<String, String[]> agroup : portGroups.entrySet()) {
            String name = agroup.getKey();
            String[] elems = agroup.getValue();
            List<Object> ipv6InGroup = ByteBlowerPorts.selectByKeys(ipv6Ports, elems);
            if (ipv6InGroup.isEmpty()) continue;
            HashMap<String, Object> currentGroup = new HashMap<String, Object>();
            ipv6Groups.add(currentGroup);
            Collection<HashMap<String, Object>> expandedGroup = expander.reflectiveFill(ipv6InGroup);
            ByteBlowerPorts.formatVlans(expandedGroup);
            ByteBlowerPorts.formatIPv6Addresses(expandedGroup);
            if (!name.isEmpty()) {
                currentGroup.put("name", name);
            }
            currentGroup.put("ports", expandedGroup);
        }
        return ipv6Groups;
    }

    private static List<Object> calcIPv4Groups(Map<String, Object> ipv4Ports, Map<String, String[]> portGroups) {
        ReflectiveExpander expander = new ReflectiveExpander();
        ArrayList<Object> ipv4Groups = new ArrayList<Object>();
        for (Map.Entry<String, String[]> agroup : portGroups.entrySet()) {
            String name = agroup.getKey();
            String[] elems = agroup.getValue();
            List<Object> ipv4InGroup = ByteBlowerPorts.selectByKeys(ipv4Ports, elems);
            if (ipv4InGroup.isEmpty()) continue;
            HashMap<String, Object> currentGroup = new HashMap<String, Object>();
            ipv4Groups.add(currentGroup);
            Collection<HashMap<String, Object>> expandedGroup = expander.reflectiveFill(ipv4InGroup);
            ByteBlowerPorts.formatVlans(expandedGroup);
            if (!name.isEmpty()) {
                currentGroup.put("name", name);
            }
            currentGroup.put("ports", expandedGroup);
        }
        return ipv4Groups;
    }

    private static List<Object> selectByKeys(Map<String, Object> mapped, String[] keys) {
        ArrayList<Object> results = new ArrayList<Object>();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String anElem = stringArray[n2];
            Object res = mapped.get(anElem);
            if (res != null) {
                results.add(mapped.get(anElem));
            }
            ++n2;
        }
        return results;
    }

    private static Map<String, Object> allIpv4Ports(Scenario data) {
        HashMap<String, Object> seen = new HashMap<String, Object>();
        if (data.ipv4Ports != null) {
            Scenario.Ipv4Port[] ipv4PortArray = data.ipv4Ports;
            int n = data.ipv4Ports.length;
            int n2 = 0;
            while (n2 < n) {
                Scenario.Ipv4Port p = ipv4PortArray[n2];
                seen.put(p.name, p);
                ++n2;
            }
        }
        return seen;
    }

    private static Map<String, Object> allIpv6Ports(Scenario data) {
        HashMap<String, Object> seen = new HashMap<String, Object>();
        if (data.ipv6Ports != null) {
            Scenario.Ipv6Port[] ipv6PortArray = data.ipv6Ports;
            int n = data.ipv6Ports.length;
            int n2 = 0;
            while (n2 < n) {
                Scenario.Ipv6Port p = ipv6PortArray[n2];
                seen.put(p.name, p);
                ++n2;
            }
        }
        return seen;
    }

    private static Map<String, Object> allPorts(Scenario data) {
        Map<String, Object> collected = ByteBlowerPorts.allIpv4Ports(data);
        collected.putAll(ByteBlowerPorts.allIpv6Ports(data));
        return collected;
    }

    private static Map<String, String[]> allPortsInAGroup(Scenario data) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        if (data.portGroups != null) {
            Map<String, Object> seen = ByteBlowerPorts.allPorts(data);
            Scenario.PortGroup[] portGroupArray = data.portGroups;
            int n = data.portGroups.length;
            int n2 = 0;
            while (n2 < n) {
                Scenario.PortGroup group = portGroupArray[n2];
                result.put(group.name, group.members);
                String[] stringArray = group.members;
                int n3 = group.members.length;
                int n4 = 0;
                while (n4 < n3) {
                    String a = stringArray[n4];
                    seen.remove(a);
                    ++n4;
                }
                ++n2;
            }
            result.put(UNCLAIMED_GROUP, seen.keySet().toArray(new String[0]));
        }
        return result;
    }

    private static void formatVlans(Collection<HashMap<String, Object>> ports) {
        for (HashMap<String, Object> port : ports) {
            String description;
            Object value = port.getOrDefault("vlans", new int[0]);
            int[] vlans = (int[])value;
            int vlanSize = vlans.length;
            if (vlanSize == 0) {
                description = "No";
            } else {
                StringBuilder vlanTxt = new StringBuilder();
                int vlanCounter = 0;
                while (vlanCounter < vlans.length) {
                    int id = vlans[vlanCounter];
                    if (vlanCounter == 0) {
                        vlanTxt.append(id);
                    } else if (1 == vlanCounter) {
                        vlanTxt.append(" (outer), ");
                        vlanTxt.append(id);
                    } else if (vlanSize == vlanCounter + 1) {
                        vlanTxt.append(", ");
                        vlanTxt.append(id);
                        vlanTxt.append(" (inner)");
                    } else {
                        vlanTxt.append(", ");
                        vlanTxt.append(id);
                    }
                    ++vlanCounter;
                }
                description = vlanTxt.toString();
            }
            port.put("vlans", description);
        }
    }

    private static void formatIPv6Addresses(Collection<HashMap<String, Object>> ports) {
        BiFunction<String, Object, String> keepFirstString = (key, vals) -> {
            String[] addrs = (String[])vals;
            if (addrs.length > 0) {
                return addrs[0];
            }
            return null;
        };
        for (HashMap<String, Object> port : ports) {
            int[] ints;
            port.computeIfPresent("ipAddresses", keepFirstString);
            port.computeIfPresent("routers", keepFirstString);
            Object value = port.get("prefixLengths");
            if (value == null || (ints = (int[])value).length <= 0) continue;
            port.put("prefix", ints[0]);
        }
    }
}

