/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator2;

import com.excentis.products.byteblower.report.generator.html2.ReportManagerHtml;
import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.hubspot.jinjava.Jinjava;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Events {
    private static final String TEMPLATE_FILE = "html_templates_nov_2023/info_table.html";
    private static final Logger LOGGER = Logger.getGlobal();
    private static final Set<String> PROBLEMATIC;
    private static final Map<String, String> customerSeverity;

    static {
        HashSet<String> problematic = new HashSet<String>();
        problematic.add("TEST_WARNING");
        problematic.add("TEST_ERROR");
        PROBLEMATIC = problematic;
        customerSeverity = new HashMap<String, String>();
        customerSeverity.put(EventSeverity.TEST_ERROR.toString(), "Error");
        customerSeverity.put(EventSeverity.TEST_SUGGESTION.toString(), "Hint");
        customerSeverity.put(EventSeverity.TEST_INFO.toString(), "Log");
        customerSeverity.put(EventSeverity.TEST_WARNING.toString(), "Warning");
    }

    public static String generate(ScenarioWithPreferences data) {
        List<Scenario.Event> events = Events.relevantEvents(data);
        if (events.isEmpty()) {
            return "";
        }
        Jinjava render = Util.get();
        String template = Util.load(TEMPLATE_FILE);
        HashMap<String, Collection<Map<String, Object>>> context = new HashMap<String, Collection<Map<String, Object>>>();
        context.put("event_table_content", Events.rows(events, Events.collectTestNames(data)));
        return render.render(template, context);
    }

    private static List<Scenario.Event> relevantEvents(Scenario data) {
        if (data.events == null) {
            return Collections.emptyList();
        }
        return data.events.stream().filter(e -> customerSeverity.containsKey(e.severity)).collect(Collectors.toList());
    }

    private static String toCustomerSeverity(String jsonName) {
        return customerSeverity.getOrDefault(jsonName, "");
    }

    private static Collection<Map<String, Object>> rows(List<Scenario.Event> events, Set<String> knownNames) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Scenario.Event event : events) {
            String sourceName;
            HashMap<String, Object> intermediate = new HashMap<String, Object>();
            result.add(intermediate);
            if (knownNames.contains(event.name)) {
                sourceName = event.name;
            } else {
                LOGGER.info("Unknown name for " + event.name + ":" + event.description);
                sourceName = "";
            }
            intermediate.put("type", Events.toCustomerSeverity(event.severity));
            intermediate.put("source_name", sourceName);
            intermediate.put("timestamp", ReportManagerHtml.localTime(event.time));
            intermediate.put("description", event.description);
            intermediate.put("knowledgeBaseLink", event.knowledgeBaseLink);
        }
        return result;
    }

    private static Set<String> collectTestNames(Scenario data) {
        Object flow;
        Object port;
        HashSet<String> knownNames = new HashSet<String>();
        Object[] objectArray = data.ipv4Ports;
        int n = data.ipv4Ports.length;
        int n2 = 0;
        while (n2 < n) {
            port = objectArray[n2];
            knownNames.add(((Scenario.Ipv4Port)port).name);
            ++n2;
        }
        objectArray = data.ipv6Ports;
        n = data.ipv6Ports.length;
        n2 = 0;
        while (n2 < n) {
            port = objectArray[n2];
            knownNames.add(((Scenario.Ipv6Port)port).name);
            ++n2;
        }
        objectArray = data.frameBlastingFlows;
        n = data.frameBlastingFlows.length;
        n2 = 0;
        while (n2 < n) {
            flow = objectArray[n2];
            knownNames.add(((Scenario.FrameBlastingFlow)flow).config.name);
            ++n2;
        }
        objectArray = data.httpFlows;
        n = data.httpFlows.length;
        n2 = 0;
        while (n2 < n) {
            flow = objectArray[n2];
            knownNames.add(((Scenario.HttpFlow)flow).name);
            ++n2;
        }
        return knownNames;
    }

    protected static boolean hasWarning(Scenario data, String flowName) {
        if (data.events == null) {
            return false;
        }
        for (Scenario.Event evt : data.events) {
            boolean hasProblem;
            boolean bl = hasProblem = flowName.equals(evt.name) && PROBLEMATIC.contains(evt.severity);
            if (!hasProblem) continue;
            return hasProblem;
        }
        return false;
    }
}

