/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator2;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.excentis.products.byteblower.report.generator.html2.generator2.Events;
import com.excentis.products.byteblower.report.generator.html2.generator2.Rfc2544Analysis;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FrameBlastingCollapsableTables {
    private static final String TEMPLATE_FILE = "html_templates_nov_2023/frameblasting_analysis.html";

    public static String generate(ScenarioWithPreferences results) {
        if (!FrameBlastingCollapsableTables.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("has_latency", FrameBlastingCollapsableTables.hasLatency(results));
        context.put("has_throughput", FrameBlastingCollapsableTables.hasThroughput(results));
        context.put("fb_results", FrameBlastingCollapsableTables.tabularThroughputContents(results));
        context.put("ccdf_results", FrameBlastingCollapsableTables.ccdfValues(FrameBlastingCollapsableTables.gatherLatencyDistFlows(results)));
        context.put("rfc2544_results", Rfc2544Analysis.generate(results));
        Jinjava render = Util.get();
        String template = Util.load(TEMPLATE_FILE);
        return render.render(template, context);
    }

    private static Collection<Map<String, Object>> tabularThroughputContents(ScenarioWithPreferences data) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            Scenario.FrameBlastingSource source = fb.source;
            if (fb.destinations == null || fb.destinations.length == 0) {
                HashMap<String, Object> intermediate = new HashMap<String, Object>();
                result.add(intermediate);
                intermediate.put("name", fb.config.name);
                intermediate.put("flow_warning", Events.hasWarning(data, fb.config.name));
                FrameBlastingCollapsableTables.fillSourceInfo(data, fb, source, intermediate);
            } else {
                Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = fb.destinations;
                int n3 = fb.destinations.length;
                int n4 = 0;
                while (n4 < n3) {
                    Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                    HashMap<String, Object> intermediate = new HashMap<String, Object>();
                    result.add(intermediate);
                    intermediate.put("name", fb.config.name);
                    intermediate.put("flow_warning", Events.hasWarning(data, fb.config.name));
                    FrameBlastingCollapsableTables.fillSourceInfo(data, fb, source, intermediate);
                    FrameBlastingCollapsableTables.fillDestinationInfo(data, fb, dest, intermediate);
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    private static void fillDestinationInfo(ScenarioWithPreferences data, Scenario.FrameBlastingFlow fb, Scenario.FrameBlastingDestination dest, Map<String, Object> intermediate) {
        double duration;
        boolean nothingReceived;
        long txPackets;
        long txBytesWithoutVlan;
        long rxPackets;
        long rxBytesWithoutVlan;
        Scenario.FrameBlastingSource source = fb.source;
        intermediate.put("row_has_destination", true);
        intermediate.put("destination", dest.name);
        intermediate.put("overtime", FrameBlastingCollapsableTables.fbOvertimeThroughput(data, fb, dest));
        long rxVlans = FrameBlastingCollapsableTables.getNofVlans(data, dest.name);
        long txVlans = FrameBlastingCollapsableTables.getNofVlans(data, source.name);
        if (dest.received == null) {
            rxBytesWithoutVlan = 0L;
            long rxVlanBytes = 0L;
            rxPackets = 0L;
        } else {
            rxPackets = dest.received.packets;
            long rxVlanBytes = rxPackets * 4L * rxVlans;
            rxBytesWithoutVlan = dest.received.bytes - rxVlanBytes;
        }
        long rxBytes = dest.received == null ? 0L : dest.received.bytes + dest.received.packets * (long)data.initialThroughputFrameOverhead;
        intermediate.put("rx_bytes", rxBytes);
        intermediate.put("has_rx_vlans", rxVlans > 0L);
        intermediate.put("rx_vlans", rxVlans);
        intermediate.put("rx_frames", rxPackets);
        if (source.sent == null) {
            txBytesWithoutVlan = 0L;
            txPackets = 0L;
        } else {
            txPackets = source.sent.packets;
            txBytesWithoutVlan = source.sent.bytes - source.sent.packets * txVlans * 4L;
        }
        Object byteLoss = txBytesWithoutVlan > 0L ? Double.valueOf(100.0 * (double)(txBytesWithoutVlan - rxBytesWithoutVlan) / (double)txBytesWithoutVlan) : "N/A";
        intermediate.put("byte_loss", byteLoss);
        Object frameLoss = txPackets > 0L ? Double.valueOf(100.0 * (double)(txPackets - rxPackets) / (double)txPackets) : "N/A";
        intermediate.put("frame_loss", frameLoss);
        boolean bl = nothingReceived = dest.received == null || dest.received.firstPacketTime == null || dest.received.lastPacketTime == null;
        if (nothingReceived) {
            duration = Double.NaN;
        } else {
            long durationNs = ChronoUnit.NANOS.between(dest.received.firstPacketTime, dest.received.lastPacketTime);
            duration = (double)durationNs / 1.0E9;
        }
        intermediate.put("duration", duration);
        if (0L == rxBytes) {
            intermediate.put("throughput", 0);
        } else if (duration != Double.NaN && duration > 0.0) {
            double throughput = 8.0 * (double)(rxBytes + rxPackets * (long)data.initialThroughputFrameOverhead) / duration;
            intermediate.put("throughput", throughput);
        }
        if (dest.outOfSequence != null) {
            intermediate.put("outOfSequence", dest.outOfSequence.packetsOutOfSequence);
        } else {
            intermediate.put("outOfSequence", -1);
        }
        FrameBlastingCollapsableTables.fillOverallLatencyValues(fb, dest, intermediate);
    }

    private static void fillOverallLatencyValues(Scenario.FrameBlastingFlow fb, Scenario.FrameBlastingDestination dest, Map<String, Object> intermediate) {
        if (dest.latency == null) {
            return;
        }
        intermediate.put("row_has_latency", true);
        Scenario.FrameblastingLatencyResult latency = dest.latency;
        intermediate.put("min_latency", dest.received.packets == 0L ? null : Long.valueOf(latency.minimum));
        intermediate.put("avg_latency", dest.received.packets == 0L ? null : Long.valueOf(latency.average));
        intermediate.put("max_latency", dest.received.packets == 0L ? null : Long.valueOf(latency.maximum));
        intermediate.put("jitter", dest.received.packets == 0L ? null : Long.valueOf(latency.jitter));
        if (latency.distribution != null) {
            intermediate.put("dist", FrameBlastingCollapsableTables.distributionValues(fb, dest));
        }
    }

    private static void fillSourceInfo(ScenarioWithPreferences data, Scenario.FrameBlastingFlow fb, Scenario.FrameBlastingSource source, Map<String, Object> targetRow) {
        targetRow.put("source", source.name);
        long txVlans = FrameBlastingCollapsableTables.getNofVlans(data, source.name);
        targetRow.put("has_tx_vlans", txVlans > 0L);
        long txBytes = source.sent == null ? 0L : source.sent.bytes + source.sent.packets * (long)data.initialThroughputFrameOverhead;
        targetRow.put("tx_bytes", txBytes);
        targetRow.put("tx_vlans", txVlans);
        long txPackets = source.sent == null ? 0L : source.sent.packets;
        targetRow.put("tx_frames", txPackets);
    }

    private static long getNofVlans(Scenario data, String portName) {
        Object port;
        Object[] objectArray = data.ipv4Ports;
        int n = data.ipv4Ports.length;
        int n2 = 0;
        while (n2 < n) {
            port = objectArray[n2];
            if (((Scenario.Ipv4Port)port).name.equals(portName)) {
                return ((Scenario.Ipv4Port)port).vlans.length;
            }
            ++n2;
        }
        objectArray = data.ipv6Ports;
        n = data.ipv6Ports.length;
        n2 = 0;
        while (n2 < n) {
            port = objectArray[n2];
            if (((Scenario.Ipv6Port)port).name.equals(portName)) {
                return ((Scenario.Ipv6Port)port).vlans.length;
            }
            ++n2;
        }
        return 0L;
    }

    private static boolean shouldRender(ScenarioWithPreferences data) {
        return data.frameBlastingFlows != null && data.frameBlastingFlows.length > 0 || data.rfc2544Flows != null && data.rfc2544Flows.length > 0;
    }

    private static boolean hasLatency(ScenarioWithPreferences data) {
        if (data.frameBlastingFlows == null) {
            return false;
        }
        boolean hasLatency = false;
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            if (fb.destinations != null) {
                Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = fb.destinations;
                int n3 = fb.destinations.length;
                int n4 = 0;
                while (n4 < n3) {
                    Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                    hasLatency = hasLatency || dest.latency != null;
                    ++n4;
                }
            }
            ++n2;
        }
        return hasLatency;
    }

    private static boolean hasThroughput(ScenarioWithPreferences data) {
        if (data.frameBlastingFlows == null) {
            return false;
        }
        boolean hasThroughput = false;
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            if (fb.destinations != null) {
                Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = fb.destinations;
                int n3 = fb.destinations.length;
                int n4 = 0;
                while (n4 < n3) {
                    Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                    hasThroughput = hasThroughput || dest.received != null;
                    ++n4;
                }
            }
            ++n2;
        }
        return hasThroughput;
    }

    static Object fbOvertimeThroughput(ScenarioWithPreferences data, Scenario.FrameBlastingFlow fb, Scenario.FrameBlastingDestination dest) {
        ZonedDateTime startMoment = data.firstMoment();
        Scenario.FrameBlastingSource source = fb.source;
        ArrayList intermediate = new ArrayList();
        String chartFmt = "%s: %s -> %s";
        String chartname = String.format(chartFmt, fb.config.name, source.name, dest.name);
        Scenario.FrameblastingTrafficResult received = dest.received;
        if (received != null) {
            Scenario.FBTrafficSnapshot[] fBTrafficSnapshotArray = received.overTimeResults;
            int n = received.overTimeResults.length;
            int n2 = 0;
            while (n2 < n) {
                Scenario.FBTrafficSnapshot snap = fBTrafficSnapshotArray[n2];
                HashMap<String, Object> htmlSnap = new HashMap<String, Object>();
                intermediate.add(htmlSnap);
                htmlSnap.put("A", fb.config.name);
                long millis = ChronoUnit.MILLIS.between(startMoment, snap.timestamp);
                htmlSnap.put("B", millis);
                htmlSnap.put("H", chartname);
                htmlSnap.put("M", (double)(8L * (snap.bytes + (long)data.initialThroughputFrameOverhead * snap.packets)) * 1.0E9 / (double)snap.duration);
                ++n2;
            }
        }
        if (dest.latency != null) {
            Scenario.FBLatencySnapshot[] latOverTime = dest.latency.overTimeResults;
            int latLength = latOverTime.length;
            int sampleLength = intermediate.size();
            int ctr = 0;
            while (ctr < Math.min(latLength, sampleLength)) {
                Map sample = (Map)intermediate.get(ctr);
                boolean showLatency = false;
                Object rx = sample.get("M");
                if (rx instanceof Double) {
                    Double rxBytes = (Double)rx;
                    showLatency = rxBytes > 0.0;
                }
                Scenario.FBLatencySnapshot lat = latOverTime[ctr];
                sample.put("C", showLatency ? Long.valueOf(lat.average) : null);
                sample.put("D", showLatency ? Long.valueOf(lat.minimum) : null);
                sample.put("E", showLatency ? Long.valueOf(lat.maximum) : null);
                sample.put("F", showLatency ? Long.valueOf(lat.average + lat.jitter) : null);
                sample.put("G", showLatency ? Long.valueOf(lat.average - lat.jitter) : null);
                ++ctr;
            }
        }
        if (dest.outOfSequence != null) {
            Scenario.FrameblastingOosSnapshot[] oosOverTime = dest.outOfSequence.overTimeResults;
            int ctr = 0;
            while (ctr < Math.min(oosOverTime.length, intermediate.size())) {
                Map sample = (Map)intermediate.get(ctr);
                Scenario.FrameblastingOosSnapshot oos = oosOverTime[ctr];
                sample.put("N", oos.packetsOutOfSequence);
                ++ctr;
            }
        }
        return intermediate;
    }

    private static Collection<Map<String, Object>> distributionValues(Scenario.FrameBlastingFlow flow, Scenario.FrameBlastingDestination dest) {
        Scenario.DistributionSnapshot[] distribution = dest.latency.distribution;
        if (distribution.length == 0) {
            return Collections.emptyList();
        }
        Arrays.sort(distribution, (a, b) -> Long.compare(a.start, b.start));
        ArrayList<Map<String, Object>> currentResult = new ArrayList<Map<String, Object>>();
        Scenario.DistributionSnapshot[] distributionSnapshotArray = distribution;
        int n = distribution.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.DistributionSnapshot bin = distributionSnapshotArray[n2];
            HashMap<String, Object> currentSample = new HashMap<String, Object>();
            currentResult.add(currentSample);
            currentSample.put("A", bin.start);
            currentSample.put("B", Float.valueOf(bin.packets));
            currentSample.put("C", flow.config.name);
            currentSample.put("E", dest.name);
            ++n2;
        }
        HashMap<String, Object> belowRange = new HashMap<String, Object>();
        currentResult.add(belowRange);
        belowRange.put("A", 0);
        belowRange.put("B", dest.latency.packetsBelowRange);
        belowRange.put("C", flow.config.name);
        belowRange.put("E", dest.name);
        HashMap<String, Object> aboveRange = new HashMap<String, Object>();
        currentResult.add(aboveRange);
        aboveRange.put("A", 0);
        aboveRange.put("B", dest.latency.packetsAboveRange);
        aboveRange.put("C", flow.config.name);
        aboveRange.put("E", dest.name);
        return currentResult;
    }

    private static List<Scenario.FrameBlastingFlow> gatherLatencyDistFlows(Scenario data) {
        ArrayList<Scenario.FrameBlastingFlow> flowsToRender = new ArrayList<Scenario.FrameBlastingFlow>();
        if (data.frameBlastingFlows == null) {
            return flowsToRender;
        }
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow fb = frameBlastingFlowArray[n2];
            if (fb.destinations != null) {
                Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = fb.destinations;
                int n3 = fb.destinations.length;
                int n4 = 0;
                while (n4 < n3) {
                    boolean hasDistribution;
                    Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                    boolean bl = hasDistribution = dest.latency != null && dest.latency.distribution != null;
                    if (hasDistribution && dest.latency.distribution.length > 0) {
                        flowsToRender.add(fb);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return flowsToRender;
    }

    private static Collection<Collection<Map<String, Object>>> ccdfValues(List<Scenario.FrameBlastingFlow> toRender) {
        ArrayList<Collection<Map<String, Object>>> result = new ArrayList<Collection<Map<String, Object>>>();
        for (Scenario.FrameBlastingFlow flow : toRender) {
            Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = flow.destinations;
            int n = flow.destinations.length;
            int n2 = 0;
            while (n2 < n) {
                Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n2];
                Scenario.DistributionSnapshot[] distribution = dest.latency.distribution;
                Arrays.sort(distribution, (a, b) -> Long.compare(a.start, b.start));
                ArrayList<Scenario.DistributionSnapshot> list = new ArrayList<Scenario.DistributionSnapshot>(Arrays.asList(distribution));
                if (!list.isEmpty()) {
                    do {
                        Scenario.DistributionSnapshot first = (Scenario.DistributionSnapshot)list.get(0);
                        if (first.packets != 0L) break;
                        list.remove(0);
                    } while (list.size() > 0);
                }
                int lastIndex = -1;
                while (list.size() != 0) {
                    lastIndex = list.size() - 1;
                    Scenario.DistributionSnapshot last = (Scenario.DistributionSnapshot)list.get(lastIndex);
                    if (last.packets != 0L) break;
                    list.remove(lastIndex);
                    if (lastIndex >= 0) continue;
                }
                ArrayList currentResult = new ArrayList();
                result.add(currentResult);
                HashMap<String, Object> currentSample = new HashMap<String, Object>();
                currentResult.add(currentSample);
                currentSample.put("A", 0);
                currentSample.put("B", Float.valueOf(dest.latency.packetsBelowRange));
                currentSample.put("C", flow.config.name);
                currentSample.put("E", dest.name);
                long totalPacketsInBins = 0L;
                for (Scenario.DistributionSnapshot bin : list) {
                    HashMap<String, Object> currentSample2 = new HashMap<String, Object>();
                    currentResult.add(currentSample2);
                    currentSample2.put("A", bin.start);
                    currentSample2.put("B", Float.valueOf(bin.packets));
                    currentSample2.put("C", flow.config.name);
                    currentSample2.put("E", dest.name);
                    totalPacketsInBins += bin.packets;
                }
                HashMap<String, Object> currentSample3 = new HashMap<String, Object>();
                currentResult.add(currentSample3);
                currentSample3.put("A", 0);
                currentSample3.put("B", Float.valueOf(totalPacketsInBins));
                currentSample3.put("C", flow.config.name);
                currentSample3.put("E", dest.name);
                currentSample3 = new HashMap();
                currentResult.add(currentSample3);
                currentSample3.put("A", 0);
                currentSample3.put("B", Float.valueOf(dest.latency.packetsAboveRange));
                currentSample3.put("C", flow.config.name);
                currentSample3.put("E", dest.name);
                currentSample3 = new HashMap();
                currentResult.add(currentSample3);
                currentSample3.put("A", 0);
                currentSample3.put("B", Float.valueOf(dest.received.packets));
                currentSample3.put("C", flow.config.name);
                currentSample3.put("E", dest.name);
                ++n2;
            }
        }
        return result;
    }
}

