/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator2;

import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputType;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.util.HashMap;

public class GeneralScenarioConfig {
    private static final String TEMPLATE_FILE = "html_templates_nov_2023/general_scenario_config.html";
    private static final String FRAME_AND_ALL_OTHER_FIELDS_INFO = "<li>Frame (as displayed in the Frame View)</li><li>FCS\t(CRC Frame Checksum, 4 bytes)</li><li>Preamble\t(7 bytes)</li><li>SFD\t(Start Frame Delimiter, 1 byte)</li><li>Pause (12 bytes)</li>This way, each Frame gets 24 bytes extra.";
    private static final String FRAME_AND_FCS_INFO = "<li>Frame (as displayed in the Frame View)</li><li>FCS\t(CRC Frame Checksum, 4 bytes)</li>This way, each Frame gets 4 bytes extra.";
    private static final String FRAME_ONLY_INFO = "<li>Frame (as displayed in the Frame View)</li>This way, each Frame gets 0 bytes extra.";

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$report$generator$core$parameters$ThroughputType = GeneralScenarioConfig.$SWITCH_TABLE$com$excentis$products$byteblower$report$generator$core$parameters$ThroughputType();
    }

    public static String generate(ScenarioWithPreferences results, ThroughputType type) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("throughput_legend", GeneralScenarioConfig.getThroughputLegend(type));
        context.put("error_loss_pct", 100.0 * results.getErrorLossLevel());
        context.put("warning_loss_pct", 100.0 * results.getWarningLossLevel());
        context.put("throughput_legend_table", GeneralScenarioConfig.getThroughputLegend(type));
        Jinjava render = Util.get();
        String template = Util.load(TEMPLATE_FILE);
        return render.render(template, context);
    }

    private static String getThroughputLegend(ThroughputType type) {
        StringBuilder infoHtml = new StringBuilder("The Frame Blasting Layer 2 Speed includes:<br><br>");
        switch (type) {
            case FRAME_AND_ALL_OTHER_FIELDS: {
                infoHtml.append(FRAME_AND_ALL_OTHER_FIELDS_INFO);
                break;
            }
            case FRAME_AND_FCS: {
                infoHtml.append(FRAME_AND_FCS_INFO);
                break;
            }
            case FRAME_ONLY: {
                infoHtml.append(FRAME_ONLY_INFO);
                break;
            }
        }
        return infoHtml.toString();
    }
}

