/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator2;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class PassFailStatement {
    private static final String TEMPLATE_FILE = "html_templates_nov_2023/pass_fail.html";

    public static String generate(ScenarioWithPreferences data) {
        TreeSet<String> failElements = new TreeSet<String>();
        failElements.addAll(PassFailStatement.fbFailDueLoss(data));
        failElements.addAll(PassFailStatement.tcpFailDueState(data));
        failElements.addAll(PassFailStatement.failDueError(data));
        Jinjava render = Util.get();
        String template = Util.load(TEMPLATE_FILE);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("passed", failElements.isEmpty());
        context.put("failList", String.join((CharSequence)", ", failElements));
        return render.render(template, context);
    }

    private static Set<String> knownElements(Scenario data) {
        Object port;
        Object flow;
        HashSet<String> known = new HashSet<String>();
        Object[] objectArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            flow = objectArray[n2];
            known.add(((Scenario.FrameBlastingFlow)flow).config.name);
            ++n2;
        }
        objectArray = data.httpFlows;
        n = data.httpFlows.length;
        n2 = 0;
        while (n2 < n) {
            flow = objectArray[n2];
            known.add(((Scenario.HttpFlow)flow).name);
            ++n2;
        }
        objectArray = data.ipv4Ports;
        n = data.ipv4Ports.length;
        n2 = 0;
        while (n2 < n) {
            port = objectArray[n2];
            known.add(((Scenario.Ipv4Port)port).name);
            ++n2;
        }
        objectArray = data.ipv6Ports;
        n = data.ipv6Ports.length;
        n2 = 0;
        while (n2 < n) {
            port = objectArray[n2];
            known.add(((Scenario.Ipv6Port)port).name);
            ++n2;
        }
        return known;
    }

    private static Collection<String> failDueError(ScenarioWithPreferences data) {
        if (data.events == null) {
            return Collections.emptyList();
        }
        HashSet<String> failFlows = new HashSet<String>();
        Set<String> knownNames = PassFailStatement.knownElements(data);
        for (Scenario.Event event : data.events) {
            if (!event.severity.contains("ERROR") || !knownNames.contains(event.name)) continue;
            failFlows.add(event.name);
        }
        return failFlows;
    }

    private static Collection<String> tcpFailDueState(ScenarioWithPreferences data) {
        TreeSet<String> failFlows = new TreeSet<String>();
        Scenario.HttpFlow[] httpFlowArray = data.httpFlows;
        int n = data.httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.HttpFlow flow = httpFlowArray[n2];
            if (!"FINISHED".equals(flow.state)) {
                String fail = String.format("%s [TCP status %s]", flow.name, flow.state);
                failFlows.add(fail);
            }
            ++n2;
        }
        return failFlows;
    }

    private static Collection<String> fbFailDueLoss(ScenarioWithPreferences data) {
        double maxLossRate = data.getErrorLossLevel();
        TreeSet<String> failFlows = new TreeSet<String>();
        Scenario.FrameBlastingFlow[] frameBlastingFlowArray = data.frameBlastingFlows;
        int n = data.frameBlastingFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.FrameBlastingFlow flow = frameBlastingFlowArray[n2];
            if (flow.source.sent != null) {
                long pckSent = flow.source.sent.packets;
                long byteSent = flow.source.sent.bytes - 4L * PassFailStatement.getNofVlans(data, flow.source.name);
                if (pckSent != 0L && byteSent != 0L) {
                    Scenario.FrameBlastingDestination[] frameBlastingDestinationArray = flow.destinations;
                    int n3 = flow.destinations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Scenario.FrameBlastingDestination dest = frameBlastingDestinationArray[n4];
                        if (dest.received != null) {
                            boolean duplicatedTraffic;
                            boolean tooMuchLoss;
                            long byteReceived = dest.received.bytes - 4L * PassFailStatement.getNofVlans(data, dest.name);
                            long pckReceived = dest.received.packets;
                            double byteLoss = (double)(byteSent - byteReceived) / (double)byteSent;
                            double pckLoss = (double)(pckSent - pckReceived) / (double)pckSent;
                            boolean bl = tooMuchLoss = byteLoss >= maxLossRate || pckLoss >= maxLossRate;
                            if (tooMuchLoss) {
                                String fail = String.format("%s [%.2f %% loss]", flow.config.name, 100.0 * Math.max(byteLoss, pckLoss));
                                failFlows.add(fail);
                            }
                            boolean bl2 = duplicatedTraffic = byteLoss < 0.0 || pckLoss < 0.0;
                            if (duplicatedTraffic) {
                                String fail = String.format("%s [%.2f %% loss]", flow.config.name, 100.0 * Math.min(byteLoss, pckLoss));
                                failFlows.add(fail);
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return failFlows;
    }

    private static long getNofVlans(Scenario data, String portName) {
        Object port;
        Object[] objectArray = data.ipv4Ports;
        int n = data.ipv4Ports.length;
        int n2 = 0;
        while (n2 < n) {
            port = objectArray[n2];
            if (((Scenario.Ipv4Port)port).name.equals(portName)) {
                return ((Scenario.Ipv4Port)port).vlans.length;
            }
            ++n2;
        }
        objectArray = data.ipv6Ports;
        n = data.ipv6Ports.length;
        n2 = 0;
        while (n2 < n) {
            port = objectArray[n2];
            if (((Scenario.Ipv6Port)port).name.equals(portName)) {
                return ((Scenario.Ipv6Port)port).vlans.length;
            }
            ++n2;
        }
        return 0L;
    }
}

