/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator2;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Rfc2544Analysis {
    public static String generate(ScenarioWithPreferences results) {
        if (!Rfc2544Analysis.shouldRender(results)) {
            return "";
        }
        Jinjava render = Util.get();
        String template = Util.load("html_templates_nov_2023/rfc2544_analysis.html");
        HashMap<String, List<Object>> context = new HashMap<String, List<Object>>();
        context.put("rfc2544_result", Rfc2544Analysis.lines(results));
        return render.render(template, context);
    }

    static List<Object> lines(ScenarioWithPreferences results) {
        ArrayList<Object> lines = new ArrayList<Object>();
        Scenario.Rfc2544Flow[] rfc2544FlowArray = results.rfc2544Flows;
        int n = results.rfc2544Flows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.Rfc2544Flow measurement = rfc2544FlowArray[n2];
            HashMap<String, Object> aLine = new HashMap<String, Object>();
            lines.add(aLine);
            aLine.put("source", measurement.source);
            aLine.put("destination", measurement.destination);
            aLine.put("packet_size", measurement.packetSize);
            double normalRate = (double)(measurement.packetSize + (long)results.initialThroughputFrameOverhead) * measurement.receivedFrameRate;
            double layer1ByteRate = measurement.receivedByteRate;
            aLine.put("received_bitrate", normalRate * 8.0);
            aLine.put("receivedL1BitRate", layer1ByteRate * 8.0);
            aLine.put("receivedFrameRate", measurement.receivedFrameRate);
            ++n2;
        }
        return lines;
    }

    static boolean shouldRender(Scenario data) {
        return data.rfc2544Flows != null && data.rfc2544Flows.length > 0;
    }
}

