/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator2;

import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class ScenarioInfo {
    private static final String TEMPLATE_FILE = "html_templates_nov_2023/scenario_info.html";

    public static String generate(ScenarioWithPreferences results) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("project_name", results.projectName);
        context.put("project_author", results.projectAuthor);
        context.put("scenario_name", results.scenarioName);
        context.put("scenario_state", results.scenarioState);
        context.put("scenario_version", ScenarioInfo.currentGuiVersion());
        if (results.startMoment != null) {
            context.put("scenario_start", ScenarioInfo.localTime(results.startMoment));
        }
        if (results.endMoment != null) {
            context.put("scenario_end", ScenarioInfo.localTime(results.endMoment));
        }
        Jinjava render = Util.get();
        String template = Util.load(TEMPLATE_FILE);
        return render.render(template, context);
    }

    private static String currentGuiVersion() {
        Version version = FrameworkUtil.getBundle(ScenarioInfo.class).getVersion();
        return version.toString();
    }

    private static LocalDateTime localTime(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        ZoneId currentZone = ZoneId.systemDefault();
        ZonedDateTime localTime = dateTime.withZoneSameInstant(currentZone);
        return localTime.toLocalDateTime();
    }
}

