/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator2;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class TCPEmbeddedAggregate {
    private static final String TEMPLATE_FILE = "html_templates_nov_2023/tcp_aggregate_analysis.html";
    private static final Logger LOGGER = Logger.getGlobal();

    public static String generate(ScenarioWithPreferences results) {
        if (!TCPEmbeddedAggregate.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("max_time", results.getMaxTime());
        context.put("tcp_aggregate_results", TCPEmbeddedAggregate.fillAggregateTcpResults(results));
        context.put("initial_throughput_unit", results.initialThroughputUnit);
        Jinjava render = Util.get();
        String template = Util.load(TEMPLATE_FILE);
        return render.render(template, context);
    }

    private static Collection<Object> fillAggregateTcpResults(ScenarioWithPreferences results) {
        ArrayList<Object> allAggregated = new ArrayList<Object>();
        allAggregated.addAll(TCPEmbeddedAggregate.fillAggregateTcpResults(results, TcpAggregation.Direction.RX));
        allAggregated.addAll(TCPEmbeddedAggregate.fillAggregateTcpResults(results, TcpAggregation.Direction.TX));
        return allAggregated;
    }

    private static Collection<Object> fillAggregateTcpResults(ScenarioWithPreferences data, TcpAggregation.Direction dir) {
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<String, TcpAggregation> aggregationMap = new HashMap<String, TcpAggregation>();
        Scenario.HttpFlow[] httpFlowArray = data.httpFlows;
        int n = data.httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.HttpFlow httpFlow = httpFlowArray[n2];
            Scenario.HttpEndpoint session = dir.getRelevantSession(httpFlow);
            TcpAggregation aggregation = (TcpAggregation)aggregationMap.get(session.portName);
            if (aggregation == null) {
                aggregation = new TcpAggregation(session.portName, data);
                aggregationMap.put(session.portName, aggregation);
            }
            aggregation.add(session);
            ++n2;
        }
        for (TcpAggregation tcpAggregation : aggregationMap.values()) {
            if (!tcpAggregation.valid()) continue;
            result.add(dir.getBean(tcpAggregation));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean shouldRender(Scenario data) {
        if (data.httpFlows == null || data.httpFlows.length == 0) {
            return false;
        }
        var4_1 = data.httpFlows;
        var3_2 = data.httpFlows.length;
        var2_3 = 0;
        while (var2_3 < var3_2) {
            block9: {
                httpFlow = var4_1[var2_3];
                receivingHttp = null;
                receivingTcp = null;
                sendingTcp = null;
                if (!"GET".equals(httpFlow.method)) break block9;
                sendingTcp = httpFlow.tcpServer;
                ** GOTO lbl21
            }
            if (!"PUT".equals(httpFlow.method)) {
                msg = String.format("Unknown HTTP Method: '%s'", new Object[]{httpFlow.method});
                TCPEmbeddedAggregate.LOGGER.warning(msg);
            } else {
                receivingHttp = httpFlow.httpServer;
                receivingTcp = httpFlow.tcpServer;
lbl21:
                // 2 sources

                if (!httpFlow.clientIsMobile()) {
                    if ("GET".equals(httpFlow.method)) {
                        receivingHttp = httpFlow.httpClient;
                        receivingTcp = httpFlow.tcpClient;
                    } else if ("PUT".equals(httpFlow.method)) {
                        sendingTcp = httpFlow.tcpClient;
                    }
                }
                if (receivingHttp != null && receivingHttp.overTimeResults.length > 0 || receivingTcp != null && receivingTcp.overTimeResults.length > 0 || sendingTcp != null && sendingTcp.overTimeResults.length > 0) {
                    return true;
                }
            }
            ++var2_3;
        }
        return false;
    }

    private static class TcpAggregation {
        private final List<Scenario.HttpEndpoint> httpSessions = new ArrayList<Scenario.HttpEndpoint>();
        private final String portName;
        private final ScenarioWithPreferences report;
        private final HashMap<String, List<Scenario.TcpEndpoint>> portsToSum;
        private boolean hasSessions;

        public TcpAggregation(String portName, ScenarioWithPreferences report) {
            this.portName = portName;
            this.hasSessions = false;
            this.report = report;
            this.portsToSum = TcpAggregation.byteblowerPortsInUse(report);
        }

        private static HashMap<String, List<Scenario.TcpEndpoint>> byteblowerPortsInUse(ScenarioWithPreferences results) {
            ArrayList<String> flowNames = new ArrayList<String>();
            Scenario.HttpFlow[] httpFlows = results.httpFlows;
            HashMap<String, List<Scenario.TcpEndpoint>> portsToSum = new HashMap<String, List<Scenario.TcpEndpoint>>();
            Scenario.HttpFlow[] httpFlowArray = httpFlows;
            int n = httpFlows.length;
            int n2 = 0;
            while (n2 < n) {
                Scenario.TcpEndpoint serverSession;
                List<Scenario.TcpEndpoint> sessions;
                Scenario.HttpFlow httpFlow = httpFlowArray[n2];
                String flowName = httpFlow.name;
                String method = httpFlow.method;
                String acksPostfix = "(ACKS)";
                Scenario.TcpEndpoint clientSession = httpFlow.tcpClient;
                if (clientSession != null) {
                    String post = "PUT".equals(method) ? acksPostfix : "";
                    flowNames.add(String.valueOf(flowName) + post);
                    String clientPort = clientSession.portName;
                    sessions = portsToSum.get(clientPort);
                    if (sessions == null) {
                        sessions = new ArrayList<Scenario.TcpEndpoint>();
                        portsToSum.put(clientPort, sessions);
                    }
                    sessions.add(clientSession);
                }
                if ((serverSession = httpFlow.tcpServer) != null) {
                    String post = "GET".equals(method) ? acksPostfix : "";
                    flowNames.add(String.valueOf(flowName) + post);
                    String serverPort = serverSession.portName;
                    sessions = portsToSum.get(serverPort);
                    if (sessions == null) {
                        sessions = new ArrayList<Scenario.TcpEndpoint>();
                        portsToSum.put(serverPort, sessions);
                    }
                    sessions.add(serverSession);
                }
                ++n2;
            }
            return portsToSum;
        }

        public void add(Scenario.HttpEndpoint httpSession) {
            if (httpSession != null && httpSession.rxFirst != null) {
                this.httpSessions.add(httpSession);
                this.hasSessions = true;
            }
        }

        public boolean valid() {
            return this.hasSessions;
        }

        private long timeDifference(ZonedDateTime d1, ZonedDateTime d2, ChronoUnit unit) {
            return unit.between(d1, d2);
        }

        protected Object createRxBean() {
            Collections.sort(this.httpSessions, new Comparator<Scenario.HttpEndpoint>(){

                @Override
                public int compare(Scenario.HttpEndpoint lhs, Scenario.HttpEndpoint rhs) {
                    ZonedDateTime lhsRxFirstByteTime = lhs.rxFirst;
                    ZonedDateTime rhsRxFirstByteTime = rhs.rxFirst;
                    return lhsRxFirstByteTime.compareTo(rhsRxFirstByteTime);
                }
            });
            ZonedDateTime smallestFirstByteTime = null;
            ZonedDateTime rxFirstByteTime = this.httpSessions.get((int)0).rxFirst;
            if (rxFirstByteTime != null) {
                smallestFirstByteTime = rxFirstByteTime;
            }
            ZonedDateTime biggestLastByteTime = null;
            Long totalGapTime = 0L;
            Long totalRxBytes = 0L;
            for (Scenario.HttpEndpoint httpSession : this.httpSessions) {
                if (httpSession.rxLast != null && biggestLastByteTime == null) {
                    biggestLastByteTime = httpSession.rxLast;
                } else {
                    if (httpSession.rxFirst != null && httpSession.rxFirst.compareTo(biggestLastByteTime) > 0) {
                        totalGapTime = totalGapTime + this.timeDifference(httpSession.rxFirst, biggestLastByteTime, ChronoUnit.NANOS);
                    }
                    if (httpSession.rxLast != null && httpSession.rxLast.compareTo(biggestLastByteTime) > 0) {
                        biggestLastByteTime = httpSession.rxLast;
                    }
                }
                Long rxByteCount = httpSession.rxBytes;
                if (rxByteCount == null) continue;
                totalRxBytes = totalRxBytes + rxByteCount;
            }
            Long aliveDuration = 0L;
            if (biggestLastByteTime != null && smallestFirstByteTime != null) {
                aliveDuration = this.timeDifference(smallestFirstByteTime, biggestLastByteTime, ChronoUnit.NANOS);
            }
            Long activeDuration = aliveDuration - totalGapTime;
            double nanosToSecond = 1.0E-9;
            HashMap<String, Object> snapshot = new HashMap<String, Object>();
            snapshot.put("name", this.portName);
            snapshot.put("type", "Rx");
            snapshot.put("aggregate_bytes", totalRxBytes);
            snapshot.put("aggregate_alive_duration", nanosToSecond * (double)aliveDuration.longValue());
            snapshot.put("aggregate_alive_throughput", this.calculateThroughput(aliveDuration, totalRxBytes));
            snapshot.put("aggregate_active_duration", nanosToSecond * (double)activeDuration.longValue());
            snapshot.put("aggregate_active_throughput", this.calculateThroughput(activeDuration, totalRxBytes));
            snapshot.put("interval_results", this.fillTcpResults(this.portName));
            return snapshot;
        }

        public Collection<Object> fillTcpResults(String portName) {
            ScenarioWithPreferences results = this.report;
            ZonedDateTime startTime = results.firstMoment();
            List<Scenario.TcpEndpoint> endpoints = this.portsToSum.get(portName);
            if (endpoints.size() < 2) {
                return Collections.emptyList();
            }
            ArrayList<Object> line = new ArrayList<Object>();
            for (Scenario.TcpEndpoint ep : endpoints) {
                Scenario.TcpSnapshot[] tcpSnapshotArray = ep.overTimeResults;
                int n = ep.overTimeResults.length;
                int n2 = 0;
                while (n2 < n) {
                    Scenario.TcpSnapshot snap = tcpSnapshotArray[n2];
                    HashMap<String, Object> snapshot = new HashMap<String, Object>();
                    line.add(snapshot);
                    snapshot.put("A", TcpAggregation.getFlowName(ep, results));
                    long millis = ChronoUnit.MILLIS.between(startTime, snap.timestamp);
                    snapshot.put("B", millis);
                    snapshot.put("C", snap.rxTotal * 8L);
                    snapshot.put("D", ep.portName);
                    ++n2;
                }
            }
            return line;
        }

        private static String getFlowName(Scenario.TcpEndpoint ep, ScenarioWithPreferences results) {
            Scenario.HttpFlow[] httpFlows;
            Scenario.HttpFlow[] httpFlowArray = httpFlows = results.httpFlows;
            int n = httpFlows.length;
            int n2 = 0;
            while (n2 < n) {
                Scenario.HttpFlow httpFlow = httpFlowArray[n2];
                String post = "";
                if (httpFlow.tcpClient == ep) {
                    if ("PUT".equals(httpFlow.method)) {
                        post = " (ACKS)";
                    }
                    return String.valueOf(httpFlow.name) + post;
                }
                if (httpFlow.tcpServer == ep) {
                    if ("GET".equals(httpFlow.method)) {
                        post = " (ACKS)";
                    }
                    return String.valueOf(httpFlow.name) + post;
                }
                ++n2;
            }
            return null;
        }

        private double calculateThroughput(long timeInNs, long totalNofBytesReceived) {
            double throughputByteps = 0.0;
            if (timeInNs > 0L && totalNofBytesReceived > 0L) {
                throughputByteps = totalNofBytesReceived;
                throughputByteps *= 1.0E9;
                throughputByteps /= (double)timeInNs;
            }
            return 8.0 * throughputByteps;
        }

        protected Object createTxBean() {
            Scenario.HttpEndpoint session;
            Collections.sort(this.httpSessions, new Comparator<Scenario.HttpEndpoint>(){

                @Override
                public int compare(Scenario.HttpEndpoint lhs, Scenario.HttpEndpoint rhs) {
                    ZonedDateTime lhsTxFirstByteTime = lhs.txFirst;
                    ZonedDateTime rhsTxFirstByteTime = rhs.txFirst;
                    return lhsTxFirstByteTime.compareTo(rhsTxFirstByteTime);
                }
            });
            ZonedDateTime aggregateFirstTx = null;
            ZonedDateTime aggregateLastTx = null;
            long gapTime = 0L;
            long totalTxBytes = this.sumTxbytes();
            Iterator<Scenario.HttpEndpoint> sessionIt = this.httpSessions.iterator();
            if (sessionIt.hasNext()) {
                session = sessionIt.next();
                aggregateFirstTx = session.txFirst;
                aggregateLastTx = session.txLast;
            }
            while (sessionIt.hasNext()) {
                session = sessionIt.next();
                ZonedDateTime firstTx = session.txFirst;
                if (firstTx.isAfter(aggregateLastTx)) {
                    gapTime += this.timeDifference(aggregateLastTx, firstTx, ChronoUnit.NANOS);
                }
                if (!session.txLast.isAfter(aggregateLastTx)) continue;
                aggregateLastTx = session.txLast;
            }
            long aliveDuration = 0L;
            long activeDuration = 0L;
            if (totalTxBytes > 0L) {
                aliveDuration = this.timeDifference(aggregateFirstTx, aggregateLastTx, ChronoUnit.NANOS);
                activeDuration = aliveDuration - gapTime;
            }
            double nanosToSecond = 1.0E-9;
            HashMap<String, Object> snapshot = new HashMap<String, Object>();
            snapshot.put("name", this.portName);
            snapshot.put("type", "Tx");
            snapshot.put("aggregate_bytes", totalTxBytes);
            snapshot.put("aggregate_alive_duration", nanosToSecond * (double)aliveDuration);
            snapshot.put("aggregate_alive_throughput", this.calculateThroughput(aliveDuration, totalTxBytes));
            snapshot.put("aggregate_active_duration", nanosToSecond * (double)activeDuration);
            snapshot.put("aggregate_active_throughput", this.calculateThroughput(activeDuration, totalTxBytes));
            return snapshot;
        }

        private long sumTxbytes() {
            long transmitted = 0L;
            for (Scenario.HttpEndpoint session : this.httpSessions) {
                Long txSession = session.txBytes;
                if (txSession == null) continue;
                transmitted += txSession.longValue();
            }
            return transmitted;
        }

        static enum Direction {
            TX,
            RX;


            public Object getBean(TcpAggregation a) {
                switch (this) {
                    case RX: {
                        return a.createRxBean();
                    }
                    case TX: {
                        return a.createTxBean();
                    }
                }
                throw new IllegalStateException("Only supports Rx & Tx");
            }

            public Scenario.HttpEndpoint getRelevantSession(Scenario.HttpFlow httpFlow) {
                Scenario.HttpEndpoint receivingEndpoint;
                Scenario.HttpEndpoint sendingEndpoint;
                if ("GET".equals(httpFlow.method)) {
                    sendingEndpoint = httpFlow.httpServer;
                    receivingEndpoint = httpFlow.httpClient;
                } else if ("PUT".equals(httpFlow.method)) {
                    receivingEndpoint = httpFlow.httpServer;
                    sendingEndpoint = httpFlow.httpClient;
                } else {
                    throw new IllegalStateException("Only supports PUT & GET from ByteBlower API");
                }
                switch (this) {
                    case RX: {
                        return receivingEndpoint;
                    }
                    case TX: {
                        return sendingEndpoint;
                    }
                }
                throw new IllegalStateException("Only supports Rx & Tx");
            }
        }
    }
}

