/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator2;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.excentis.products.byteblower.report.generator.html2.generator2.Events;
import com.excentis.products.byteblower.report.generator.html2.generator2.TCPEmbeddedAggregate;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Logger;

public class TcpCollapsableTables {
    private static final String TEMPLATE_FILE = "html_templates_nov_2023/tcp_analysis.html";
    private static final Logger LOGGER = Logger.getGlobal();

    public static String generate(ScenarioWithPreferences results) {
        if (!TcpCollapsableTables.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Jinjava render = Util.get();
        String template = Util.load(TEMPLATE_FILE);
        context.put("tcp_results", TcpCollapsableTables.fillTcpRowResults(results));
        context.put("max_time", results.getMaxTime());
        context.put("aggregate_content", TCPEmbeddedAggregate.generate(results));
        return render.render(template, context);
    }

    static boolean shouldRender(Scenario data) {
        return data.httpFlows != null && data.httpFlows.length > 0;
    }

    private static Object fillTcpRowResults(ScenarioWithPreferences data) {
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        Scenario.HttpFlow[] httpFlowArray = data.httpFlows;
        int n = data.httpFlows.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<Object> graphData;
            ZonedDateTime end;
            Scenario.TcpEndpoint tcpDestination;
            Scenario.HttpEndpoint httpDestination;
            Scenario.TcpEndpoint tcpSource;
            Scenario.HttpEndpoint httpSource;
            Scenario.HttpFlow tcpFlow = httpFlowArray[n2];
            HashMap<String, Object> line = new HashMap<String, Object>();
            result.add(line);
            line.put("name", tcpFlow.name);
            line.put("status", tcpFlow.state);
            line.put("flow_warning", Events.hasWarning(data, tcpFlow.name));
            if ("PUT".equals(tcpFlow.method)) {
                httpSource = tcpFlow.httpClient;
                tcpSource = tcpFlow.tcpClient;
                httpDestination = tcpFlow.httpServer;
                tcpDestination = tcpFlow.tcpServer;
            } else {
                httpDestination = tcpFlow.httpClient;
                tcpDestination = tcpFlow.tcpClient;
                httpSource = tcpFlow.httpServer;
                tcpSource = tcpFlow.tcpServer;
            }
            line.put("source", httpSource.portName);
            line.put("destination", httpDestination.portName);
            TcpCollapsableTables.tableCongestionAlgo(line, tcpSource, tcpDestination);
            TcpCollapsableTables.tableRttValues(line, tcpSource);
            double duration = 0.0;
            if (httpDestination != null && httpDestination.rxFirst != null && httpDestination.rxLast != null) {
                ZonedDateTime start = httpDestination.rxFirst;
                end = httpDestination.rxLast;
                duration = (double)ChronoUnit.NANOS.between(start, end) / 1.0E9;
                line.put("duration", duration);
            } else if (httpSource != null && httpSource.txFirst != null && httpSource.txLast != null) {
                ZonedDateTime start = httpSource.txFirst;
                end = httpSource.txLast;
                duration = (double)ChronoUnit.NANOS.between(start, end) / 1.0E9;
                line.put("duration", duration);
                line.put("duration_postfix", " (Tx)");
            } else {
                line.put("duration", "N/A");
            }
            long configuredDuration = tcpFlow.duration;
            double timeMargin = 0.9;
            double nanosToSeconds = 1.0E-9;
            if (duration < (double)configuredDuration * (nanosToSeconds * timeMargin)) {
                line.put("duration_error", "class=\"error\"");
            }
            long throughputBytes = 0L;
            if (tcpFlow.clientIsMobile()) {
                if ("PUT".equals(tcpFlow.method)) {
                    line.put("rx_payload", tcpFlow.httpServer.rxBytes);
                    throughputBytes = tcpFlow.httpServer.rxBytes;
                } else {
                    line.put("tx_payload", tcpFlow.httpServer.txBytes);
                    throughputBytes = tcpFlow.httpServer.txBytes;
                }
            } else {
                line.put("tx_payload", httpSource.txBytes);
                line.put("rx_payload", httpDestination.rxBytes);
                throughputBytes = httpDestination.rxBytes;
            }
            if (duration > 0.0) {
                double throughput = (double)(8L * throughputBytes) / duration;
                line.put("avg_throughput", throughput);
            } else {
                line.put("avg_throughput", "N/A");
            }
            if (duration > 0.0 && !(graphData = TcpCollapsableTables.fillTcpGraphResults(data, tcpFlow)).isEmpty()) {
                line.put("tcp_graph", graphData);
            } else {
                line.put("tcp_graph", Collections.emptyList());
            }
            ++n2;
        }
        return result;
    }

    private static void tableCongestionAlgo(HashMap<String, Object> line, Scenario.TcpEndpoint tcpSource, Scenario.TcpEndpoint tcpDestination) {
        if (tcpSource != null) {
            line.put("congestion_algo", TcpCollapsableTables.humanFriendlyCongestionName(tcpSource.caa));
        } else if (tcpDestination != null) {
            line.put("congestion_algo", TcpCollapsableTables.humanFriendlyCongestionName(tcpDestination.caa));
        }
    }

    private static void tableRttValues(HashMap<String, Object> line, Scenario.TcpEndpoint tcpSource) {
        if (tcpSource == null) {
            line.put("min_rtt", "");
            line.put("max_rtt", "");
            return;
        }
        if (tcpSource.rttMinimum > 0L) {
            line.put("min_rtt", tcpSource.rttMinimum);
        } else {
            line.put("min_rtt", "");
        }
        if (tcpSource.rttMaximum > 0L) {
            line.put("max_rtt", tcpSource.rttMaximum);
        } else {
            line.put("max_rtt", "");
        }
    }

    private static Collection<Object> fillTcpGraphResults(Scenario data, Scenario.HttpFlow httpFlow) {
        long millis;
        HashMap<String, Object> snapshot;
        Object overTime;
        int n;
        int n2;
        Object[] objectArray;
        ZonedDateTime startMoment = data.firstMoment();
        ArrayList<Object> line = new ArrayList<Object>();
        Scenario.HttpEndpoint httpEndpoint = null;
        Scenario.TcpEndpoint tcpEndpoint = null;
        Scenario.TcpEndpoint sendingTcpEndpointForRTT = null;
        boolean isMobile = httpFlow.clientIsMobile();
        if (isMobile) {
            httpEndpoint = httpFlow.httpServer;
            tcpEndpoint = httpFlow.tcpServer;
            if ("GET".equals(httpFlow.method)) {
                sendingTcpEndpointForRTT = httpFlow.tcpServer;
            }
        } else if ("GET".equals(httpFlow.method)) {
            httpEndpoint = httpFlow.httpClient;
            tcpEndpoint = httpFlow.tcpClient;
            sendingTcpEndpointForRTT = httpFlow.tcpServer;
        } else if ("PUT".equals(httpFlow.method)) {
            httpEndpoint = httpFlow.httpServer;
            tcpEndpoint = httpFlow.tcpServer;
            sendingTcpEndpointForRTT = httpFlow.tcpClient;
        } else {
            String msg = String.format("Unknown HTTP Method: '%s'", httpFlow.method);
            LOGGER.warning(msg);
            return Collections.emptyList();
        }
        if (httpEndpoint != null) {
            objectArray = httpEndpoint.overTimeResults;
            n2 = httpEndpoint.overTimeResults.length;
            n = 0;
            while (n < n2) {
                overTime = objectArray[n];
                snapshot = new HashMap<String, Object>();
                line.add(snapshot);
                snapshot.put("A", httpFlow.name);
                snapshot.put("B", "X");
                snapshot.put("F", "X");
                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.HttpSnapshot)overTime).timestamp);
                snapshot.put("C", millis);
                if (isMobile) {
                    if ("GET".equals(httpFlow.method)) {
                        snapshot.put("D", ((Scenario.HttpSnapshot)overTime).txBytes * 8L);
                    } else if ("PUT".equals(httpFlow.method)) {
                        snapshot.put("D", ((Scenario.HttpSnapshot)overTime).rxBytes * 8L);
                    }
                } else {
                    snapshot.put("D", ((Scenario.HttpSnapshot)overTime).rxBytes * 8L);
                }
                ++n;
            }
        }
        if (tcpEndpoint != null) {
            objectArray = tcpEndpoint.overTimeResults;
            n2 = tcpEndpoint.overTimeResults.length;
            n = 0;
            while (n < n2) {
                overTime = objectArray[n];
                snapshot = new HashMap();
                line.add(snapshot);
                snapshot.put("A", httpFlow.name);
                snapshot.put("B", "V");
                snapshot.put("F", "V");
                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                snapshot.put("C", millis);
                if (isMobile) {
                    if ("GET".equals(httpFlow.method)) {
                        snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txTotal * 8L);
                    } else if ("PUT".equals(httpFlow.method)) {
                        snapshot.put("D", ((Scenario.TcpSnapshot)overTime).rxTotal * 8L);
                    }
                } else {
                    snapshot.put("D", ((Scenario.TcpSnapshot)overTime).rxTotal * 8L);
                }
                ++n;
            }
        }
        if (tcpEndpoint != null) {
            objectArray = tcpEndpoint.overTimeResults;
            n2 = tcpEndpoint.overTimeResults.length;
            n = 0;
            while (n < n2) {
                overTime = objectArray[n];
                snapshot = new HashMap();
                line.add(snapshot);
                snapshot.put("A", httpFlow.name);
                snapshot.put("B", "N");
                snapshot.put("F", "N");
                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                snapshot.put("C", millis);
                if (isMobile) {
                    if ("GET".equals(httpFlow.method)) {
                        snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txSegments);
                    } else if ("PUT".equals(httpFlow.method)) {
                        snapshot.put("D", ((Scenario.TcpSnapshot)overTime).rxSegments);
                    }
                } else {
                    snapshot.put("D", ((Scenario.TcpSnapshot)overTime).rxSegments);
                }
                ++n;
            }
        }
        if (tcpEndpoint != null && sendingTcpEndpointForRTT == null) {
            objectArray = tcpEndpoint.overTimeResults;
            n2 = tcpEndpoint.overTimeResults.length;
            n = 0;
            while (n < n2) {
                overTime = objectArray[n];
                snapshot = new HashMap();
                line.add(snapshot);
                snapshot.put("A", httpFlow.name);
                snapshot.put("B", "Q");
                snapshot.put("F", "Q");
                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                snapshot.put("C", millis);
                snapshot.put("D", ((Scenario.TcpSnapshot)overTime).localECNMarkings);
                ++n;
            }
        }
        if (sendingTcpEndpointForRTT != null) {
            objectArray = sendingTcpEndpointForRTT.overTimeResults;
            n2 = sendingTcpEndpointForRTT.overTimeResults.length;
            n = 0;
            while (n < n2) {
                overTime = objectArray[n];
                snapshot = new HashMap();
                line.add(snapshot);
                snapshot.put("A", httpFlow.name);
                snapshot.put("B", "T");
                snapshot.put("F", "T");
                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                snapshot.put("C", millis);
                snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txTotal == 0L ? null : Long.valueOf(((Scenario.TcpSnapshot)overTime).rttCurrent));
                ++n;
            }
            objectArray = sendingTcpEndpointForRTT.overTimeResults;
            n2 = sendingTcpEndpointForRTT.overTimeResults.length;
            n = 0;
            while (n < n2) {
                overTime = objectArray[n];
                snapshot = new HashMap();
                line.add(snapshot);
                snapshot.put("A", httpFlow.name);
                snapshot.put("B", "S");
                snapshot.put("F", "S");
                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                snapshot.put("C", millis);
                snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txTotal == 0L ? null : Long.valueOf(((Scenario.TcpSnapshot)overTime).rttMaximum));
                ++n;
            }
            objectArray = sendingTcpEndpointForRTT.overTimeResults;
            n2 = sendingTcpEndpointForRTT.overTimeResults.length;
            n = 0;
            while (n < n2) {
                overTime = objectArray[n];
                snapshot = new HashMap();
                line.add(snapshot);
                snapshot.put("A", httpFlow.name);
                snapshot.put("B", "R");
                snapshot.put("F", "R");
                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                snapshot.put("C", millis);
                snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txTotal == 0L ? null : Long.valueOf(((Scenario.TcpSnapshot)overTime).rttMinimum));
                ++n;
            }
            objectArray = sendingTcpEndpointForRTT.overTimeResults;
            n2 = sendingTcpEndpointForRTT.overTimeResults.length;
            n = 0;
            while (n < n2) {
                overTime = objectArray[n];
                snapshot = new HashMap();
                line.add(snapshot);
                snapshot.put("A", httpFlow.name);
                snapshot.put("B", "U");
                snapshot.put("F", "U");
                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                snapshot.put("C", millis);
                long receiveWindow = Math.min(((Scenario.TcpSnapshot)overTime).congestionWindowCurrent, ((Scenario.TcpSnapshot)overTime).receiverWindowCurrent);
                float byteToKb = 0.001f;
                snapshot.put("D", ((Scenario.TcpSnapshot)overTime).txTotal == 0L ? null : Float.valueOf(byteToKb * (float)receiveWindow));
                ++n;
            }
            objectArray = sendingTcpEndpointForRTT.overTimeResults;
            n2 = sendingTcpEndpointForRTT.overTimeResults.length;
            n = 0;
            while (n < n2) {
                overTime = objectArray[n];
                snapshot = new HashMap();
                line.add(snapshot);
                snapshot.put("A", httpFlow.name);
                snapshot.put("B", "Z");
                snapshot.put("F", "Z");
                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                snapshot.put("C", millis);
                long totalRetransmissions = ((Scenario.TcpSnapshot)overTime).fastRetransmissions + ((Scenario.TcpSnapshot)overTime).slowRetransmissions;
                snapshot.put("D", totalRetransmissions);
                ++n;
            }
            objectArray = sendingTcpEndpointForRTT.overTimeResults;
            n2 = sendingTcpEndpointForRTT.overTimeResults.length;
            n = 0;
            while (n < n2) {
                overTime = objectArray[n];
                snapshot = new HashMap();
                line.add(snapshot);
                snapshot.put("A", httpFlow.name);
                snapshot.put("B", "Q");
                snapshot.put("F", "Q");
                millis = ChronoUnit.MILLIS.between(startMoment, ((Scenario.TcpSnapshot)overTime).timestamp);
                snapshot.put("C", millis);
                snapshot.put("D", ((Scenario.TcpSnapshot)overTime).remoteECNMarkings);
                ++n;
            }
        }
        return line;
    }

    private static String humanFriendlyCongestionName(String input) {
        HashMap<String, String> translation = new HashMap<String, String>();
        translation.put("NONE", "None");
        translation.put("SACK", "SACK");
        translation.put("NEWRENO", "New Reno");
        translation.put("NEWRENO_WITH_CUBIC", "New Reno with cubic");
        translation.put("SACK_WITH_CUBIC", "SACK with cubic");
        return translation.getOrDefault(input, input);
    }
}

