/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.html2.generator2;

import com.excentis.products.byteblower.report.generator.html2.Scenario;
import com.excentis.products.byteblower.report.generator.html2.ScenarioWithPreferences;
import com.excentis.products.byteblower.report.generator.html2.generator.Util;
import com.hubspot.jinjava.Jinjava;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class WifiCollapsableTables {
    private static final String TEMPLATE_FILE = "html_templates_nov_2023/wifi_analysis.html";

    public static String generate(ScenarioWithPreferences results) {
        if (!WifiCollapsableTables.shouldRender(results)) {
            return "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Jinjava render = Util.get();
        String template = Util.load(TEMPLATE_FILE);
        context.put("wifi_results", WifiCollapsableTables.wifiResults(results));
        context.put("max_time", results.getMaxTime());
        return render.render(template, context);
    }

    private static boolean shouldRender(Scenario data) {
        return data.wifiStatistics != null && data.wifiStatistics.length > 0 && data.firstMoment() != null && data.lastMoment() != null;
    }

    private static Collection<Map<String, Object>> wifiResults(Scenario data) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Scenario.WifiStatistic[] wifiStatisticArray = data.wifiStatistics;
        int n = data.wifiStatistics.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.WifiStatistic wifi = wifiStatisticArray[n2];
            HashMap<String, Object> intermediate = new HashMap<String, Object>();
            intermediate.putAll(WifiCollapsableTables.wifiTableResults(data, wifi));
            if (!intermediate.isEmpty()) {
                result.add(intermediate);
            }
            ++n2;
        }
        return result;
    }

    private static Map<String, Object> wifiTableResults(Scenario data, Scenario.WifiStatistic wifi) {
        HashMap<String, Object> intermediate = new HashMap<String, Object>();
        if (wifi.overTimeResults.length == 0) {
            return intermediate;
        }
        intermediate.put("name", wifi.wirelessEndpoint);
        TreeSet<String> collectedSsid = new TreeSet<String>();
        TreeSet<String> collectedBssid = new TreeSet<String>();
        Scenario.WifiSample[] wifiSampleArray = wifi.overTimeResults;
        int n = wifi.overTimeResults.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.WifiSample snap = wifiSampleArray[n2];
            if (snap.ssid.isEmpty()) {
                collectedSsid.add("(no signal)");
            } else {
                collectedSsid.add(snap.ssid);
            }
            if (snap.bssid.isEmpty()) {
                collectedSsid.add("(no signal)");
            } else {
                collectedBssid.add(snap.bssid);
            }
            ++n2;
        }
        intermediate.put("ssid", String.join((CharSequence)", ", collectedSsid));
        intermediate.put("bssid", String.join((CharSequence)", ", collectedBssid));
        intermediate.put("overtime_results", WifiCollapsableTables.wifiResultsOverTime(data, wifi));
        return intermediate;
    }

    private static Object wifiResultsOverTime(Scenario data, Scenario.WifiStatistic wifi) {
        ZonedDateTime startMoment = data.firstMoment();
        String wirelessEndpoint = wifi.wirelessEndpoint;
        String networkInterface = wifi.networkInterface;
        ArrayList intermediate = new ArrayList();
        Scenario.WifiSample[] wifiSampleArray = wifi.overTimeResults;
        int n = wifi.overTimeResults.length;
        int n2 = 0;
        while (n2 < n) {
            Scenario.WifiSample snap = wifiSampleArray[n2];
            HashMap<String, Object> snapMap = new HashMap<String, Object>();
            long millis = ChronoUnit.MILLIS.between(startMoment, snap.timestamp);
            intermediate.add(snapMap);
            snapMap.put("rssi", snap.rssi);
            snapMap.put("bssid", snap.bssid);
            snapMap.put("ssid", snap.ssid);
            snapMap.put("net_if", networkInterface);
            snapMap.put("port_name", wirelessEndpoint);
            snapMap.put("time", millis);
            snapMap.put("name", WifiCollapsableTables.buildGraphTitle(wirelessEndpoint, networkInterface));
            ++n2;
        }
        return intermediate;
    }

    private static String buildGraphTitle(String endPointName, String netIf) {
        return String.format("%s - %s", endPointName, netIf);
    }
}

