
function strMinDigits(val, minSize) {
    let strVal = "" + val;
    let repeatCnt = minSize - strVal.length;
    let header = "";
    while (repeatCnt > 0) {
        repeatCnt--;
        header = header + "0";
    }
    return header + strVal;
}

// TODO push to general code.
// Reimplement to keep the HTML report size smaller.
function strToTime(total_milis) {
    if (total_milis <= 0) {
        // Explicit to make the rest of the code easier
        return "0s"
    }
    let total_seconds = Math.floor(total_milis / 1000);
    let total_minutes = Math.floor(total_seconds / 60);
    let total_hours = Math.floor(total_minutes / 60);
    let total_days = Math.floor(total_hours / 24);

    let millis = total_milis % 1000;
    let seconds = total_seconds % 60;
    let minutes = total_minutes % 60;
    let hours = total_hours % 24;
    let days = total_days;

    let to_combine = [];
    if (millis > 0) {
        to_combine.push(millis + "ms");
    }
    if (seconds > 0) {
        to_combine.push(seconds + "s");
    }
    if (minutes > 0) {
        to_combine.push(minutes + "m");
    }
    if (hours > 0) {
        to_combine.push(hours + "h");
    }
    if (days > 0) {
        to_combine.push(days + "d");
    }
    let str_result = "";
    for (let ctr = (to_combine.length - 1); ctr > 0; --ctr) {
        str_result += to_combine[ctr] + ", ";
    }
    if (to_combine.length > 0) {
        str_result += "" + to_combine[0];
    }
    return str_result;
}

const timeAxisText = 'Time [h:min:s]';

// Formats the timeaxis for Highcharts
// As listed in the time-axis header: HH:MM:SS
//
// timeAxisFormatter(0) -> "00:00:00"
// timeAxisFormatter(61000) -> "00:01:01"
//
// Non-integer seconds doen't match this Time-format,
// in these cases, "" is returned.
function timeAxisFormatter(total_millis) {
    let milliseconds = total_millis % 1000
    if (total_millis >= 0 && milliseconds === 0) {
        let seconds_part = (total_millis - milliseconds) % (1000 * 60)
        let seconds = seconds_part / 1000

        let minutes_part = (total_millis - (seconds_part + milliseconds)) % (1000 * 60 * 60)
        let minutes = minutes_part / (60 * 1000)

        let hours_part = (total_millis - (minutes_part + seconds_part + milliseconds))
        let hours = hours_part / (3600 * 1000)

        return this.strMinDigits(hours, 2) + ":" +
            this.strMinDigits(minutes, 2) + ":" +
            this.strMinDigits(seconds, 2)
    }
    return ""
}

 function get_latency_unit_name(unit) {
     if (unit === "NANO" || unit === "ns") {
         return "ns"
     } else if (unit === "MICRO" || unit === "us") {
         return "us"
     } else if (unit === "MILLI" || unit === "ms") {
         return "ms"
     }

     return "unit"
 }

 function no_conversion(a) {return a;}

 function conversion_function(unit) {
     // base units: bps or ns
     let conversion = no_conversion
     if(unit === "kbps" || unit === "MICRO") {
         conversion = function(val) {return val==null?null:val / 1e3;}
     } else if(unit === "Mbps" || unit === "MILLI") {
         conversion = function(val) {return val==null?null:val / 1e6;}
     } else if(unit === "Gbps") {
         conversion = function(val) {return val==null?null:val / 1e9;}
     }
     return conversion;
 }

 function conversion_function(unit) {
     // base units: bps or NANO
     let conversion = no_conversion;
     if (unit === "kbps" || unit === "MICRO") {
         conversion = function(val) {return val==null?null:val / 1e3;}
     } else if (unit === "Mbps" || unit === "MILLI") {
         conversion = function(val) {return val==null?null:val / 1e6;}
     } else if (unit === "Gbps") {
         conversion = function(val) {return val==null?null:val / 1e9;}
     } else if (unit === "ns") {
         conversion = function(val) {return val==null?null:val / 1e0;}
     } else if (unit === "us") {
         conversion = function(val) {return val==null?null:val / 1e3;}
     } else if (unit === "ms") {
         conversion = function(val) {return val==null?null:val / 1e6;}
     }
     return conversion;
 }

 const util = {
     excentisblue: '#169fdb',
     excentisorange: '#f07e31',
     excentisgreen: '#95c23d',
     excentishardblue: '#4565ad',
     excentisgrey: '#3c3c3c',
     excentisred: '#e73439',
     excentispink: '#f2908e',
     excentispurple: '#823f91',
     excentislightgrey: '#e6e6e6',
     excentisdarkgreen: '#6f8546',
     excentisdarkmint: '#468564',
     strMinDigits: strMinDigits,
     strToTime: strToTime,
     timeAxisText: timeAxisText,
     timeAxisFormatter: timeAxisFormatter,
     get_latency_unit_name: get_latency_unit_name,
     conversion_function: conversion_function
 }