//--- guru.js is integrated into results_over_time_highcharts.jrxml
function Chart(instanceData) {
    this.combinedSeries = instanceData.series;
    this.flow_type = instanceData.flow_type;
    this.parameter_data_rate_unit = instanceData.parameter_data_rate_unit;
    this.parameter_rtt_unit = instanceData.parameter_time_unit;
    this.parameter_max_time = instanceData.parameter_max_time;
    this.flow_name = "null";
    this.flow_name_is_set = false;

    this.series_throughput_name = "Throughput";
    this.series_goodput_name = "Goodput";
    this.series_retransmissions_name = "Retransmissions";
    this.series_round_trip_time_name = "Average Round Trip Time";
    this.series_round_trip_time_name_max = "Max Round Trip Time";
    this.series_round_trip_time_name_min = "Min Round Trip Time";
    this.series_window_name = "Transmit Window";
    this.series_ECN_name = "ECN Markings";
    this.series_segment_name = "Counted Segments";
}

function guru(instanceData) {
    let chart = new Chart(instanceData);
    let series = {
        series_throughput: [],
        series_goodput: [],
        series_segment_count: [],
        series_retransmissions: [],
        series_round_trip_time: [],
        series_round_trip_time_max: [],
        series_round_trip_time_min: [],
        series_window: [],
        series_ECN_markings: [],

        series_throughput_tooltips: new Map(),
        series_goodput_tooltips: new Map(),
        series_segment_count_tooltips: new Map(),
        series_retransmissions_tooltips: new Map(),
        series_round_trip_time_tooltips: new Map(),
        series_window_tooltips: new Map(),
        series_ECN_markings_tooltips: new Map(),
    };

    function separateSeries(value) {
        const value_flow_name = value.A;
        const value_series_name = value.B;
        const value_time = value.C;
        const value_value = value.D;
        const value_tooltip = value.E;

        // --- The flow name is available in every value of the series, but we need it to be set only once here :
        if (!chart.flow_name_is_set) {
            chart.flow_name = value_flow_name;
            chart.flow_name_is_set = true;
        }

        if (value.F === "Z") {
            // --- "Retransmissions"
            series.series_retransmissions.push([value_time, value_value]);
            series.series_retransmissions_tooltips.set(
                value_time,
                value_tooltip,
            );
        } else if (value.F === "Y" || value.F === "X") {
            // --- "Goodput"
            series.series_goodput.push([
                value_time,
                instanceData.throughput_conversion(value_value),
            ]);
            series.series_goodput_tooltips.set(value_time, value_tooltip);

            // --- initialise the series name
            if (typeof chart.series_goodput_name === "undefined") {
                if (value_series_name === "Y") {
                    // --- "Goodput (Tx)"
                    chart.series_goodput_name = "Goodput (Tx)";
                } else {
                    chart.series_goodput_name = "Goodput";
                }
            }
        } else if (value.F === "W" || value.F === "V") {
            // --- "Throughput"
            series.series_throughput.push([
                value_time,
                instanceData.throughput_conversion(value_value),
            ]);
            series.series_throughput_tooltips.set(value_time, value_tooltip);
            // --- initialise the series name
            if (typeof chart.series_throughput_name === "undefined") {
                if (value_series_name === "W") {
                    // --- "Throughput (Tx)"
                    chart.series_throughput_name = "Throughput (Tx)";
                } else {
                    chart.series_throughput_name = "Throughput";
                }
            }
        } else if (value.F == "N") {
            // -- "Number of packets"
            -series.series_segment_count.push([value_time, value_value]);
            -series.series_segment_count_tooltips.set(
                value_time,
                value_tooltip,
            );
        } else if (value.F === "U") {
            // --- "Receive Window"
            series.series_window.push([value_time, value_value]);
            series.series_window_tooltips.set(value_time, value_tooltip);
        } else if (value.F === "T") {
            // --- "Round Trip Time"
            series.series_round_trip_time.push([
                value_time,
                instanceData.latency_conversion(value_value),
            ]);
            series.series_round_trip_time_tooltips.set(
                value_time,
                value_tooltip,
            );
        } else if (value.F === "S") {
            // --- "Max Round Trip Time"
            series.series_round_trip_time_max.push([
                value_time,
                instanceData.latency_conversion(value_value),
            ]);
            series.series_round_trip_time_tooltips.set(
                value_time,
                value_tooltip,
            );
        } else if (value.F === "R") {
            // --- "Min Round Trip Time"
            series.series_round_trip_time_min.push([
                value_time,
                instanceData.latency_conversion(value_value),
            ]);
            series.series_round_trip_time_tooltips.set(
                value_time,
                value_tooltip,
            );
        } else if (value.F === "Q") {
            // --- "ECN markings"
            series.series_ECN_markings.push([value_time, value_value]);
            series.series_ECN_markings_tooltips.set(value_time, value_tooltip);
        }
    }

    chart.combinedSeries.forEach(separateSeries);

    let chart_settings = {
        title: {
            text: chart.flow_name,
        },
        boost: {
            useGPUTranslations: true,
            usePreAllocated: true,
        },
        credits: false,
        subtitle: false,
        chart: {
            width: 950,
            zoomType: "x",
            panning: true,
            panKey: "shift",
        },
        xAxis: {
            labels: {
                formatter: function () {
                    const milliseconds = this.value % 1000;
                    if (milliseconds === 0) {
                        let seconds_part =
                            (this.value - milliseconds) % (1000 * 60);
                        let seconds = seconds_part / 1000;

                        let minutes_part =
                            (this.value - (seconds_part + milliseconds)) %
                            (1000 * 60 * 60);
                        let minutes = minutes_part / (60 * 1000);

                        let hours_part =
                            this.value -
                            (minutes_part + seconds_part + milliseconds);
                        let hours = hours_part / (3600 * 1000);

                        return (
                            util.strMinDigits(hours, 2) +
                            ":" +
                            util.strMinDigits(minutes, 2) +
                            ":" +
                            util.strMinDigits(seconds, 2)
                        );
                    }

                    // Add a default return statement for other cases
                    return "";
                },
            },
            title: {
                text: "Time [h:min:s]",
            },
            min: 0,
            startOnTick: true,
            max: parseInt(chart.parameter_max_time),
        },
        yAxis: [
            {
                title: {
                    text: "Bitrate [" + chart.parameter_data_rate_unit + "]",
                },
            },
        ],
        tooltip: {
            formatter: function (tooltip) {
                let tooltipText = "";
                try {
                    tooltipText = tooltip.defaultFormatter.call(this, tooltip);
                    let time_text = "@ " + util.strToTime(this.x);
                    // Concatenate the time_text string
                    tooltipText += time_text;
                } catch (e) {
                    // Handle the exception if needed
                    console.log(e);
                }
                return tooltipText;
            },
            headerFormat: "",
            followTouchMove: false,
        },
        navigation: {
            buttonOptions: {
                enabled: false,
            },
        },
        series: [],
    };

    function addSeries(obj) {
        chart_settings.series.push(obj);
    }

    function addYAxis(obj) {
        chart_settings.yAxis.push(obj);
    }

    if (series.series_throughput.length > 0) {
        addSeries({
            animation: false,
            yAxis: 0,
            name: chart.series_throughput_name,
            data: series.series_throughput,
            zIndex: 3,
            color: util.excentisgrey,
            tooltip: {
                valueSuffix: chart.parameter_data_rate_unit,
                valueDecimals: 2,
            },
        });
    }

    if (series.series_goodput.length > 0) {
        addSeries({
            animation: false,
            visible: false,
            yAxis: 0,
            name: chart.series_goodput_name,
            data: series.series_goodput,
            zIndex: 4,
            color: util.excentisdarkmint,
            tooltip: {
                valueSuffix: chart.parameter_data_rate_unit,
                valueDecimals: 2,
            },
        });
    }

    if (series.series_retransmissions.length > 0) {
        let unit = "Retransmissions";
        addSeries({
            animation: false,
            yAxis: 1,
            name: chart.series_retransmissions_name,
            data: series.series_retransmissions,
            type: "column",
            zIndex: 0,
            color: util.excentispurple,
            tooltip: {
                valueSuffix: unit,
                valueDecimals: 2,
            },
        });
        addYAxis({
            id: 1,
            title: {
                text: unit,
                style: {
                    color: util.excentispurple,
                },
            },
            opposite: true,
        });
    }

    if (series.series_round_trip_time.length > 0) {
        addSeries({
            animation: false,
            yAxis: 2,
            name: chart.series_round_trip_time_name,
            data: series.series_round_trip_time,
            zIndex: 1,
            color: util.excentisgreen,
            tooltip: {
                valueSuffix: chart.parameter_rtt_unit,
                valueDecimals: 2,
            },
            marker: {
                symbol: "circle",
            },
        });

        addYAxis({
            id: 2,
            title: {
                text: "Round Trip Time [" + chart.parameter_rtt_unit + "]",
                style: {
                    color: util.excentisgreen,
                },
            },
            opposite: true,
        });
    }

    if (series.series_round_trip_time_max.length > 0) {
        addSeries({
            animation: false,
            visible: false,
            yAxis: 2,
            name: chart.series_round_trip_time_name_max,
            data: series.series_round_trip_time_max,
            zIndex: 1,
            color: util.excentisgreen,
            tooltip: {
                valueSuffix: chart.parameter_rtt_unit,
                valueDecimals: 2,
            },
            marker: {
                symbol: "triangle-down",
            },
        });
    }

    if (series.series_round_trip_time_min.length > 0) {
        addSeries({
            animation: false,
            visible: false,
            yAxis: 2,
            name: chart.series_round_trip_time_name_min,
            data: series.series_round_trip_time_min,
            zIndex: 1,
            color: util.excentisgreen,
            tooltip: {
                valueSuffix: chart.parameter_rtt_unit,
                valueDecimals: 2,
            },
            marker: {
                symbol: "triangle",
            },
        });
    }

    if (series.series_window.length > 0) {
        let unit = "KBytes";
        addSeries({
            animation: false,
            visible: false,
            yAxis: 3,
            name: chart.series_window_name,
            data: series.series_window,
            zIndex: 2,
            color: util.excentispink,
            tooltip: {
                valueSuffix: unit,
                valueDecimals: 2,
            },
        });

        addYAxis({
            title: {
                text: "Window [" + unit + "]",
                style: {
                    color: util.excentispink,
                },
            },
            opposite: true,
        });
    }

    if (series.series_ECN_markings.length > 0) {
        let unit = " ECN Markings";
        addSeries({
            animation: false,
            yAxis: 4,
            name: chart.series_ECN_name,
            data: series.series_ECN_markings,
            type: "column",
            zIndex: 3,
            color: util.excentisblue,
            tooltip: {
                valueSuffix: unit,
                valueDecimals: 0,
            },
        });

        addYAxis({
            id: 4,
            title: {
                text: unit,
                style: {
                    color: util.excentisblue,
                },
            },
            opposite: true,
        });
    }
    if (series.series_segment_count.length > 0) {
        let unit = "Segments";
        (addSeries({
            animation: false,
            yAxis: 5,
            name: chart.series_segment_name,
            data: series.series_segment_count,
            zIndex: 3,
            color: util.excentishardblue,
            tooltip: {
                valueSuffix: unit,
                valueDecimals: 2,
            },
        }),
            addYAxis({
                id: 5,
                title: {
                    text: unit,
                    style: {
                        color: util.excentisgrey,
                    },
                },
            }));
    }

    return chart_settings;
}
