class IconFactory {

    createIcon(classNames, viewBox, svgContent) {
        let icon = document.createElementNS("http://www.w3.org/2000/svg", "svg");

        if (Array.isArray(classNames)) {
            classNames.forEach(className => {
                icon.classList.add(className);
            });
        } else if (typeof classNames === 'string') {
            icon.classList.add(classNames);
        }

        icon.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        icon.setAttribute("viewBox", viewBox);
        icon.innerHTML = svgContent;

        return icon;
    }

    createStarIcon() {
        const classNames = ["icon-star", "icon-star-deselected", "hide", "btn-icon"];
        const viewBox = "0 0 16.4 15.6";
        const svgContent = "<path d=\"m8.2,1.62l1.57,4.84h5.09l-4.11,2.99,1.57,4.84-4.11-2.99-4.11,2.99,1.57-4.84L1.54,6.46h5.09l1.57-4.84Z\" fill=\"none\" stroke=\"#000000\" stroke-miterlimit=\"10\"/>"
        return this.createIcon(classNames, viewBox, svgContent);
    }

    createEyeClosedIcon() {
        const classNames = ["icon-eye-closed", "btn-icon"];
        const viewBox = "0 0 18.45 8.06";
        const svgContent = "<path d=\"m1.89,0.6c1.17,1.44,3.83,4.11,7.34,4.11s6.16-2.67,7.34-4.11\" fill=\"none\" stroke=\"#000000\" stroke-linecap=\"round\" stroke-width=\"1.2\"/><g><line x1=\"15.36\" y1=\"1.87\" x2=\"17.85\" y2=\"4.36\" fill=\"none\" stroke=\"#000000\" stroke-linecap=\"round\" stroke-width=\"1.2\"/><line x1=\"11.5\" y1=\"4.33\" x2=\"12.58\" y2=\"7.46\" fill=\"none\" stroke=\"#000000\" stroke-linecap=\"round\" stroke-width=\"1.2\"/><line x1=\"3.09\" y1=\"1.87\" x2=\".6\" y2=\"4.36\" fill=\"none\" stroke=\"#000000\" stroke-linecap=\"round\" stroke-width=\"1.2\"/><line x1=\"6.95\" y1=\"4.33\" x2=\"5.87\" y2=\"7.46\" fill=\"none\" stroke=\"#000000\" stroke-linecap=\"round\" stroke-width=\"1.2\"/>";
        return this.createIcon(classNames, viewBox, svgContent);
    }

    createEyeOpenIcon() {
        const classNames = ["icon-eye-open", "btn-icon"];
        const viewBox = "0 0 16.85 11.2";
        const svgContent = "<path d=\"m8.42,0.6C4.39,0.6,2.01,3.2,1,4.65c-.28,0.4-.41,0.59-.4,0.93c0.01,0.33,0.17,0.53,0.49,0.91c1.17,1.44,3.83,4.11,7.34,4.11s6.16-2.67,7.34-4.11c0.32-0.39,0.47-0.58,0.49-0.91c0.01-0.33-0.12-0.53-0.4-0.93c-1.01-1.45-3.38-4.05-7.42-4.05Z\" fill=\"none\" stroke=\"#000000\" stroke-width=\"1.2\"/><ellipse cx=\"8.42\" cy=\"5.6\" rx=\"2.4\" ry=\"2.14\" fill=\"none\" stroke=\"#000000\" stroke-width=\"1.2\"/>";
        return this.createIcon(classNames, viewBox, svgContent);
    }

    createCollapseIcon() {
        const classNames = ["btn-collapse", "btn-icon"];
        const viewBox = "0 0 42.23 25.42";
        const svgContent = "<polyline points=\"2.12 2.12 21.17 21.17 40.1 2.12\" fill=\"none\" stroke=\"#000\" stroke-miterlimit=\"10\" stroke-width=\"6\"/>"
        return this.createIcon(classNames, viewBox, svgContent);
    }

    createDragIcon() {
        const classNames = ["tr-drag-icon", "hide"];
        const viewBox = "0 0 7 32";
        const svgContent = "<rect y=\"24\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect y=\"30\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect x=\"5\" y=\"24\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect x=\"5\" y=\"30\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect y=\"6\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect x=\"5\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect x=\"5\" y=\"6\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect y=\"12\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect y=\"18\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect x=\"5\" y=\"12\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/><rect x=\"5\" y=\"18\" width=\"2\" height=\"2\" fill=\"#d9d9d9\" stroke-width=\"0\"/>"
        return this.createIcon(classNames, viewBox, svgContent);
    }

    createWarningIcon() {
        const className = ["flow-warning", "warning-icon"];
        const viewBox = "0 0 79.76 70.32";
        const svgContent = "<path d=\"M79.13,63.3l-17.6-30.48L43.94,2.34c-1.8-3.12-6.31-3.12-8.11,0l-17.6,30.48L.63,63.3c-1.8,3.12.45,7.02,4.05,7.02h70.39c3.6,0,5.86-3.9,4.05-7.02ZM42.57,56.61c-.65.64-1.54.96-2.69.96s-2.09-.31-2.73-.94c-.65-.62-.97-1.5-.97-2.64s.32-2.07.95-2.67c.63-.6,1.55-.9,2.76-.9s2.06.31,2.7.93c.64.62.96,1.5.96,2.65s-.32,1.98-.97,2.62ZM42.47,44.23h-5.13l-1.07-17.99h7.28l-1.07,17.99Z\" fill=\"#ffc06c\" stroke-width=\"0\"/>";
        return this.createIcon(className, viewBox, svgContent);
    }
}