function loadPage() {
    // Load the correct page
    const navItems = document.querySelectorAll('nav ul li');
    navItems.forEach(function(item) {
        // Check if the item is initially selected
        const selected = item.classList.contains('selected');
        // Get the target element ID from href
        const target = item.querySelector('a').getAttribute('href').substring(1);

        if (!selected) {
            // Hide all elements that does not have class selected
            document.getElementById(target).style.display = 'none';
        }

        item.addEventListener('click', function(event) {
            event.preventDefault();

            // Reset all selected classes
            navItems.forEach(function(item) {
                item.classList.remove('selected');
            });

            // Add selected class to the clicked item
            this.classList.add('selected');

            // Hide all elements with class .navLink
            let navLinks = document.querySelectorAll('.navLink');
            navLinks.forEach(function(link) {
                link.style.display = 'none';
            });

            // Show the target element
            document.getElementById(target).style.display = 'block';
        });
    });
}