document.addEventListener("DOMContentLoaded", () => {

    document.querySelectorAll('.loss-field').forEach(value => {
        // apply the correct class if needed
        color_loss(value);
        // round down % loss to 2 decimal places
        roundedPercentage(value);
    });
});

function roundedPercentage(element) {
    let roundedLoss = parseFloat(element.innerText).toFixed(2);
    if (!isNaN(roundedLoss)) {
        element.innerText = roundedLoss + "%";
    } else {
        element.innerText = "Not Set";
    }
}

// Coloring the loss percentages
function color_loss(element) {
    let txt = element.innerText;
    if (!isNaN(element.innerText)) {
        // Remove existing color classes
        element.classList.remove("low-warning", "moderate-warning", "severe-warning");
        let value = parseFloat(txt);

        if (value < 0) {
            element.classList.add("moderate-warning");
        } else if (warningLossLevel <= value && value < errorLossLevel) {
            element.classList.add("low-warning");
        } else if (errorLossLevel <= value) {
            element.classList.add("severe-warning");
        }
    }
}
