// Converting the duration fields to human readable text
function prettyDuration(value) {
	if (isNaN(value)) {
		return "N/A";
	}
	let total_nanos = value * 1e9;
	let total_micros = Math.floor(total_nanos / 1000);
	let total_millis = Math.floor(total_nanos / 1e6);
	let total_seconds = Math.floor(total_nanos / 1e9);
	let total_minutes = Math.floor(total_seconds / 60);
	let total_hours = Math.floor(total_minutes / 60);
	let total_days = Math.floor(total_hours / 24);

    // ByteBlower time resolution is limited to nanoseconds.
    // Fix rounding errors.
	let nanos = (total_nanos % 1000).toFixed(0);
	
	// Let's also avoid rounding errors in the other elements.
	let micros = (total_micros % 1000).toFixed();
	let millis = (total_millis % 1000).toFixed();
	let seconds = (total_seconds % 60).toFixed();
	let minutes = (total_minutes % 60).toFixed();
	let hours = (total_hours % 24).toFixed();
	let days = (total_days).toFixed();

	let to_combine = [];
	if (nanos > 0) {
		to_combine.push(nanos + "ns");
	}
	if (micros > 0) {
		to_combine.push(micros + "us");
	}
	if (millis > 0) {
		to_combine.push(millis + "ms");
	}
	if (seconds > 0) {
		to_combine.push(seconds + "s");
	}
	if (minutes > 0) {
		to_combine.push(minutes + "m");
	}
	if (hours > 0) {
		to_combine.push(hours + "h");
	}
	if (days > 0) {
		to_combine.push(days + "d");
	}
	let str_result = "";
	for (let ctr = (to_combine.length - 1); ctr > 0; --ctr) {
		str_result += to_combine[ctr] + ", ";
	}
	if (to_combine.length > 0) {
		str_result += "" + to_combine[0];
	} else {
		str_result = "0s";
	}
	return str_result;
}

function changeToPrettyDuration(element) {
	let txt = element.innerText;
	let value = parseFloat(txt);
	element.innerText = prettyDuration(value);
}

document.addEventListener("DOMContentLoaded", () => {
	const ALL_TIME_ELEMENTS = '.time-duration';
	document.querySelectorAll(ALL_TIME_ELEMENTS).forEach(value => {
		changeToPrettyDuration(value);
	});
});
