document.addEventListener("DOMContentLoaded", () => {
    let throughputHeaders = [];
    let throughputColumnCells = [];

    let latencyHeaders = [];
    let latencyColumnCells = [];

    let localeColumnCells = [];


    document.querySelectorAll('.throughput-header').forEach(header => {
        // push tuple of original value and the element
        throughputHeaders.push([header.innerText, header]);
    });

    document.querySelectorAll('.throughput-data').forEach(value => {
        throughputColumnCells.push([value.innerText, value]);
    });

    document.querySelectorAll('.locale-data').forEach(value => {
        localeColumnCells.push([value.innerText, value]);
    });

    document.querySelectorAll('.latency-header').forEach(header => {
        // push tuple of original value and the element
        latencyHeaders.push([header.innerText, header]);
    });

    document.querySelectorAll('.latency-data').forEach(value => {
        latencyColumnCells.push([value.innerText, value]);
    });

    // initialize throughput units
    let global_throughput_unit = "Mbps";
    update_throughput();

    // Initialize the latency unit:
    let global_latency_unit = "ms";
    let global_latency_unit_name = get_latency_unit_name();

    update_latency();

    // Update all locale values
    update_all_locales();

    // Bind click event to the throughput unit selectors
    const latencyUnitSelectors = document.querySelectorAll('.latency-units li');
    latencyUnitSelectors.forEach(function (selector) {
        selector.addEventListener('click', select_new_latency);
    });

    function update_throughput_headers() {
        for (let ctr = 0; ctr < throughputHeaders.length; ++ctr) {
            let pair = throughputHeaders[ctr];
            let orig_text = pair[0];
            let header = pair[1];
            header.innerText = orig_text + " (" + global_throughput_unit + ")";
        }
    }

    function update_throughput_values() {
        let conversion = conversion_function(global_throughput_unit);
        for (let ctr = 0; ctr < throughputColumnCells.length; ++ctr) {
            let pair = throughputColumnCells[ctr];
            let orig_val = parseFloat(pair[0].replace(",", "."));
            let cell = pair[1];
            if (!isNaN(orig_val)) { // Blank when not a number
                cell.innerText = conversion(orig_val).toFixed(throughput_decimals).toLocaleString(undefined, {maximumFractionDigits: "6"});
            } else {
                cell.innerText = "Not Set";
            }
        }
    }

    function update_latency() {
        global_latency_unit_name = get_latency_unit_name();
        update_latency_values();
        update_latency_headers();
    }

    function update_latency_headers() {
        for (let ctr = 0; ctr < latencyHeaders.length; ++ctr) {
            let pair = latencyHeaders[ctr];
            let orig_text = pair[0];
            let element = pair[1];
            element.innerText = orig_text + " (" + global_latency_unit_name + ")";
        }
    }

    function update_latency_values() {
        let conversion = conversion_function(global_latency_unit);
        for (let ctr = 0; ctr < latencyColumnCells.length; ++ctr) {
            let pair = latencyColumnCells[ctr];
            let orig_val = pair[0];
            let element = pair[1];
            if (!isNaN(Number.parseFloat(orig_val))) { // Blank when not a number
                let new_val = conversion(orig_val).toFixed(latency_decimals);
                element.innerText =
                    new_val.toLocaleString(
                        undefined, {maximumFractionDigits: "3"});
            }
        }
    }

    function update_throughput() {
        update_throughput_values();
        update_throughput_headers();
    }

    function update_all_locales() {
        for (let ctr = 0; ctr < localeColumnCells.length; ++ctr) {
            let pair = localeColumnCells[ctr];
            let orig_val = pair[0];
            let element = pair[1];            
            let new_val = parseFloat(orig_val);
            if(isNumber(new_val)) {
            	element.innerText = new_val.toLocaleString();
            }
        }
    }

    function select_new_throughput() {
        // Remove 'selected' class from all elements
        throughputUnitSelectors.forEach(selector => {
            selector.classList.remove('selected');
        });

        // Add 'selected' class to the clicked element
        this.classList.add('selected');

        // Get value of the clicked element
        global_throughput_unit = this.textContent;
        update_throughput();
    }

    function select_new_latency() {
        // Remove 'selected' class from all elements
        latencyUnitSelectors.forEach(selector => {
            selector.classList.remove('selected');
        });

        // Add 'selected' class to the clicked element
        this.classList.add('selected');

        global_latency_unit = this.textContent;
        update_latency();
    }

    // Bind click event to the throughput unit selectors
    const throughputUnitSelectors = document.querySelectorAll('.throughput-units li');
    throughputUnitSelectors.forEach(function (selector) {
        selector.addEventListener('click', select_new_throughput);
    });

    function no_conversion(a) {return a;}

    function isNumber(value) {
        return typeof value === 'number' && isFinite(value);
    }

    function conversion_function(unit) {
        // base units: bps or NANO
        let conversion = no_conversion;

        // check if unit is a number

        if (unit === "kbps") {
            conversion = function (val) {
                return val / 1e3;
            }
        } else if (unit === "Mbps") {
            conversion = function (val) {
                return val / 1e6;
            }
        } else if (unit === "Gbps") {
            conversion = function (val) {
                return val / 1e9;
            }
        } else if (unit === "ns") {
            conversion = function (val) {
                return val / 1e0;
            }
        } else if (unit === "us") {
            conversion = function (val) {
                return val / 1e3;
            }
        } else if (unit === "ms") {
            conversion = function (val) {
                return val / 1e6;
            }
        }
        return conversion;
    }

    function get_latency_unit_name() {
        if (global_latency_unit === "ns" || global_latency_unit === "NANO") {
            return "ns";
        } else if (global_latency_unit === "us" || global_latency_unit === "MICRO") {
            return "us";
        } else if (global_latency_unit === "ms" || global_latency_unit === "MILLI") {
            return "ms";
        }

        return "unit";
    }
});