let LatencyDistributionObject;
LatencyDistributionObject = LatencyDistributionObject || {};
LatencyDistributionObject.warnings = [];
LatencyDistributionObject.rendered_warnings = [];

LatencyDistributionObject.updateChartWarnings = function(chart) {

    LatencyDistributionObject.cleanupChartWarnings(chart);

    let show_warning = {};

    for (let idx = 0; idx < LatencyDistributionObject.warnings.length; idx++) {
        const message = LatencyDistributionObject.warnings[idx][1];
        const show = LatencyDistributionObject.warnings[idx][2];
        show_warning[message] |= show;
    }

    for (let message in show_warning) {
        const rendered_text = LatencyDistributionObject.getText(chart, message);
        const show = show_warning[message];

        if (show) {
            rendered_text.show();
        } else {
            rendered_text.hide();
        }
    }
}

LatencyDistributionObject.getText = function(chart, message) {
    let pos_y_offset = 0;
    for (let idx = 0; idx < LatencyDistributionObject.rendered_warnings.length; idx++) {
        if (LatencyDistributionObject.rendered_warnings[idx][0] === message) {
            return LatencyDistributionObject.rendered_warnings[idx][1];
        }
        pos_y_offset += 20;
    }

    return LatencyDistributionObject.render(chart, message, 220 + pos_y_offset);
}

LatencyDistributionObject.cleanupChartWarnings = function(chart) {
    for (let idx = 0; idx < LatencyDistributionObject.rendered_warnings.length; idx++) {
        let warning = LatencyDistributionObject.rendered_warnings[idx][1];
    }
    LatencyDistributionObject.rendered_warnings = [];
}

LatencyDistributionObject.render = function(chart, message, pos_y) {
    let warning = chart.renderer.text('Warning: ' + message, 90, pos_y)
        .attr({
            zIndex: 5
        })
        .css({
            fontSize: '12px',
            color: '#F7941C'
        })
        .on('click', function () {
            window.open("https://support.excentis.com/index.php?/Knowledgebase/Article/View/latency-cdf-ccdf#paragraph " + message);
        })
        .add();

    LatencyDistributionObject.rendered_warnings.push([message, warning]);

    return warning;
}

function gurudist(instanceData) {
    LatencyDistributionObject.warnings = [];

    function add_with_sufficient_rounding(a, b, start_rounding) {
        let result = a + b;
        let rounded = result.toFixed(start_rounding);
        let MAX_ROUNDING = 20;
        while (start_rounding < MAX_ROUNDING) {
            if (a !== rounded && b !== rounded) {
                return rounded;
            }
            start_rounding += 1;
            rounded = result.toFixed(start_rounding);
        }
        return result;
    }

    let combinedSeries = instanceData.series;
    let length = combinedSeries.length;

    // The two last items contain info about backets below or above the range:
    let nof_packets_below_min = combinedSeries[length - 2].B;
    let nof_packets_above_max = combinedSeries[length - 1].B;

    // and skip the last two objects from now on:
    length -= 2;

    let latency_conversion = instanceData.latency_conversion;

    let histogram_bins = [];
    let flowDestination = combinedSeries[0].C + " : " + combinedSeries[0].E;

    for (let idx = 0; idx < length; idx++) {
        // combinedSeries.forEach(function(element) {
        // A - x_value
        // B - y_value
        // C - flow_name
        // D - height
        // E - destination_name
        // F - tick_label
        let element = combinedSeries[idx];

        let value_x_value = latency_conversion(element.A);
        let value_y_value = element.B;

        if (value_x_value != null) {
            if (value_y_value != null) {
                histogram_bins.push([value_x_value, value_y_value]);
            }
        }
    }

    // Add warning:
    if (nof_packets_below_min > 0) {
        LatencyDistributionObject.warnings.push([flowDestination, nof_packets_below_min + " packets below range", true]);
    }
    if (nof_packets_above_max > 0) {
        LatencyDistributionObject.warnings.push([flowDestination, nof_packets_above_max + " packets above range", true]);
    }

    LatencyDistributionObject.cleanupChartWarnings();

    let bin_width = histogram_bins[1][0] - histogram_bins[0][0];

    let chart_settings = {
        title: {
            text: flowDestination
        },
        credits: false,
        subtitle: false,
        chart: {
            width: 950,
            animation: false,
            backgroundColor: "#ffffff",
            zoomType: 'x',
            panning: true,
            panKey: 'shift',
            type: 'column',
            events: {
                render: function () {
                    LatencyDistributionObject.updateChartWarnings(this);

                }
            }
        },
        tooltip: {
            useHTML: true,
            headerFormat: null,
            pointFormatter: function () {
                let y_value = this.y;
                let latency_bin = this.category.toFixed(3);
                let next_bin = add_with_sufficient_rounding(this.category, bin_width, 3);
                let pck_count = y_value.toFixed(0);
                let tooltiptext =
                    '<table><tr><td>Latency:</td><td><b>' + latency_bin + ' - ' + next_bin + ' ' + instanceData.parameter_time_unit + ' </b></td>' +
                    '<tr><td style="color:' + this.series.color + '"> ' + this.series.name + ':</td><td><b> ' + pck_count + '</b> frames</td></tr>' +
                    '</table>'
                return tooltiptext;
            },
            valueDecimals: 2
        },
        xAxis: [
            {
                title: {
                    text: 'Latency [' + instanceData.parameter_time_unit + ']'
                },
            }
        ],
        yAxis: {
            title: {
                text: 'Number Of Frames'
            },
            labels: {
                overflow: 'justify'
            }
        },
        series: [
            {
                animation: false,
                name: flowDestination,
                data: histogram_bins,
                color: util.excentisblue,
                showInLegend: false
            }
        ]
    };

    return chart_settings;
}
