function FbChart(instanceData) {
    this.combinedSeries = instanceData.series;
    this.flow_type = instanceData.flow_type;
    this.parameter_data_rate_unit = instanceData.parameter_data_rate_unit
    this.parameter_time_unit = instanceData.parameter_time_unit
    this.parameter_max_time = instanceData.parameter_max_time
    this.flow_name_and_destination_port = this.combinedSeries[0].H;

    this.series_throughput_name = "Throughput"
    this.series_average_name = "Average"
    this.series_minLat_name = "Minimum"
    this.series_maxLat_name = "Maximum"
    this.series_jitter_name = "Jitter"
    this.series_oos_name = "Out Of Sequence"

    this.separateSeries = function () {
        let series = {
            avgLat: [],
            minLat: [],
            maxLat: [],
            jitLat: [],
            throughput: [],
            oos: [],

            series_throughput_tooltips: new Map()
        }

        this.combinedSeries.forEach(function (element) {
            // A - results_over_time_series
            // B - results_over_time_time
            // C - results_over_time_average
            // D - results_over_time_minimum
            // E - results_over_time_maximum
            // F - results_over_time_avg_plus_jitter
            // G - results_over_time_avg_minus_jitter
            // H - results_over_time_chart_name
            // K - results_over_time_tooltip_text
            // L - results_over_time_series_type
            // M - results_over_time_throughput
            // N - results_over_time_outofsequence

            var time = element.B,
                value_latency_avg = instanceData.latency_conversion(element.C),
                value_latency_min = instanceData.latency_conversion(element.D),
                value_latency_max = instanceData.latency_conversion(element.E),
                value_latency_jit_max = instanceData.latency_conversion(element.F),
                value_latency_jit_min = instanceData.latency_conversion(element.G),
                value_tooltip = element.K,
                // L = element.L -> currently not used ?
                value_throughput = instanceData.throughput_conversion(element.M),
                value_out_of_sequence = element.N

            if (value_latency_avg != null) {
                series.avgLat.push([time, value_latency_avg])
            }
            if (value_latency_min != null) {
                series.minLat.push([time, value_latency_min])
            }
            if (value_latency_max != null) {
                series.maxLat.push([time, value_latency_max])
            }
            if (value_latency_jit_max != null && value_latency_jit_min != null) {
                series.jitLat.push([time, value_latency_jit_min, value_latency_jit_max])
            }
            if (value_throughput != null) {
                series.throughput.push([time, value_throughput])
                series.series_throughput_tooltips.set(time, value_tooltip);
            }
            if (value_out_of_sequence != null) {
                series.oos.push([time, value_out_of_sequence])
            }

        });
        return series;
    }
}

function gurufb(instanceData) {

    let chart = new FbChart(instanceData);
    let series = chart.separateSeries();

    const axisIndexThroughput = 0
    const axisIndexLatency = 1
    let axisIndexOos = 2

    let chart_settings = {

        title: {
            text: chart.flow_name_and_destination_port
        },
        subtitle: false,
        chart: {
            width: 950,
            zoomType: 'x',
            panning: true,
            panKey: 'shift'
        },
        xAxis: {
            labels: {
                formatter: function () {
                    return util.timeAxisFormatter(this.value);
                }
            },
            title: {
                text: util.timeAxisText
            },
            min: 0,         // Set the minimum value to 0
            startOnTick: true, // Start the axis on a tick to ensure zero is visible
            max: parseInt(chart.parameter_max_time)
        },
        yAxis: [
            {
                title: {
                    text: 'Bitrate [' + chart.parameter_data_rate_unit + ']'
                }/*
                  * , axisIndex: axisIndexThroughput
                  */
            }
        ],
        tooltip: {
            formatter: function (tooltip) {
                tooltipText = "";
                try {
                    tooltipText = tooltip.defaultFormatter.call(this, tooltip)
                    let time_text = "@ " + util.strToTime(this.x);
                    tooltipText.push(time_text);
                    //TODO What with OOS?
                    if (this.series.name === chart.series_oos_name) {

                    }
                } catch (e) {
                    tooltipText = tooltip.defaultFormatter.call(this, tooltip)
                }
                return tooltipText

            },
            headerFormat: '',
        },
        series: [
            {
                animation: false,
                yAxis: axisIndexThroughput,
                name: chart.series_throughput_name,
                data: series.throughput,
                zIndex: 5,
                color: util.excentisgrey,
                tooltip: {
                    valueSuffix: chart.parameter_data_rate_unit,
                    valueDecimals: 2
                }
            }
        ]
    }

    function addSeries(obj) {
        chart_settings.series.push(obj);
    }

    function addYAxis(obj) {
        chart_settings.yAxis.push(obj);
    }

    if (series.avgLat.length > 0 || series.jitLat.length > 0 || series.minLat.length > 0 || series.maxLat.length > 0) {
        // Occassionally the average latency is smaller than 0. This happens
        // often in long tests with the
        // Wireless Endpoints. In these cases we do whish to have a useful
        // graph.
        var actual_minimum = 0;
        let i;
        for (i = 0; i < series.minLat.length; i++) {
            let minLat = series.minLat[i]
            actual_minimum = Math.min(minLat[1], actual_minimum);
        }
        actual_minimum = Math.floor(actual_minimum)
        addYAxis({
            title: {
                text: 'Latency [' + chart.parameter_time_unit + ']',
                style: {
                    color: util.excentisgreen
                }
            },
            opposite: true,
            min: actual_minimum
        })
    } else {
        // put the oos axis in position 1 :
        axisIndexOos = 1
    }

    if (series.avgLat.length > 0) {
        addSeries({
            yAxis: 1,
            name: chart.series_average_name,
            data: series.avgLat,
            zIndex: 4,
            color: util.excentisgreen,
            tooltip: {
                valueSuffix: chart.parameter_time_unit,
                valueDecimals: 2
            }
        }
        )
    }

    if (series.jitLat.length > 0) {
        addSeries({
            visible: false,
            yAxis: 1,
            name: chart.series_jitter_name,
            data: series.jitLat,
            type: 'arearange',
            linkedTo: ':previous',
            lineWidth: 0,
            color: util.excentisgreen,
            fillOpacity: 0.2,
            zIndex: 1,
            marker: {
                enabled: false
            },
            showInLegend: true,
            tooltip: {
                valueSuffix: chart.parameter_time_unit,
                valueDecimals: 2
            }
        }
        )
    }

    if (series.minLat.length > 0) {
        addSeries({
            visible: false,
            yAxis: 1,
            name: chart.series_minLat_name,
            data: series.minLat,
            zIndex: 2,
            color: util.excentisgreen,
            symbol: 'circle',
            tooltip: {
                valueSuffix: chart.parameter_time_unit,
                valueDecimals: 2
            }
        }
        )
    }

    if (series.maxLat.length > 0) {
        addSeries({
            visible: false,
            yAxis: axisIndexLatency,
            name: chart.series_maxLat_name,
            data: series.maxLat,
            zIndex: 3,
            color: util.excentisgreen,
            tooltip: {
                valueSuffix: chart.parameter_time_unit,
                valueDecimals: 2
            }
        }
        )
    }

    if (series.oos.length > 0) {
        addYAxis({
            title: {
                text: 'Out Of Sequence [fps]',
                style: {
                    color: util.excentispink
                }
            },
            opposite: true/*
                             * , axisIndex: axisIndexOos //store the axis
                             * index, so that we can hide the axis title
                             * when all series using it are hidden
                             */
        })

        addSeries({
            yAxis: axisIndexOos,
            name: chart.series_oos_name,
            data: series.oos,
            type: 'column',
            zIndex: 0,
            color: util.excentispink
        }
        )
    }



    return chart_settings;
}
