//--- guru.js is integrated into results_over_time_highcharts.jrxml

function Chart(instanceData) {
    this.combinedSeries = instanceData.series[0];
    this.flow_type = instanceData.flow_type;
    this.parameter_data_rate_unit = instanceData.parameter_data_rate_unit
    this.parameter_rtt_unit = instanceData.parameter_time_unit
    this.parameter_max_time = instanceData.parameter_max_time
    this.flow_name = "null";
    this.flow_name_is_set = false

    this.series_throughput_name = "Throughput"
    this.series_goodput_name = "Goodput"
    this.series_retransmissions_name = "Retransmissions"
    this.series_round_trip_time_name = "Average Round Trip Time"
    this.series_round_trip_time_name_max = "Max Round Trip Time"
    this.series_round_trip_time_name_min = "Min Round Trip Time"
    this.series_window_name = "Transmit Window"
    this.series_ECN_name =  "Counted ECN Markings"
}

define('guru', ['bb_highcharts', 'excentis_util'], function (Highcharts, util) {
    return function (instanceData) {
        var chart = new Chart(instanceData);

        var series = {
            series_throughput: [],
            series_goodput: [],
            series_retransmissions: [],
            series_round_trip_time: [],
            series_round_trip_time_max: [],
            series_round_trip_time_min: [],
            series_window: [],
            series_ECN_markings: [],            

            series_throughput_tooltips: new Map(),
            series_goodput_tooltips: new Map(),
            series_retransmissions_tooltips: new Map(),
            series_round_trip_time_tooltips: new Map(),
            series_window_tooltips: new Map(),
            series_ECN_markings_tooltips: new Map()
        }

        // *** FIELDS REFERENCE ***
        // We are using very short names, to minimise the text size of the generated html
        // value.A is the results_over_time_flow_name
        // value.B is the results_over_time_series_name
        // value.C is the results_over_time_time
        // value.D is the results_over_time_value
        // value.E is the results_over_time_tooltip_text

        // value.F is the results type code:

        // See TcpHighchartsSeries for a list of all used series
        //  Retransmissions = "Z"; // --- "Retransmissions"
        //  GoodputTx = "Y"; // --- "Goodput (Tx)"
        //  Goodput = "X"; // --- "Goodput"
        //  ThroughputTx = "W"; // --- "Throughput (Tx)"
        //  Throughput = "V"; // --- "Throughput"
        //  ReceiveWindow = "U"; // --- "Receive Window"
        //  RoundTripTime = "T"; // --- "Round Trip Time"	
        //  Max_RoundTripTime = "S"; // --- "Max Round Trip Time"
        //  Min_RoundTripTime = "R"; // --- "Min Round Trip Time"
        //  ECN_markings = "Q"; // --- "Counted ECN markers"

        function separateSeries(value, index, array) {

            //			console.log(index + " = " + value.A + " - " + value.B + " - " + value.C + " - " + value.D + " - " + value.E + " - " + value.F)
            value_flow_name = value.A
            value_series_name = value.B
            value_time = value.C
            value_value = value.D
            value_tooltip = value.E

            // --- The flow name is available in every value of the series, but we need it to be set only once here :
            if (!chart.flow_name_is_set) {
                chart.flow_name = value_flow_name;
                chart.flow_name_is_set = true;
            }

            if (value.F == "Z") {// --- "Retransmissions"
                series.series_retransmissions.push([value_time, value_value]);
                series.series_retransmissions_tooltips.set(value_time, value_tooltip);
            } else if (value.F == "Y" || value.F == "X") { // --- "Goodput"
                series.series_goodput.push([value_time, instanceData.throughput_conversion(value_value)]);
                series.series_goodput_tooltips.set(value_time, value_tooltip);

                // --- initialise the series name
                if (typeof chart.series_goodput_name === 'undefined') {
                    if (value_series_name == "Y") {// --- "Goodput (Tx)"
                        chart.series_goodput_name = "Goodput (Tx)"
                    } else {
                        chart.series_goodput_name = "Goodput"
                    }
                }
            } else if (value.F == "W" || value.F == "V") { // --- "Throughput"
                series.series_throughput.push([value_time, instanceData.throughput_conversion(value_value)]);
                series.series_throughput_tooltips.set(value_time, value_tooltip);
                // --- initialise the series name
                if (typeof chart.series_throughput_name === 'undefined') {
                    if (value_series_name == "W") {// --- "Throughput (Tx)"
                        chart.series_throughput_name = "Throughput (Tx)"
                    } else {
                        chart.series_throughput_name = "Throughput"
                    }
                }
            } else if (value.F == "U") {// --- "Receive Window"
                series.series_window.push([value_time, value_value]);
                series.series_window_tooltips.set(value_time, value_tooltip);
            } else if (value.F == "T") {// --- "Round Trip Time"
                series.series_round_trip_time.push([value_time, instanceData.latency_conversion(value_value)]);
                series.series_round_trip_time_tooltips.set(value_time, value_tooltip);
            } else if (value.F == "S") {// --- "Max Round Trip Time"
                series.series_round_trip_time_max.push([value_time, instanceData.latency_conversion(value_value)]);
                series.series_round_trip_time_tooltips.set(value_time, value_tooltip);
            } else if (value.F == "R") {// --- "Min Round Trip Time"
                series.series_round_trip_time_min.push([value_time, instanceData.latency_conversion(value_value)]);
                series.series_round_trip_time_tooltips.set(value_time, value_tooltip);
            } else if (value.F == "Q") {// --- "ECN markings"
                series.series_ECN_markings.push([value_time, value_value]);
                series.series_ECN_markings_tooltips.set(value_time, value_tooltip);
            } else {
                //				console.log("UNUSED value : " + value.F)
            }

        }

        chart.combinedSeries.forEach(separateSeries);

        excentisblue = '#00AEEF'
        excentisorange = '#F7941C'
        excentisgreen = '#00A650'
        excentisgrey = '#8a8a8a'
        excentishardblue = '#0000C8'
        excentismagenta = '#EC008C'

        let chart_settings = { //instancedata.id is the DIV TAG id => there the chart will be generated

            title: {
                text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00AEEF; font-size: 20px; line-height: 1.2640625; ">' + chart.flow_name + '</span>'
            },
            subtitle: false,
            chart: {
                zoomType: 'x',
                panning: true,
                panKey: 'shift'
            },
            xAxis: {
                labels: {
                    formatter: function () {
                        milliseconds = this.value % 1000
                        if (milliseconds == 0) {
                            let seconds_part = (this.value - milliseconds) % (1000 * 60)
                            let seconds = seconds_part / 1000

                            let minutes_part = (this.value - (seconds_part + milliseconds)) % (1000 * 60 * 60)
                            let minutes = minutes_part / (60 * 1000)

                            let hours_part = (this.value - (minutes_part + seconds_part + milliseconds))
                            let hours = hours_part / (3600 * 1000)

                            return util.strMinDigits(hours, 2) + ":" +
                                util.strMinDigits(minutes, 2) + ":" +
                                util.strMinDigits(seconds, 2)
                        }
                    }
                },
                title: {
                    text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #F7941C; font-size: 12px; line-height: 1.4640625; font-weight: bold;">Time [h:min:s]</span>'
                },
				min: 0, // Set the minimum value to 0
        		startOnTick: true, // Start the axis on a tick to ensure zero is visible
				max: chart.parameter_max_time
            },
            yAxis: [
                {
                    title: {
                        text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00AEEF; font-size: 12px; line-height: 1.2640625; font-weight: bold; ">Bitrate [' + chart.parameter_data_rate_unit + ']</span>'
                    }
                },
            ],
            tooltip: {
                //enabled: true,
                //crosshairs: true,
                //shared: true, // conflicts with the formatter function
                //formatter
                formatter: function (tooltip) {
                    let tooltipText = ""
                    try {
                        tooltipText = tooltip.defaultFormatter.call(this, tooltip)
                        let time_text = "@ " + util.strToTime(this.x)
                        tooltipText.push(time_text)
                    } catch (e) { // --- if no tooltip is available catch and ignore the exception here
                        tooltipText = "";
                    }
                    return tooltipText

                },
                headerFormat: '',
                followTouchMove: false
            },
            legend: {
                borderColor: excentisblue,
                borderWidth: 1
            },

            navigation: {
                buttonOptions: {
                    enabled: false
                }
            },
            series: [
            ]
        }

        function addSeries(obj) {
            chart_settings.series.push(obj);
        }

        function addYAxis(obj) {
            chart_settings.yAxis.push(obj);
        }

        if (series.series_throughput.length > 0) {
            addSeries({
                yAxis: 0,
                name: chart.series_throughput_name,
                data: series.series_throughput,
                zIndex: 3,
                color: excentishardblue,
                tooltip: {
                    valueSuffix: chart.parameter_data_rate_unit,
                    valueDecimals: 2
                },
            })
        }

        if (series.series_goodput.length > 0) {
            addSeries({
                yAxis: 0,
                name: chart.series_goodput_name,
                data: series.series_goodput,
                zIndex: 4,
                color: excentisblue,
                tooltip: {
                    valueSuffix: chart.parameter_data_rate_unit,
                    valueDecimals: 2
                },
            })
        }

        if (series.series_retransmissions.length > 0) {
            let unit = "Retransmissions";
            addSeries({
                yAxis: 1,
                name: chart.series_retransmissions_name,
                data: series.series_retransmissions,
                type: 'column',
                zIndex: 0,
                color: excentisgrey,
                tooltip: {
                    valueSuffix: unit,
                    valueDecimals: 2
                },
            })
            addYAxis({
                id: 1,
                title: {
                    text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #8a8a8a; font-size: 12px; line-height: 1.2640625; font-weight: bold; ">' + unit + '</span><br>'
                },
                opposite: true
            })
        }        
        if (series.series_round_trip_time.length > 0) {
            addSeries({

                yAxis: 2,
                name: chart.series_round_trip_time_name,
                data: series.series_round_trip_time,
                zIndex: 1,
                color: excentisgreen,
                tooltip: {
                    valueSuffix: chart.parameter_rtt_unit,
                    valueDecimals: 2
                },
                marker: {
                    symbol: 'circle'
                }
            })

            addYAxis({
                id: 2,
                title: {
                    text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00a650; font-size: 12px; line-height: 1.2640625; font-weight: bold; ">Round Trip Time [' + chart.parameter_rtt_unit + ']</span><br>'
                },
                opposite: true
            }
            )
        }

        if (series.series_round_trip_time_max.length > 0) {
            addSeries({

                yAxis: 2,
                name: chart.series_round_trip_time_name_max,
                data: series.series_round_trip_time_max,
                zIndex: 1,
                color: excentisgreen,
                tooltip: {
                    valueSuffix: chart.parameter_rtt_unit,
                    valueDecimals: 2
                },
                marker: {
                    symbol: 'triangle-down'
                }
            })
        }

        if (series.series_round_trip_time_min.length > 0) {
            addSeries({

                yAxis: 2,
                name: chart.series_round_trip_time_name_min,
                data: series.series_round_trip_time_min,
                zIndex: 1,
                color: excentisgreen,
                tooltip: {
                    valueSuffix: chart.parameter_rtt_unit,
                    valueDecimals: 2
                },
                marker: {
                    symbol: 'triangle'
                }
            })
        }

        if (series.series_window.length > 0) {
            let unit = "KBytes";
            addSeries({
                yAxis: 3,
                name: chart.series_window_name,
                data: series.series_window,
                zIndex: 2,
                color: excentisorange,
                tooltip: {
                    valueSuffix: unit,
                    valueDecimals: 2,
                },
            })

            addYAxis({
                title: {
                    text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #F7941C; font-size: 12px; line-height: 1.2640625; font-weight: bold; ">Window [' + unit + ']</span><br>'
                },
                //type: 'logarithmic',
                opposite: true//,
                //min: 1
            })
        }
        
        if (series.series_ECN_markings.length > 0) {
			console.log(series.series_ECN_markings)
            let unit = " ECN Notifications";
            addSeries({
                yAxis: 4,
                name: chart.series_ECN_name,
                data: series.series_ECN_markings,
                type: 'column',
                zIndex: 3,
                color: excentismagenta,
                tooltip: {
                    valueSuffix: unit,
                    valueDecimals: 0
                },
            })
            addYAxis({
                id: 4,
                title: {
                    text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #EC008C; font-size: 12px; line-height: 1.2640625; font-weight: bold; ">' + unit + '</span><br>'
                },
                opposite: true
            })
        }


        Highcharts.chart(instanceData.id, chart_settings);
    };
});
