define('gurudist', ["require", 'excentis_util', 'bb_highcharts'], function (require, util) {
    var Highcharts = require('bb_highcharts');
    function add_with_sufficient_rounding(a, b, start_rounding) {
        let result = a + b
        let rounded = result.toFixed(start_rounding);
        let MAX_ROUNDING = 20
        while (start_rounding < MAX_ROUNDING) {
            if (a != rounded && b != rounded) {
                return rounded;
            }
            start_rounding += 1
            rounded = result.toFixed(start_rounding);
        }
        return result;
    }

    var chart_layer;
    var warnings = []
    var rendered_warnings = []

    function render(chart, message, pos_y) {
        let warning = chart.renderer.text('Warning: ' + message, 90, pos_y)
            .attr({
                zIndex: 5
            })
            .css({
                fontSize: '12px',
                color: '#F7941C'
            })
            .on('click', function () {
                window.open("https://support.excentis.com/index.php?/Knowledgebase/Article/View/latency-cdf-ccdf#paragraph " + message);
            })
            .add();
        rendered_warnings.push([message, warning])
        return warning
    }

    function cleanupChartWarnings(chart) {
        for (let idx = 0; idx < rendered_warnings.length; idx++) {
            warning = rendered_warnings[idx][1]
            warning.destroy()
        }
        rendered_warnings = []
    }

    function getText(chart, message) {
        let pos_y_offset = 0
        for (let idx = 0; idx < rendered_warnings.length; idx++) {
            if (rendered_warnings[idx][0] == message) {
                return rendered_warnings[idx][1]
            }
            pos_y_offset += 20
        }

        return render(chart, message, 220 + pos_y_offset)
    }

    function above_zero(val) {
        if (val <= 0) {
            return 1e-7
        } else {
            return val
        }
    }

    function updateChartWarnings(chart) {
        var show_warning = {};
        //		show_warning[warning_less_than_50_datapoints] = false;
        //		show_warning[warning_less_than_10000_packets] = false;
        //		show_warning[warning_packets_below_range] = false;
        //		show_warning[warning_packets_above_range] = false;
        //		show_warning[warning_packets_were_sampled] = false;

        for (let idx = 0; idx < warnings.length; idx++) {
            message = warnings[idx][1]
            rendered_text = getText(chart, message)
            show = warnings[idx][2]
            show_warning[message] |= show
        }

        for (var message in show_warning) {
            rendered_text = getText(chart, message)
            show = show_warning[message];

            if (show) {
                rendered_text.show()
            } else {
                rendered_text.hide()
            }
        }

		// Reset warnings:
		warnings = []
		rendered_warnings = []
    }

    var result = function (instanceData) {
        let combinedSeries = instanceData.series[0]
        let length = combinedSeries.length

        // The two last items contain info about backets below or above the range:
        let nof_packets_below_min = combinedSeries[length - 2].B
        let nof_packets_above_max = combinedSeries[length - 1].B

        // and skip the last two objects from now on:
        length -= 2

        let latency_conversion = instanceData.latency_conversion;


        let histogram_bins = [];
        let flowDestination = combinedSeries[0].C + " : " + combinedSeries[0].E;

        for (let idx = 0; idx < length; idx++) {
            //        combinedSeries.forEach(function(element) {
            //            A - x_value
            //            B - y_value
            //            C - flow_name
            //            D - height
            //            E - destination_name
            //            F - tick_label
            let element = combinedSeries[idx]

            let value_x_value = latency_conversion(element.A);
            let value_y_value = element.B;

            if (value_x_value != null) {
                if (value_y_value != null) {
                    histogram_bins.push([value_x_value, value_y_value])
                }
            }
        }

        // Add warning:
        if (nof_packets_below_min > 0) {
            warnings.push([flowDestination, nof_packets_below_min + " packets below range", true])
        }
        if (nof_packets_above_max > 0) {
            warnings.push([flowDestination, nof_packets_above_max + " packets above range", true])
        }

        let bin_width = histogram_bins[1][0] - histogram_bins[0][0]

        if (chart_layer != undefined) {
            cleanupChartWarnings(chart_layer)
        }

        chart_layer = Highcharts.chart(instanceData.id, {
            title: {
                text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00AEEF; font-size: 20px; line-height: 1.2640625; ">' + flowDestination + '</span>'
            },
            subtitle: false,
            chart: {
                zoomType: 'x',
                panning: true,
                panKey: 'shift',
                type: 'column'
            },
            tooltip: {
                useHTML: true,
                headerFormat: null,
                pointFormatter: function () {
                    let y_value = this.y
                    let latency_bin = this.category.toFixed(3)
                    let next_bin = add_with_sufficient_rounding(this.category, bin_width, 3)
                    let pck_count = y_value.toFixed(0)
                    let tooltiptext =
                        '<table><tr><td>Latency:</td><td><b>' + latency_bin + ' - ' + next_bin + ' ' + instanceData.parameter_time_unit + ' </b></td>' +
                        '<tr><td style="color:' + this.series.color + '"> ' + this.series.name + ':</td><td><b> ' + pck_count + '</b> frames</td></tr>' +
                        '</table>'
                    return tooltiptext
                },
                valueDecimals: 2
            },
            xAxis: [
                {
                    title: {
                        text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #F7941C; font-size: 12px; line-height: 1.4640625; font-weight: bold;">Latency [' + instanceData.parameter_time_unit + ']</span><br>'
                    },
                }
            ],
            yAxis: {
                title: {
                    text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00AEEF; font-size: 12px; line-height: 1.2640625; font-weight: bold; ">Number Of Frames</span>'
                },
                labels: {
                    overflow: 'justify'
                }
            },
            series: [
                {
                    name: flowDestination,
                    data: histogram_bins,
                    color: util.excentisblue,
                    showInLegend: false
                }
            ]
        })

        updateChartWarnings(chart_layer)

    }
    return result;
});
