/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper;

import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.generator.core.AbstractAction;
import com.excentis.products.byteblower.report.generator.core.ConcreteAction;
import com.excentis.products.byteblower.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;

class ExportReport
extends ConcreteAction<Listener> {
    private static final Logger LOGGER = Logger.getGlobal();
    private JasperPrint filledReport;
    private String reportOutputFile;
    private ReportOutputFormat outputFormat;
    private IProgressMonitor progressMonitor;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$report$data$entities$core$ReportOutputFormat = ExportReport.$SWITCH_TABLE$com$excentis$products$byteblower$report$data$entities$core$ReportOutputFormat();
    }

    private ExportReport(Listener listener, JasperPrint filledReport, String reportOutputFile, ReportOutputFormat outputFormat, IProgressMonitor progressMonitor) {
        super((Object)listener);
        this.filledReport = filledReport;
        this.reportOutputFile = reportOutputFile;
        this.outputFormat = outputFormat;
        this.progressMonitor = progressMonitor;
    }

    static AbstractAction create(Listener listener, JasperPrint filledReport, String reportOutputFile, ReportOutputFormat outputFormat, IProgressMonitor progressMonitor) {
        return new ExportReport(listener, filledReport, reportOutputFile, outputFormat, progressMonitor);
    }

    public String getDescription() {
        return "Export reports to file: " + this.reportOutputFile;
    }

    public void invokeImpl() {
        this.progressMonitor.subTask(this.outputFormat.getExtension());
        LOGGER.info("Exporting to " + this.outputFormat);
        this.export(this.outputFormat);
        this.progressMonitor.subTask(String.valueOf(this.outputFormat.getExtension()) + ": ready");
    }

    private void export(ReportOutputFormat outputFormat) {
        String outputFile = Utils.createUniqueReportFilename((String)this.reportOutputFile, (String)outputFormat.getExtension());
        try {
            switch (outputFormat) {
                case pdf: {
                    JasperExportManager.exportReportToPdfFile((JasperPrint)this.filledReport, (String)outputFile);
                    ((Listener)this.getListener()).onReportExported(outputFile, outputFormat);
                    break;
                }
                case deprecatedjasperhtml: {
                    this.exportHtml(outputFile);
                    this.filledReport = null;
                    this.postPorcessHtml(outputFile);
                    ((Listener)this.getListener()).onReportExported(outputFile, outputFormat);
                    break;
                }
                case xlsx: {
                    this.exportXlsx(outputFile);
                    ((Listener)this.getListener()).onReportExported(outputFile, outputFormat);
                    break;
                }
                case html: {
                    LOGGER.log(Level.INFO, "New reporting is used for HTML");
                    break;
                }
                default: {
                    LOGGER.log(Level.SEVERE, "Unsupported report format: " + outputFormat.toString());
                    break;
                }
            }
        }
        catch (IOException | JRException e) {
            ((Listener)this.getListener()).onReportExportFailed(outputFormat, (Exception)e);
            throw new ExportReportException((Exception)e);
        }
    }

    private void exportXlsx(String outputFile) throws JRException {
        JRXlsxExporter exporterXlsx = new JRXlsxExporter();
        exporterXlsx.setExporterInput((ExporterInput)new SimpleExporterInput(this.filledReport));
        exporterXlsx.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(outputFile));
        exporterXlsx.exportReport();
    }

    private void postPorcessHtml(String outputFile) throws IOException {
        boolean minified = false;
        File outputReportFile = new File(outputFile);
        String htmlOutput = FileUtils.readFileToString((File)outputReportFile);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileWriter writer = new FileWriter(outputReportFile);){
                int bodyPos = htmlOutput.indexOf("<body");
                String head = htmlOutput.substring(0, bodyPos);
                String body = htmlOutput.substring(bodyPos);
                htmlOutput = "";
                writer.append(head);
                head = "";
                writer.append(ExportReport.deserializeJs("require")).append(ExportReport.deserializeJs("cv-component")).append(ExportReport.deserializeJs("highcharts_guru")).append(ExportReport.deserializeJs("highcharts_more_guru")).append(ExportReport.deserializeJs("excentis_util")).append(ExportReport.deserializeJs("gurufb", false)).append(ExportReport.deserializeJs("guruaggrxtcp", false)).append(ExportReport.deserializeJs("guruoos", false)).append(ExportReport.deserializeJs("gurudist", false)).append(ExportReport.deserializeJs("guruccdf", false)).append(ExportReport.deserializeJs("guru", false)).append(ExportReport.deserializeJs("guruRssi", false));
                ExportReport.deleteScriptLinks(body).map(ExportReport::styleTable).forEachOrdered(line -> {
                    try {
                        writer.append((CharSequence)line);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to write line to the report", e);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            LOGGER.log(Level.WARNING, "Failed to write the report to file", e2);
        }
        String folder = String.valueOf(outputFile) + "_files";
        FileUtils.deleteDirectory((File)new File(folder));
    }

    private void exportHtml(String outputFile) throws JRException {
        HtmlExporter exporterHtml = new HtmlExporter();
        SimpleExporterInput exporterInput = new SimpleExporterInput(this.filledReport);
        exporterHtml.setExporterInput((ExporterInput)exporterInput);
        SimpleHtmlReportConfiguration configuration = new SimpleHtmlReportConfiguration();
        configuration.setIgnorePageMargins(Boolean.valueOf(true));
        exporterHtml.setConfiguration((ReportExportConfiguration)configuration);
        SimpleHtmlExporterOutput exporterOutput = new SimpleHtmlExporterOutput(outputFile){

            public HtmlResourceHandler getImageHandler() {
                return new HtmlResourceHandler(){
                    private Map<String, byte[]> imageMap = new HashMap<String, byte[]>();

                    public void handleResource(String id, byte[] data) {
                        this.imageMap.put(id, data);
                    }

                    public String getResourcePath(String id) {
                        return "data:image/png;base64," + Base64.encodeBase64String((byte[])this.imageMap.get(id));
                    }
                };
            }
        };
        exporterHtml.setExporterOutput((ExporterOutput)exporterOutput);
        exporterHtml.exportReport();
    }

    private static String styleTable(String line) {
        return line.replaceAll("table style=\"width: [0-9]*px", "table style=\"width: 100%").replaceAll("<td width=\"50%\">&nbsp;</td>", "");
    }

    private static Stream<String> deleteScriptLinks(String htmlContent) {
        BufferedReader file = new BufferedReader(new StringReader(htmlContent));
        return file.lines().map(line -> {
            if (line.contains("<script src=")) {
                return "";
            }
            return String.valueOf(line) + System.lineSeparator();
        });
    }

    private static String deserializeJs(String javascriptFilename) throws IOException {
        return ExportReport.deserializeJs(javascriptFilename, false);
    }

    private static String deserializeJs(String javascriptFilename, boolean minified) throws IOException {
        try {
            URL url = new URL("platform:/plugin/com.excentis.products.byteblower.report.generator.jasper/scripts/" + javascriptFilename + (minified ? ".min.js" : ".js"));
            InputStream inputStream = url.openConnection().getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            return in.lines().collect(Collectors.joining("\n", "<script>", "</script>"));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Couldn't load javascript code", e);
            return "";
        }
    }

    private static class ExportReportException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ExportReportException(Exception e) {
            super(e);
        }
    }

    public static interface Listener {
        public void onReportExported(String var1, ReportOutputFormat var2);

        public void onReportExportFailed(ReportOutputFormat var1, Exception var2);
    }
}

